/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;

public class SimpleAccessorReferenceSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(final ReferencesSearch.SearchParameters queryParameters, final Processor<PsiReference> consumer) {
        final PsiElement refElement = queryParameters.getElementToSearch();
        if (!(refElement instanceof PsiMethod)) {
            return true;
        }
        final PsiMethod method = (PsiMethod)refElement;
        String propertyName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                if (!method.isValid()) {
                    return null;
                }
                return PropertyUtil.getPropertyName((PsiMethod)method);
            }
        });
        if (StringUtil.isEmptyOrSpaces((String)propertyName)) {
            return true;
        }
        SearchScope searchScope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                SearchScope searchScope = queryParameters.getEffectiveSearchScope();
                if (searchScope instanceof GlobalSearchScope) {
                    searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{StdFileTypes.JSP, StdFileTypes.JSPX, StdFileTypes.XML, StdFileTypes.XHTML});
                }
                return searchScope;
            }
        });
        PsiSearchHelper helper = PsiManager.getInstance((Project)refElement.getProject()).getSearchHelper();
        TextOccurenceProcessor processor = new TextOccurenceProcessor(){

            public boolean execute(PsiElement element, int offsetInElement) {
                PsiReference[] refs;
                for (PsiReference ref : refs = element.getReferences()) {
                    if (!ref.getRangeInElement().contains(offsetInElement) || !ref.isReferenceTo(refElement)) continue;
                    return consumer.process((Object)ref);
                }
                return true;
            }
        };
        return helper.processElementsWithWord(processor, searchScope, propertyName, (short)8, false);
    }
}

