/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfoFactory;
import org.jetbrains.annotations.Nullable;

public class ImplicitVariableElementInfoFactory
implements SmartPointerElementInfoFactory {
    @Override
    @Nullable
    public SmartPointerElementInfo createElementInfo(PsiElement element) {
        if (element instanceof ImplicitVariable) {
            return new ImplicitVariableInfo((ImplicitVariable)element);
        }
        return null;
    }

    private static class ImplicitVariableInfo
    implements SmartPointerElementInfo {
        private final ImplicitVariable myVar;

        public ImplicitVariableInfo(ImplicitVariable var) {
            this.myVar = var;
        }

        @Override
        public PsiElement restoreElement() {
            PsiIdentifier psiIdentifier = this.myVar.getNameIdentifier();
            if (psiIdentifier == null || psiIdentifier.isValid()) {
                return this.myVar;
            }
            return null;
        }

        @Override
        @Nullable
        public Document getDocumentToSynchronize() {
            return null;
        }

        @Override
        public void documentAndPsiInSync() {
        }
    }
}

