/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.IdentitySmartPointer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.smartPointers.LazyPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private static final Key<ArrayList<WeakReference<SmartPointerEx>>> SMART_POINTERS_IN_PSI_FILE_KEY = Key.create((String)"SMART_POINTERS_IN_DOCUMENT_KEY");
    private static final Key<Boolean> BELTS_ARE_FASTEN_KEY = Key.create((String)"BELTS_ARE_FASTEN_KEY");
    private final Project myProject;

    public SmartPointerManagerImpl(Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fastenBelts(PsiFile file) {
        PsiFile psiFile = file;
        synchronized (psiFile) {
            if (SmartPointerManagerImpl.areBeltsFastened(file)) {
                return;
            }
            file.putUserData(BELTS_ARE_FASTEN_KEY, (Object)Boolean.TRUE);
            ArrayList pointers = (ArrayList)file.getUserData(SMART_POINTERS_IN_PSI_FILE_KEY);
            if (pointers == null) {
                return;
            }
            int index = 0;
            for (int i = 0; i < pointers.size(); ++i) {
                WeakReference reference = (WeakReference)pointers.get(i);
                SmartPointerEx pointer = (SmartPointerEx)reference.get();
                if (pointer == null) continue;
                pointer.fastenBelt();
                pointers.set(index++, reference);
            }
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file.getProject());
            for (DocumentWindow document : InjectedLanguageUtil.getCachedInjectedDocuments(file)) {
                PsiFile injectedfile = psiDocumentManager.getPsiFile((Document)document);
                if (injectedfile == null) continue;
                SmartPointerManagerImpl.fastenBelts(injectedfile);
            }
            int size = pointers.size();
            for (int i = size - 1; i >= index; --i) {
                pointers.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unfastenBelts(PsiFile file) {
        Set languages = file.getViewProvider().getLanguages();
        for (Language language : languages) {
            PsiFile f;
            PsiFile psiFile = f = file.getViewProvider().getPsi(language);
            synchronized (psiFile) {
                f.putUserData(BELTS_ARE_FASTEN_KEY, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void synchronizePointers(PsiFile file) {
        Set languages = file.getViewProvider().getLanguages();
        for (Language language : languages) {
            PsiFile f;
            PsiFile psiFile = f = file.getViewProvider().getPsi(language);
            synchronized (psiFile) {
                SmartPointerManagerImpl._synchronizePointers(f);
            }
        }
    }

    private static void _synchronizePointers(PsiFile file) {
        ArrayList pointers = (ArrayList)file.getUserData(SMART_POINTERS_IN_PSI_FILE_KEY);
        if (pointers == null) {
            return;
        }
        int index = 0;
        for (int i = 0; i < pointers.size(); ++i) {
            WeakReference reference = (WeakReference)pointers.get(i);
            SmartPointerEx pointer = (SmartPointerEx)reference.get();
            if (pointer == null) continue;
            pointer.documentAndPsiInSync();
            pointers.set(index++, reference);
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        for (DocumentWindow document : InjectedLanguageUtil.getCachedInjectedDocuments(file)) {
            PsiFile injectedfile = psiDocumentManager.getPsiFile((Document)document);
            if (injectedfile == null) continue;
            SmartPointerManagerImpl._synchronizePointers(injectedfile);
        }
        int size = pointers.size();
        for (int i = size - 1; i >= index; --i) {
            pointers.remove(i);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(E element) {
        Object object;
        PsiFile file;
        if (!element.isValid()) {
            LOG.error("Invalid element:" + element);
        }
        if (SmartPointerManagerImpl.isSafeReparseable(file = element.getContainingFile())) {
            object = new IdentitySmartPointer(element);
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.createSmartPsiElementPointer must not return null");
            return object;
        }
        SmartPsiElementPointerImpl<E> pointer = new SmartPsiElementPointerImpl<E>(this.myProject, element);
        this.initPointer(element, pointer);
        object = pointer;
        if (object != null) return object;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.createSmartPsiElementPointer must not return null");
    }

    private static boolean isSafeReparseable(PsiFile file) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends PsiElement> void initPointer(E element, SmartPointerEx<E> pointer) {
        PsiFile file = element.getContainingFile();
        if (file != null) {
            PsiFile psiFile = file;
            synchronized (psiFile) {
                ArrayList<WeakReference<SmartPointerEx<E>>> pointers;
                Document document = PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file);
                if (document != null && !(element instanceof PsiFile)) {
                    PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)this.myProject);
                    LOG.assertTrue(!documentManager.isUncommited(document) || documentManager.isCommittingDocument(document), (Object)("Document for : " + file + " is not committed"));
                }
                if ((pointers = (ArrayList<WeakReference<SmartPointerEx<E>>>)file.getUserData(SMART_POINTERS_IN_PSI_FILE_KEY)) == null) {
                    pointers = new ArrayList<WeakReference<SmartPointerEx<E>>>();
                    file.putUserData(SMART_POINTERS_IN_PSI_FILE_KEY, pointers);
                }
                pointers.add(new WeakReference<SmartPointerEx<E>>(pointer));
                if (SmartPointerManagerImpl.areBeltsFastened(file)) {
                    pointer.fastenBelt();
                }
            }
        }
    }

    private static boolean areBeltsFastened(PsiFile file) {
        return file.getUserData(BELTS_ARE_FASTEN_KEY) == Boolean.TRUE;
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createLazyPointer(E element) {
        LazyPointerImpl<E> pointer = new LazyPointerImpl<E>(element);
        this.initPointer(element, pointer);
        LazyPointerImpl<E> lazyPointerImpl = pointer;
        if (lazyPointerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.createLazyPointer must not return null");
        }
        return lazyPointerImpl;
    }
}

