/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.GenericReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassKind;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassReferenceProvider
extends GenericReferenceProvider
implements CustomizableReferenceProvider {
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> RESOLVE_QUALIFIED_CLASS_NAME = new CustomizableReferenceProvider.CustomizationKey(PsiBundle.message((String)"qualified.resolve.class.reference.provider.option", (Object[])new Object[0]));
    public static final CustomizableReferenceProvider.CustomizationKey<String[]> EXTEND_CLASS_NAMES = new CustomizableReferenceProvider.CustomizationKey("EXTEND_CLASS_NAMES");
    public static final CustomizableReferenceProvider.CustomizationKey<String> CLASS_TEMPLATE = new CustomizableReferenceProvider.CustomizationKey("CLASS_TEMPLATE");
    public static final CustomizableReferenceProvider.CustomizationKey<ClassKind> CLASS_KIND = new CustomizableReferenceProvider.CustomizationKey("CLASS_KIND");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> INSTANTIATABLE = new CustomizableReferenceProvider.CustomizationKey("INSTANTIATABLE");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> CONCRETE = new CustomizableReferenceProvider.CustomizationKey("CONCRETE");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> NOT_INTERFACE = new CustomizableReferenceProvider.CustomizationKey("NOT_INTERFACE");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> NOT_ENUM = new CustomizableReferenceProvider.CustomizationKey("NOT_ENUM");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> ADVANCED_RESOLVE = new CustomizableReferenceProvider.CustomizationKey("RESOLVE_ONLY_CLASSES");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> JVM_FORMAT = new CustomizableReferenceProvider.CustomizationKey("JVM_FORMAT");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> ALLOW_DOLLAR_NAMES = new CustomizableReferenceProvider.CustomizationKey("ALLOW_DOLLAR_NAMES");
    public static final CustomizableReferenceProvider.CustomizationKey<String> DEFAULT_PACKAGE = new CustomizableReferenceProvider.CustomizationKey("DEFAULT_PACKAGE");
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;
    private boolean myAllowEmpty;
    @Nullable
    private final GlobalSearchScope myScope;
    private final CachedValue<List<PsiElement>> myDefaltPackages;

    public JavaClassReferenceProvider(GlobalSearchScope scope, final Project project) {
        this.myScope = scope;
        this.myDefaltPackages = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<List<PsiElement>>(){

            public CachedValueProvider.Result<List<PsiElement>> compute() {
                PsiPackage rootPackage;
                PsiPackage defaultPackage;
                ArrayList psiPackages = new ArrayList();
                String defPackageName = DEFAULT_PACKAGE.getValue(JavaClassReferenceProvider.this.myOptions);
                if (StringUtil.isNotEmpty((String)defPackageName) && (defaultPackage = JavaPsiFacade.getInstance((Project)project).findPackage(defPackageName)) != null) {
                    psiPackages.addAll(JavaClassReferenceProvider.getSubPackages(defaultPackage));
                }
                if ((rootPackage = JavaPsiFacade.getInstance((Project)project).findPackage("")) != null) {
                    psiPackages.addAll(JavaClassReferenceProvider.getSubPackages(rootPackage));
                }
                return CachedValueProvider.Result.createSingleDependency(psiPackages, (Object)PsiModificationTracker.MODIFICATION_COUNT);
            }
        }, false);
    }

    public JavaClassReferenceProvider(Project project) {
        this(null, project);
    }

    public <T> void setOption(CustomizableReferenceProvider.CustomizationKey<T> option, T value) {
        if (this.myOptions == null) {
            this.myOptions = new THashMap();
        }
        option.putValue(this.myOptions, value);
    }

    @Nullable
    public <T> T getOption(CustomizableReferenceProvider.CustomizationKey<T> option) {
        return (T)(this.myOptions == null ? null : this.myOptions.get(option));
    }

    @Nullable
    public GlobalSearchScope getScope() {
        return this.myScope;
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReferenceProvider.getReferencesByElement must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReferenceProvider.getReferencesByElement must not be null");
        }
        PsiReference[] psiReferenceArray = this.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReferenceProvider.getReferencesByElement must not return null");
        }
        return psiReferenceArray;
    }

    public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReferenceProvider.getReferencesByElement must not be null");
        }
        int offsetInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        String text = ElementManipulators.getValueText((PsiElement)element);
        return this.getReferencesByString(text, element, offsetInElement);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferencesByString(String str, PsiElement position, int offsetInPosition) {
        PsiReference[] psiReferenceArray;
        if (this.myAllowEmpty && StringUtil.isEmpty((String)str)) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReferenceProvider.getReferencesByString must not return null");
            return psiReferenceArray;
        }
        boolean allowDollars = Boolean.TRUE.equals(this.getOption(ALLOW_DOLLAR_NAMES));
        psiReferenceArray = new JavaClassReferenceSet(str, position, offsetInPosition, allowDollars, this).getAllReferences();
        if (psiReferenceArray != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassReferenceProvider.getReferencesByString must not return null");
    }

    @Override
    public void handleEmptyContext(PsiScopeProcessor processor, PsiElement position) {
        ElementClassHint hint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (position == null) {
            return;
        }
        if (hint == null || hint.shouldProcess(ElementClassHint.DeclaractionKind.PACKAGE) || hint.shouldProcess(ElementClassHint.DeclaractionKind.CLASS)) {
            List<PsiElement> cachedPackages = this.getDefaultPackages();
            for (PsiElement psiPackage : cachedPackages) {
                if (processor.execute(psiPackage, ResolveState.initial())) continue;
                return;
            }
        }
    }

    protected List<PsiElement> getDefaultPackages() {
        return (List)this.myDefaltPackages.getValue();
    }

    private static Collection<PsiPackage> getSubPackages(PsiPackage defaultPackage) {
        return ContainerUtil.mapNotNull((Object[])defaultPackage.getSubPackages(), (Function)new NullableFunction<PsiPackage, PsiPackage>(){

            public PsiPackage fun(PsiPackage psiPackage) {
                String packageName = psiPackage.getName();
                return JavaPsiFacade.getInstance((Project)psiPackage.getProject()).getNameHelper().isIdentifier(packageName, PsiUtil.getLanguageLevel((PsiElement)psiPackage)) ? psiPackage : null;
            }
        });
    }

    @Override
    public void setOptions(@Nullable Map<CustomizableReferenceProvider.CustomizationKey, Object> options) {
        this.myOptions = options;
    }

    @Override
    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myOptions;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.myAllowEmpty = allowEmpty;
    }
}

