/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiElementArrayConstructor;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.CompositeElement");
    private TreeElement firstChild;
    private TreeElement lastChild;
    private volatile int myModificationsCount;
    private static final int NOT_CACHED = -239;
    private volatile int myCachedLength;
    private volatile int myHC;
    private volatile PsiElement myWrapper;

    public CompositeElement(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.<init> must not be null");
        }
        super(type);
        this.firstChild = null;
        this.lastChild = null;
        this.myModificationsCount = 0;
        this.myCachedLength = -239;
        this.myHC = -1;
        this.myWrapper = null;
    }

    public int getModificationCount() {
        return this.myModificationsCount;
    }

    @Override
    public Object clone() {
        CompositeElement clone = (CompositeElement)super.clone();
        clone.clearCaches();
        clone.firstChild = null;
        clone.lastChild = null;
        clone.myModificationsCount = 0;
        clone.myWrapper = null;
        for (TreeElement child = this.rawFirstChild(); child != null; child = child.getTreeNext()) {
            clone.rawAddChildren((TreeElement)child.clone());
        }
        return clone;
    }

    public void subtreeChanged() {
        for (CompositeElement compositeElement = this; compositeElement != null; compositeElement = compositeElement.getTreeParent()) {
            compositeElement.clearCaches();
            if (compositeElement instanceof PsiElement) continue;
            PsiElement psi = compositeElement.getPsi();
            if (psi instanceof ASTDelegatePsiElement) {
                ((ASTDelegatePsiElement)psi).subtreeChanged();
                continue;
            }
            if (!(psi instanceof PsiFile)) continue;
            ((PsiFile)psi).subtreeChanged();
        }
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedLength = -239;
        ++this.myModificationsCount;
        this.myHC = -1;
        CompositeElement.clearRelativeOffsets(this.rawFirstChild());
    }

    @Override
    public void acceptTree(TreeElementVisitor visitor) {
        visitor.visitComposite(this);
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        TreeElement child = this.getFirstChildNode();
        while (child != null) {
            int textLength = child.getTextLength();
            if (textLength > offset) {
                if (child instanceof ForeignLeafPsiElement) continue;
                return child.findLeafElementAt(offset);
            }
            offset -= textLength;
            child = child.getTreeNext();
        }
        return null;
    }

    public ASTNode findChildByType(IElementType type) {
        for (TreeElement element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (element.getElementType() != type) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet types) {
        if (types == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.findChildByType must not be null");
        }
        for (TreeElement element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!types.contains(element.getElementType())) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, ASTNode anchor) {
        if (typesSet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.findChildByType must not be null");
        }
        ASTNode child = anchor;
        while (child != null) {
            if (typesSet.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @NotNull
    public String getText() {
        char[] buffer = new char[this.getTextLength()];
        AstBufferUtil.toBuffer(this, buffer, 0);
        String string = new String(buffer);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositeElement.getText must not return null");
        }
        return string;
    }

    public CharSequence getChars() {
        char[] buffer = new char[this.getTextLength()];
        AstBufferUtil.toBuffer(this, buffer, 0);
        return new CharArrayCharSequence(buffer);
    }

    @Override
    public int getNotCachedLength() {
        int length = 0;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            length += child.getNotCachedLength();
        }
        return length;
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] buffer = new char[this.getTextLength()];
        AstBufferUtil.toBuffer(this, buffer, 0);
        if (buffer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositeElement.textToCharArray must not return null");
        }
        return buffer;
    }

    public boolean textContains(char c) {
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!child.textContains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(CharSequence buffer, int start) {
        int curOffset = start;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if ((curOffset = child.textMatches(buffer, curOffset)) != -1) continue;
            return -1;
        }
        return curOffset;
    }

    public final PsiElement findChildByRoleAsPsiElement(int role) {
        ASTNode element = this.findChildByRole(role);
        if (element == null) {
            return null;
        }
        return SourceTreeToPsiMap.treeElementToPsi(element);
    }

    @Nullable
    public ASTNode findChildByRole(int role) {
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.getChildRole(child) != role) continue;
            return child;
        }
        return null;
    }

    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this, (Object)child);
        return 0;
    }

    protected final int getChildRole(ASTNode child, int roleCandidate) {
        if (this.findChildByRole(roleCandidate) == child) {
            return roleCandidate;
        }
        return 0;
    }

    public ASTNode[] getChildren(TokenSet filter) {
        int count = this.countChildren(filter);
        if (count == 0) {
            return EMPTY_ARRAY;
        }
        ASTNode[] result = new ASTNode[count];
        count = 0;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            result[count++] = child;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public <T extends PsiElement> T[] getChildrenAsPsiElements(TokenSet filter, PsiElementArrayConstructor<T> constructor) {
        PsiElement[] psiElementArray;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = this.countChildren(filter);
        PsiElement[] result = constructor.newPsiElementArray(count);
        if (count == 0) {
            psiElementArray = result;
            if (result == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositeElement.getChildrenAsPsiElements must not return null");
            return psiElementArray;
        }
        int idx = 0;
        for (TreeElement child = this.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            PsiElement element = child.getPsi();
            LOG.assertTrue(element != null, (Object)child);
            result[idx++] = element;
        }
        psiElementArray = result;
        if (result != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/CompositeElement.getChildrenAsPsiElements must not return null");
    }

    public int countChildren(TokenSet filter) {
        int count = 0;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            ++count;
        }
        return count;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        Object anchorBefore = anchor != null ? (before != false ? anchor : anchor.getTreeNext()) : (before == null || before != false ? null : this.getFirstChildNode());
        return (TreeElement)CodeEditUtil.addChildren(this, first, last, anchorBefore);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.deleteChildInternal must not be null");
        }
        CodeEditUtil.removeChild(this, child);
    }

    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.replaceChildInternal must not be null");
        }
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.replaceChildInternal must not be null");
        }
        CodeEditUtil.replaceChild(this, child, newElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTextLength() {
        int cachedLength = this.myCachedLength;
        if (cachedLength >= 0) {
            return cachedLength;
        }
        String string = START_OFFSET_LOCK;
        synchronized (string) {
            cachedLength = this.myCachedLength;
            if (cachedLength >= 0) {
                return cachedLength;
            }
            this.walkCachingLength();
            return this.myCachedLength;
        }
    }

    @Override
    public int hc() {
        int hc = this.myHC;
        if (hc == -1) {
            hc = 0;
            for (TreeElement child = this.firstChild; child != null; child = child.getTreeNext()) {
                hc += child.hc();
            }
            this.myHC = hc;
        }
        return hc;
    }

    @Override
    public int getCachedLength() {
        return this.myCachedLength;
    }

    private void walkCachingLength() {
        TreeElement cur = this;
        while (cur != null) {
            cur = this.next(cur, ((TreeElement)cur).getCachedLength() == -239);
        }
        LOG.assertTrue(this.myCachedLength >= 0, (Object)this.myCachedLength);
    }

    @Nullable
    private TreeElement next(TreeElement cur, boolean down) {
        if (down) {
            CompositeElement composite = (CompositeElement)cur;
            TreeElement child = composite.firstChild;
            if (child != null) {
                LOG.assertTrue(child.getTreeParent() == composite, (Object)cur);
                return child;
            }
            composite.myCachedLength = 0;
        }
        while (cur != this) {
            CompositeElement parent = cur.getTreeParent();
            int curLength = cur.getCachedLength();
            LOG.assertTrue(curLength != -239, (Object)cur);
            parent.myCachedLength -= curLength;
            TreeElement next = cur.getTreeNext();
            if (next != null) {
                LOG.assertTrue(next.getTreePrev() == cur, (Object)cur);
                return next;
            }
            LOG.assertTrue(parent.lastChild == cur, (Object)parent);
            parent.myCachedLength = -parent.myCachedLength + -239;
            cur = parent;
        }
        return null;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return this.firstChild;
    }

    @Override
    public TreeElement getLastChildNode() {
        return this.lastChild;
    }

    public void setFirstChildNode(TreeElement firstChild) {
        this.firstChild = firstChild;
    }

    public void setLastChildNode(TreeElement lastChild) {
        this.lastChild = lastChild;
    }

    public void addChild(@NotNull ASTNode child, final ASTNode anchorBefore) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.addChild must not be null");
        }
        LOG.assertTrue(anchorBefore == null || ((TreeElement)anchorBefore).getTreeParent() == this, (Object)"anchorBefore == null || anchorBefore.getTreeParent() == parent");
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(child);
        TreeElement last = ((TreeElement)child).getTreeNext();
        final TreeElement first = (TreeElement)child;
        CompositeElement.removeChildrenInner(first, last);
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                if (anchorBefore != null) {
                    CompositeElement.insertBefore(destinationTreeChange, (TreeElement)anchorBefore, first);
                } else {
                    CompositeElement.add(destinationTreeChange, CompositeElement.this, first);
                }
            }
        }, this);
    }

    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.addLeaf must not be null");
        }
        FileElement holder = new DummyHolder(this.getManager(), null).getTreeElement();
        LeafElement leaf = ASTFactory.leaf(leafType, holder.getCharTable().intern(leafText));
        CodeEditUtil.setNodeGenerated(leaf, true);
        holder.rawAddChildren(leaf);
        this.addChild(leaf, anchorBefore);
    }

    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.addChild must not be null");
        }
        this.addChild(child, null);
    }

    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.removeChild must not be null");
        }
        CompositeElement.removeChildInner((TreeElement)child);
    }

    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.removeRange must not be null");
        }
        CompositeElement.removeChildrenInner((TreeElement)first, (TreeElement)firstWhichStayInTree);
    }

    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.replaceChild must not be null");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.replaceChild must not be null");
        }
        LOG.assertTrue(((TreeElement)oldChild).getTreeParent() == this);
        final TreeElement oldChild1 = (TreeElement)oldChild;
        TreeElement newChildNext = ((TreeElement)newChild).getTreeNext();
        final TreeElement newChild1 = (TreeElement)newChild;
        if (oldChild1 == newChild1) {
            return;
        }
        CompositeElement.removeChildrenInner(newChild1, newChildNext);
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                CompositeElement.replace(destinationTreeChange, oldChild1, newChild1);
                CompositeElement.repairRemovedElement(CompositeElement.this, oldChild1);
            }
        }, this);
    }

    public void replaceAllChildrenToChildrenOf(final ASTNode anotherParent) {
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(anotherParent.getFirstChildNode());
        final ASTNode firstChild1 = anotherParent.getFirstChildNode();
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                destinationTreeChange.addElementaryChange(anotherParent, (ChangeInfo)ChangeInfoImpl.create((short)3, anotherParent));
                ((CompositeElement)anotherParent).rawRemoveAllChildren();
            }
        }, (TreeElement)anotherParent);
        if (firstChild1 != null) {
            ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                @Override
                public void makeChange(TreeChangeEvent destinationTreeChange) {
                    if (CompositeElement.this.getTreeParent() != null) {
                        ChangeInfoImpl changeInfo = ChangeInfoImpl.create((short)3, CompositeElement.this);
                        changeInfo.setOldLength(CompositeElement.this.getTextLength());
                        destinationTreeChange.addElementaryChange((ASTNode)CompositeElement.this, (ChangeInfo)changeInfo);
                        CompositeElement.this.rawRemoveAllChildren();
                        CompositeElement.this.rawAddChildren((TreeElement)firstChild1);
                    } else {
                        TreeElement first = CompositeElement.this.getFirstChildNode();
                        CompositeElement.remove(destinationTreeChange, first, null);
                        CompositeElement.add(destinationTreeChange, CompositeElement.this, (TreeElement)firstChild1);
                        CompositeElement.repairRemovedElement(CompositeElement.this, first);
                    }
                }
            }, this);
        } else {
            this.removeAllChildren();
        }
    }

    public void removeAllChildren() {
        TreeElement child = this.getFirstChildNode();
        if (child != null) {
            this.removeRange(child, null);
        }
    }

    public void addChildren(ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        while (firstChild != lastChild) {
            ASTNode next1 = firstChild.getTreeNext();
            this.addChild(firstChild, anchorBefore);
            firstChild = next1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiElement getPsi() {
        PsiElement wrapper = this.myWrapper;
        if (wrapper != null) {
            return wrapper;
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            wrapper = this.myWrapper;
            if (wrapper != null) {
                return wrapper;
            }
            Language lang = this.getElementType().getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            if (parserDefinition != null) {
                this.myWrapper = wrapper = parserDefinition.createElement((ASTNode)this);
                LOG.assertTrue(wrapper != null, (Object)"ParserDefinition.createElement() may not return null");
            }
            return wrapper;
        }
    }

    public void setPsi(@NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.setPsi must not be null");
        }
        this.myWrapper = psi;
    }

    public void rawAddChildren(@NotNull TreeElement first) {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/CompositeElement.rawAddChildren must not be null");
        }
        TreeElement last = this.getLastChildNode();
        if (last == null) {
            this.setFirstChildNode(first);
            first.setTreePrev(null);
            while (true) {
                TreeElement treeNext = first.getTreeNext();
                first.setTreeParent(this);
                if (treeNext == null) break;
                first = treeNext;
            }
            this.setLastChildNode(first);
            first.setTreeParent(this);
        } else {
            last.rawInsertAfterMe(first);
        }
        if (DebugUtil.CHECK) {
            DebugUtil.checkTreeStructure(this);
        }
    }

    public void rawRemoveAllChildren() {
        TreeElement first = this.getFirstChildNode();
        if (first != null) {
            first.rawRemoveUpToLast();
        }
    }

    private static void repairRemovedElement(CompositeElement oldParent, TreeElement oldChild) {
        if (oldChild == null) {
            return;
        }
        FileElement treeElement = DummyHolderFactory.createHolder((PsiManager)oldParent.getManager(), null, false).getTreeElement();
        treeElement.rawAddChildren(oldChild);
    }

    private static void add(TreeChangeEvent destinationTreeChange, CompositeElement parent, TreeElement first) {
        parent.rawAddChildren(first);
        for (TreeElement child = first; child != null; child = child.getTreeNext()) {
            destinationTreeChange.addElementaryChange((ASTNode)child, (ChangeInfo)ChangeInfoImpl.create((short)0, child));
        }
    }

    private static void remove(TreeChangeEvent destinationTreeChange, TreeElement first, TreeElement last) {
        if (first != null) {
            for (TreeElement child = first; child != last && child != null; child = child.getTreeNext()) {
                destinationTreeChange.addElementaryChange((ASTNode)child, (ChangeInfo)ChangeInfoImpl.create((short)1, child));
            }
            first.rawRemoveUpTo(last);
        }
    }

    private static void insertBefore(TreeChangeEvent destinationTreeChange, TreeElement anchorBefore, TreeElement first) {
        anchorBefore.rawInsertBeforeMe(first);
        for (TreeElement child = first; child != anchorBefore; child = child.getTreeNext()) {
            destinationTreeChange.addElementaryChange((ASTNode)child, (ChangeInfo)ChangeInfoImpl.create((short)0, child));
        }
    }

    private static void replace(TreeChangeEvent sourceTreeChange, TreeElement oldChild, TreeElement newChild) {
        oldChild.rawReplaceWithList(newChild);
        ReplaceChangeInfoImpl change = (ReplaceChangeInfoImpl)ChangeInfoImpl.create((short)2, newChild);
        sourceTreeChange.addElementaryChange((ASTNode)newChild, (ChangeInfo)change);
        change.setReplaced(oldChild);
    }

    private static void removeChildInner(TreeElement child) {
        CompositeElement.removeChildrenInner(child, child.getTreeNext());
    }

    private static void removeChildrenInner(final TreeElement first, final TreeElement last) {
        final FileElement fileElement = TreeUtil.getFileElement(first);
        if (fileElement != null) {
            ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                @Override
                public void makeChange(TreeChangeEvent destinationTreeChange) {
                    CompositeElement.remove(destinationTreeChange, first, last);
                    CompositeElement.repairRemovedElement((CompositeElement)fileElement, first);
                }
            }, first.getTreeParent());
        } else {
            first.rawRemoveUpTo(last);
        }
    }

    public TreeElement rawFirstChild() {
        return this.firstChild;
    }

    public TreeElement rawLastChild() {
        return this.lastChild;
    }
}

