/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertyFileIndex
extends ScalarIndexExtension<String> {
    public static boolean DEBUG = false;
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"PropertyFileIndex");
    private final MyDataIndexer myDataIndexer = new MyDataIndexer();
    private final MyInputFilter myInputFilter = new MyInputFilter();
    private final KeyDescriptor<String> myKeyDescriptor = new KeyDescriptor<String>(){

        public int getHashCode(String value) {
            return value.hashCode();
        }

        public boolean isEqual(String val1, String val2) {
            return val1.equals(val2);
        }

        public void save(DataOutput out, String value) throws IOException {
            out.writeUTF(value);
        }

        public String read(DataInput in) throws IOException {
            return in.readUTF();
        }
    };

    @Override
    public ID<String, Void> getName() {
        return NAME;
    }

    @Override
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return this.myDataIndexer;
    }

    @Override
    public KeyDescriptor<String> getKeyDescriptor() {
        return this.myKeyDescriptor;
    }

    @Override
    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myInputFilter;
    }

    @Override
    public boolean dependsOnFileContent() {
        return false;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private static class MyInputFilter
    implements FileBasedIndex.InputFilter {
        private MyInputFilter() {
        }

        @Override
        public boolean acceptInput(VirtualFile file) {
            return !(StdFileTypes.PROPERTIES instanceof PlainTextFileType) && file.getFileType() == StdFileTypes.PROPERTIES;
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @Override
        @NotNull
        public Map<String, Void> map(FileContent inputData) {
            FileType fileType = inputData.getFileType();
            if (DEBUG) {
                System.out.println("FileTypeIndex$MyDataIndexer.map");
                System.out.println("inputData.getFile() = " + inputData.getFile().getPath());
                System.out.println("fileType = " + fileType);
            }
            Map<String, Object> map = Collections.singletonMap(fileType.getName(), null);
            if (map == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/search/PropertyFileIndex$MyDataIndexer.map must not return null");
            }
            return map;
        }
    }
}

