/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoImpl
implements ParameterInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.ParameterInfoImpl");
    public final int oldParameterIndex;
    boolean useAnySingleVariable;
    private String name = "";
    private CanonicalTypes.Type myType;
    String defaultValue = "";

    public ParameterInfoImpl(int oldParameterIndex) {
        this.oldParameterIndex = oldParameterIndex;
    }

    public ParameterInfoImpl(int oldParameterIndex, @NonNls String name, PsiType aType) {
        this.setName(name);
        this.oldParameterIndex = oldParameterIndex;
        this.setType(aType);
    }

    public ParameterInfoImpl(int oldParameterIndex, @NonNls String name, PsiType aType, @NonNls String defaultValue) {
        this(oldParameterIndex, name, aType, defaultValue, false);
    }

    public ParameterInfoImpl(int oldParameterIndex, @NonNls String name, PsiType aType, @NonNls String defaultValue, boolean useAnyVariable) {
        this(oldParameterIndex, name, aType);
        this.defaultValue = defaultValue;
        this.useAnySingleVariable = useAnyVariable;
    }

    public int getOldIndex() {
        return this.oldParameterIndex;
    }

    public void setUseAnySingleVariable(boolean useAnySingleVariable) {
        this.useAnySingleVariable = useAnySingleVariable;
    }

    public void updateFromMethod(PsiMethod method) {
        if (this.getTypeWrapper() != null) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        LOG.assertTrue(this.oldParameterIndex >= 0 && this.oldParameterIndex < parameters.length);
        PsiParameter parameter = parameters[this.oldParameterIndex];
        this.setName(parameter.getName());
        this.setType(parameter.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterInfoImpl)) {
            return false;
        }
        ParameterInfoImpl parameterInfo = (ParameterInfoImpl)o;
        if (this.oldParameterIndex != parameterInfo.oldParameterIndex) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(parameterInfo.defaultValue) : parameterInfo.defaultValue != null) {
            return false;
        }
        if (!this.getName().equals(parameterInfo.getName())) {
            return false;
        }
        return this.getTypeText().equals(parameterInfo.getTypeText());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 29 * result + this.getTypeText().hashCode();
        return result;
    }

    public String getTypeText() {
        if (this.getTypeWrapper() != null) {
            return this.getTypeWrapper().getTypeText();
        }
        return "";
    }

    public PsiType createType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
        if (this.getTypeWrapper() != null) {
            return this.getTypeWrapper().getType(context, manager);
        }
        return null;
    }

    public void setType(PsiType type) {
        this.myType = CanonicalTypes.createTypeWrapper(type);
    }

    public String getName() {
        return this.name;
    }

    public CanonicalTypes.Type getTypeWrapper() {
        return this.myType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isVarargType() {
        return this.getTypeText().endsWith("...");
    }

    public static ParameterInfoImpl[] fromMethod(PsiMethod method) {
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            result.add(new ParameterInfoImpl(i, parameter.getName(), parameter.getType()));
        }
        return result.toArray(new ParameterInfoImpl[result.size()]);
    }

    @Nullable
    public PsiExpression getValue(PsiCallExpression expr) throws IncorrectOperationException {
        return JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory().createExpressionFromText(this.defaultValue, (PsiElement)expr);
    }

    public boolean isUseAnySingleVariable() {
        return this.useAnySingleVariable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

