/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.ui.VisibilityPanel;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ExtractMethodDialog
extends AbstractExtractDialog {
    private final Project myProject;
    private final PsiType myReturnType;
    private final PsiTypeParameterList myTypeParameterList;
    private final PsiType[] myExceptions;
    private final boolean myStaticFlag;
    private final boolean myCanBeStatic;
    private final PsiElement[] myElementsToExtract;
    private final String myHelpId;
    private final EditorTextField myNameField;
    private final JTextArea mySignatureArea;
    private final JCheckBox myCbMakeStatic;
    protected JCheckBox myCbMakeVarargs;
    private JCheckBox myCbChainedConstructor;
    private final InputVariables myVariableData;
    private final PsiClass myTargetClass;
    private VisibilityPanel myVisibilityPanel;
    private boolean myDefaultVisibility = true;
    private boolean myChangingVisibility;
    private JCheckBox myFoldCb = new NonFocusableCheckBox(RefactoringBundle.message((String)"declare.folded.parameters"));
    public JPanel myCenterPanel;
    public JPanel myParamTabel;
    private ParameterTablePanel.VariableData[] myInputVariables;

    public ExtractMethodDialog(Project project, PsiClass targetClass, InputVariables inputVariables, PsiType returnType, PsiTypeParameterList typeParameterList, PsiType[] exceptions, boolean isStatic, boolean canBeStatic, boolean canBeChainedConstructor, String initialMethodName, String title, String helpId, PsiElement[] elementsToExtract) {
        super(project);
        this.myProject = project;
        this.myTargetClass = targetClass;
        this.myReturnType = returnType;
        this.myTypeParameterList = typeParameterList;
        this.myExceptions = exceptions;
        this.myStaticFlag = isStatic;
        this.myCanBeStatic = canBeStatic;
        this.myElementsToExtract = elementsToExtract;
        this.myVariableData = inputVariables;
        this.myHelpId = helpId;
        this.setTitle(title);
        this.myNameField = new EditorTextField(initialMethodName);
        int height = this.myVariableData.getInputVariables().size() + 2;
        if (this.myExceptions.length > 0) {
            height += this.myExceptions.length + 1;
        }
        this.mySignatureArea = new JTextArea(height, 30);
        this.myCbMakeStatic = new NonFocusableCheckBox();
        this.myCbMakeStatic.setText(RefactoringBundle.message((String)"declare.static.checkbox"));
        if (canBeChainedConstructor) {
            this.myCbChainedConstructor = new NonFocusableCheckBox(RefactoringBundle.message((String)"extract.chained.constructor.checkbox"));
        }
    }

    protected boolean areTypesDirected() {
        return true;
    }

    @Override
    public boolean isMakeStatic() {
        if (this.myStaticFlag) {
            return true;
        }
        return this.myCanBeStatic && this.myCbMakeStatic.isSelected();
    }

    @Override
    public boolean isChainedConstructor() {
        return this.myCbChainedConstructor != null && this.myCbChainedConstructor.isSelected();
    }

    protected Action[] createActions() {
        if (this.myHelpId != null) {
            return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        }
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    @Override
    public String getChosenMethodName() {
        return this.myNameField.getText();
    }

    @Override
    public ParameterTablePanel.VariableData[] getChosenParameters() {
        return this.myInputVariables;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpId);
    }

    protected void doOKAction() {
        MultiMap conflicts = new MultiMap();
        this.checkMethodConflicts((MultiMap<PsiElement, String>)conflicts);
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, (MultiMap<PsiElement, String>)conflicts);
            conflictsDialog.show();
            if (!conflictsDialog.isOK()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.close(1);
                }
                return;
            }
        }
        if (this.myCbMakeVarargs != null && this.myCbMakeVarargs.isSelected()) {
            ParameterTablePanel.VariableData data = this.myInputVariables[this.myInputVariables.length - 1];
            if (data.type instanceof PsiArrayType) {
                data.type = new PsiEllipsisType(((PsiArrayType)data.type).getComponentType());
            }
        }
        super.doOKAction();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0));
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"extract.method.method.panel.border")));
        JLabel nameLabel = new JLabel();
        nameLabel.setText(RefactoringBundle.message((String)"name.prompt"));
        panel.add(nameLabel);
        panel.add(this.myNameField);
        nameLabel.setLabelFor(this.myNameField);
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                ExtractMethodDialog.this.update();
            }
        });
        this.setOKActionEnabled(false);
        panel.add(this.myCbMakeStatic);
        if (this.myStaticFlag || this.myCanBeStatic) {
            this.myCbMakeStatic.setEnabled(!this.myStaticFlag);
            this.myCbMakeStatic.setSelected(this.myStaticFlag);
            this.myCbMakeStatic.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ExtractMethodDialog.this.updateSignature();
                }
            });
        } else {
            this.myCbMakeStatic.setSelected(false);
            this.myCbMakeStatic.setEnabled(false);
        }
        this.myFoldCb.setSelected(this.myVariableData.isFoldingSelectedByDefault());
        this.myFoldCb.setVisible(this.myVariableData.isFoldable());
        this.myVariableData.setFoldingAvailable(this.myFoldCb.isSelected());
        this.myInputVariables = this.myVariableData.getInputVariables().toArray(new ParameterTablePanel.VariableData[this.myVariableData.getInputVariables().size()]);
        this.myFoldCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractMethodDialog.this.myVariableData.setFoldingAvailable(ExtractMethodDialog.this.myFoldCb.isSelected());
                ExtractMethodDialog.access$302(ExtractMethodDialog.this, ExtractMethodDialog.this.myVariableData.getInputVariables().toArray(new ParameterTablePanel.VariableData[ExtractMethodDialog.this.myVariableData.getInputVariables().size()]));
                ExtractMethodDialog.this.updateVarargsEnabled();
                ExtractMethodDialog.this.createParametersPanel();
                ExtractMethodDialog.this.updateSignature();
            }
        });
        panel.add(this.myFoldCb);
        boolean canBeVarargs = false;
        for (ParameterTablePanel.VariableData data : this.myInputVariables) {
            canBeVarargs |= data.type instanceof PsiArrayType;
        }
        if (this.myVariableData.isFoldable()) {
            canBeVarargs |= this.myVariableData.isFoldingSelectedByDefault();
        }
        if (canBeVarargs) {
            this.myCbMakeVarargs = new NonFocusableCheckBox(RefactoringBundle.message((String)"declare.varargs.checkbox"));
            this.updateVarargsEnabled();
            this.myCbMakeVarargs.setSelected(false);
            panel.add(this.myCbMakeVarargs);
        }
        if (this.myCbChainedConstructor != null) {
            panel.add(this.myCbChainedConstructor);
            this.myCbChainedConstructor.addItemListener(new ItemListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ExtractMethodDialog.this.myDefaultVisibility) {
                        ExtractMethodDialog.this.myChangingVisibility = true;
                        try {
                            if (ExtractMethodDialog.this.isChainedConstructor()) {
                                ExtractMethodDialog.this.myVisibilityPanel.setVisibility(VisibilityUtil.getVisibilityModifier((PsiModifierList)ExtractMethodDialog.this.myTargetClass.getModifierList()));
                            } else {
                                ExtractMethodDialog.this.myVisibilityPanel.setVisibility("private");
                            }
                        }
                        finally {
                            ExtractMethodDialog.this.myChangingVisibility = false;
                        }
                    }
                    ExtractMethodDialog.this.update();
                }
            });
        }
        this.setOKActionEnabled(JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper().isIdentifier(this.myNameField.getText()));
        return panel;
    }

    private void updateVarargsEnabled() {
        if (this.myCbMakeVarargs != null) {
            this.myCbMakeVarargs.setEnabled(this.myInputVariables[this.myInputVariables.length - 1].type instanceof PsiArrayType);
        }
    }

    private void update() {
        this.myNameField.setEnabled(!this.isChainedConstructor());
        if (this.myCbMakeStatic != null) {
            this.myCbMakeStatic.setEnabled(!this.myStaticFlag && this.myCanBeStatic && !this.isChainedConstructor());
        }
        this.updateSignature();
        this.setOKActionEnabled(JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper().isIdentifier(this.myNameField.getText()) || this.isChainedConstructor());
    }

    @Override
    public String getVisibility() {
        return this.myVisibilityPanel.getVisibility();
    }

    protected JComponent createCenterPanel() {
        this.myVisibilityPanel = new VisibilityPanel(false, false);
        this.myVisibilityPanel.setVisibility("private");
        this.myVisibilityPanel.addStateChangedListener(new VisibilityPanel.StateChanged(){

            @Override
            public void visibilityChanged() {
                ExtractMethodDialog.this.updateSignature();
                if (!ExtractMethodDialog.this.myChangingVisibility) {
                    ExtractMethodDialog.this.myDefaultVisibility = false;
                }
            }
        });
        this.myCenterPanel = new JPanel(new BorderLayout());
        this.createParametersPanel();
        this.myCenterPanel.add((Component)this.createSignaturePanel(), "South");
        this.myCenterPanel.add((Component)this.myVisibilityPanel, "East");
        return this.myCenterPanel;
    }

    private void createParametersPanel() {
        if (this.myParamTabel != null) {
            this.myCenterPanel.remove(this.myParamTabel);
        }
        this.myParamTabel = new ParameterTablePanel(this.myProject, this.myInputVariables, this.myElementsToExtract){

            @Override
            protected void updateSignature() {
                ExtractMethodDialog.this.updateVarargsEnabled();
                ExtractMethodDialog.this.updateSignature();
            }

            @Override
            protected void doEnterAction() {
                ExtractMethodDialog.this.clickDefaultButton();
            }

            @Override
            protected void doCancelAction() {
                ExtractMethodDialog.this.doCancelAction();
            }

            @Override
            protected boolean areTypesDirected() {
                return ExtractMethodDialog.this.areTypesDirected();
            }
        };
        this.myParamTabel.setBorder(IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"parameters.border.title")));
        this.myCenterPanel.add((Component)this.myParamTabel, "Center");
    }

    private JComponent createSignaturePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"signature.preview.border.title")));
        this.mySignatureArea.setEditable(false);
        this.mySignatureArea.setBackground(this.getContentPane().getBackground());
        panel.add((Component)this.mySignatureArea, "Center");
        this.updateSignature();
        Dimension size = this.mySignatureArea.getPreferredSize();
        this.mySignatureArea.setMaximumSize(size);
        this.mySignatureArea.setMinimumSize(size);
        return panel;
    }

    protected void updateSignature() {
        if (this.mySignatureArea == null) {
            return;
        }
        StringBuffer buffer = this.getSignature();
        this.mySignatureArea.setText(buffer.toString());
    }

    protected StringBuffer getSignature() {
        StringBuffer buffer = new StringBuffer();
        String visibilityString = VisibilityUtil.getVisibilityString((String)this.myVisibilityPanel.getVisibility());
        buffer.append(visibilityString);
        if (buffer.length() > 0) {
            buffer.append(" ");
        }
        if (this.isMakeStatic() && !this.isChainedConstructor()) {
            buffer.append("static ");
        }
        if (this.myTypeParameterList != null) {
            buffer.append(this.myTypeParameterList.getText());
            buffer.append(" ");
        }
        if (this.isChainedConstructor()) {
            buffer.append(this.myTargetClass.getName());
        } else {
            buffer.append(PsiFormatUtil.formatType((PsiType)this.myReturnType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            buffer.append(" ");
            buffer.append(this.myNameField.getText());
        }
        buffer.append("(");
        int count = 0;
        String INDENT = "    ";
        ParameterTablePanel.VariableData[] datas = this.myInputVariables;
        for (int i = 0; i < datas.length; ++i) {
            ParameterTablePanel.VariableData data = datas[i];
            if (!data.passAsParameter) continue;
            PsiType type = data.type;
            if (i == datas.length - 1 && type instanceof PsiArrayType && this.myCbMakeVarargs.isSelected()) {
                type = new PsiEllipsisType(((PsiArrayType)type).getComponentType());
            }
            String typeText = type.getPresentableText();
            if (count > 0) {
                buffer.append(",");
            }
            buffer.append("\n");
            buffer.append("    ");
            buffer.append(typeText);
            buffer.append(" ");
            buffer.append(data.name);
            ++count;
        }
        if (count > 0) {
            buffer.append("\n");
        }
        buffer.append(")");
        if (this.myExceptions.length > 0) {
            buffer.append("\n");
            buffer.append("throws\n");
            for (PsiType exception : this.myExceptions) {
                buffer.append("    ");
                buffer.append(PsiFormatUtil.formatType((PsiType)exception, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                buffer.append("\n");
            }
        }
        return buffer;
    }

    protected void checkMethodConflicts(MultiMap<PsiElement, String> conflicts) {
        PsiMethod prototype;
        try {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
            prototype = factory.createMethod(this.myNameField.getText().trim(), this.myReturnType);
            if (this.myTypeParameterList != null) {
                prototype.getTypeParameterList().replace((PsiElement)this.myTypeParameterList);
            }
            for (ParameterTablePanel.VariableData data : this.myInputVariables) {
                if (!data.passAsParameter) continue;
                prototype.getParameterList().add((PsiElement)factory.createParameter(data.name, data.type));
            }
            PsiUtil.setModifierProperty((PsiModifierListOwner)prototype, (String)"private", (boolean)true);
        }
        catch (IncorrectOperationException e) {
            return;
        }
        ConflictsUtil.checkMethodConflicts(this.myTargetClass, null, prototype, conflicts);
    }

    static /* synthetic */ ParameterTablePanel.VariableData[] access$302(ExtractMethodDialog x0, ParameterTablePanel.VariableData[] x1) {
        x0.myInputVariables = x1;
        return x1;
    }
}

