/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.EmptyInstruction;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.introduceParameter.Util;
import com.intellij.refactoring.rename.RenameJavaVariableProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineMethodProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineMethodProcessor");
    private PsiMethod myMethod;
    private PsiJavaCodeReferenceElement myReference;
    private final Editor myEditor;
    private final boolean myInlineThisOnly;
    private final PsiManager myManager;
    private final PsiElementFactory myFactory;
    private final CodeStyleManager myCodeStyleManager;
    private final JavaCodeStyleManager myJavaCodeStyle;
    private PsiBlockStatement[] myAddedBraces;
    private final String myDescriptiveName;
    private Map<PsiField, PsiClassInitializer> myAddedClassInitializers;
    private PsiMethod myMethodCopy;
    private static final Key<String> MARK_KEY = Key.create((String)"");

    public InlineMethodProcessor(@NotNull Project project, @NotNull PsiMethod method, @Nullable PsiJavaCodeReferenceElement reference, Editor editor, boolean isInlineThisOnly) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/inline/InlineMethodProcessor.<init> must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/inline/InlineMethodProcessor.<init> must not be null");
        }
        super(project);
        this.myMethod = method;
        this.myReference = reference;
        this.myEditor = editor;
        this.myInlineThisOnly = isInlineThisOnly;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myFactory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
        this.myCodeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
        this.myJavaCodeStyle = JavaCodeStyleManager.getInstance((Project)this.myProject);
        this.myDescriptiveName = UsageViewUtil.getDescriptiveName((PsiElement)this.myMethod);
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"inline.method.command", (Object[])new Object[]{this.myDescriptiveName});
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new InlineViewDescriptor((PsiElement)this.myMethod);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray;
        if (this.myInlineThisOnly) {
            usageInfoArray = new UsageInfo[]{new UsageInfo((PsiQualifiedReference)this.myReference)};
            if (usageInfoArray == null) throw new IllegalStateException("@NotNull method com/intellij/refactoring/inline/InlineMethodProcessor.findUsages must not return null");
            return usageInfoArray;
        }
        HashSet<UsageInfo> usages = new HashSet<UsageInfo>();
        if (this.myReference != null) {
            usages.add(new UsageInfo((PsiQualifiedReference)this.myReference));
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myMethod)) {
            usages.add(new UsageInfo(reference.getElement()));
        }
        usageInfoArray = usages.toArray(new UsageInfo[usages.size()]);
        if (usageInfoArray != null) return usageInfoArray;
        throw new IllegalStateException("@NotNull method com/intellij/refactoring/inline/InlineMethodProcessor.findUsages must not return null");
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        boolean condition = elements.length == 1 && elements[0] instanceof PsiMethod;
        LOG.assertTrue(condition);
        this.myMethod = (PsiMethod)elements[0];
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        if (!this.myInlineThisOnly) {
            PsiMethod[] superMethods;
            for (PsiMethod method : superMethods = this.myMethod.findSuperMethods()) {
                String message = method.hasModifierProperty("abstract") ? RefactoringBundle.message((String)"inlined.method.implements.method.from.0", (Object[])new Object[]{method.getContainingClass().getQualifiedName()}) : RefactoringBundle.message((String)"inlined.method.overrides.method.from.0", (Object[])new Object[]{method.getContainingClass().getQualifiedName()});
                conflicts.putValue((Object)method, (Object)message);
            }
        }
        InlineMethodProcessor.addInaccessibleMemberConflicts((PsiElement)this.myMethod, usagesIn, new ReferencedElementsCollector(), (MultiMap<PsiElement, String>)conflicts);
        this.addInaccessibleSuperCallsConflicts(usagesIn, (MultiMap<PsiElement, String>)conflicts);
        if (!this.myInlineThisOnly && !CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)this.myMethod)) {
            return false;
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts);
    }

    private void addInaccessibleSuperCallsConflicts(final UsageInfo[] usagesIn, final MultiMap<PsiElement, String> conflicts) {
        this.myMethod.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
            }

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
            }

            public void visitSuperExpression(PsiSuperExpression expression) {
                super.visitSuperExpression(expression);
                PsiType type = expression.getType();
                PsiClass superClass = PsiUtil.resolveClassInType((PsiType)type);
                if (superClass != null) {
                    HashSet<PsiClass> targetContainingClasses = new HashSet<PsiClass>();
                    for (UsageInfo info : usagesIn) {
                        PsiClass targetContainingClass;
                        PsiElement element = info.getElement();
                        if (element == null || (targetContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) == null || InheritanceUtil.isInheritorOrSelf((PsiClass)targetContainingClass, (PsiClass)superClass, (boolean)true)) continue;
                        targetContainingClasses.add(targetContainingClass);
                    }
                    if (!targetContainingClasses.isEmpty()) {
                        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class);
                        LOG.assertTrue(methodCallExpression != null);
                        conflicts.putValue((Object)expression, (Object)("Inlined method calls " + methodCallExpression.getText() + " which won't be accessed in " + StringUtil.join(targetContainingClasses, (Function)new Function<PsiClass, String>(){

                            public String fun(PsiClass psiClass) {
                                return RefactoringUIUtil.getDescription((PsiElement)psiClass, false);
                            }
                        }, (String)",")));
                    }
                }
            }
        });
    }

    public static void addInaccessibleMemberConflicts(PsiElement element, UsageInfo[] usages, ReferencedElementsCollector collector, MultiMap<PsiElement, String> conflicts) {
        element.accept((PsiElementVisitor)collector);
        Map<PsiMember, Set<PsiMember>> containersToReferenced = InlineMethodProcessor.getInaccessible(collector.myReferencedMembers, usages);
        Set<PsiMember> containers = containersToReferenced.keySet();
        for (PsiMember container : containers) {
            Set<PsiMember> referencedInaccessible = containersToReferenced.get(container);
            for (PsiMember referenced : referencedInaccessible) {
                String referencedDescription = RefactoringUIUtil.getDescription((PsiElement)referenced, true);
                String containerDescription = RefactoringUIUtil.getDescription((PsiElement)container, true);
                String message = RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{referencedDescription, containerDescription});
                conflicts.putValue((Object)container, (Object)CommonRefactoringUtil.capitalize((String)message));
            }
        }
    }

    private static Map<PsiMember, Set<PsiMember>> getInaccessible(HashSet<PsiMember> referencedElements, UsageInfo[] usages) {
        HashMap result = new HashMap();
        for (UsageInfo usage : usages) {
            PsiMember memberContainer;
            HashSet<PsiMember> inaccessibleReferenced;
            PsiElement container = ConflictsUtil.getContainer(usage.getElement());
            if (!(container instanceof PsiMember) || (inaccessibleReferenced = (HashSet<PsiMember>)result.get(memberContainer = (PsiMember)container)) != null) continue;
            inaccessibleReferenced = new HashSet<PsiMember>();
            result.put(memberContainer, inaccessibleReferenced);
            for (PsiMember member : referencedElements) {
                if (PsiUtil.isAccessible((PsiMember)member, (PsiElement)usage.getElement(), null)) continue;
                inaccessibleReferenced.add(member);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        int col = -1;
        int line = -1;
        if (this.myEditor != null) {
            col = this.myEditor.getCaretModel().getLogicalPosition().column;
            line = this.myEditor.getCaretModel().getLogicalPosition().line;
            LogicalPosition pos = new LogicalPosition(0, 0);
            this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        }
        LocalHistoryAction a = LocalHistory.startAction((Project)this.myProject, (String)this.getCommandName());
        try {
            this.doRefactoring(usages);
        }
        finally {
            a.finish();
        }
        if (this.myEditor != null) {
            LogicalPosition pos = new LogicalPosition(line, col);
            this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        }
    }

    private void doRefactoring(UsageInfo[] usages) {
        try {
            if (this.myInlineThisOnly) {
                if (this.myMethod.isConstructor()) {
                    PsiCall constructorCall = RefactoringUtil.getEnclosingConstructorCall(this.myReference);
                    if (constructorCall != null) {
                        InlineMethodProcessor.inlineConstructorCall(constructorCall);
                    }
                } else {
                    this.myReference = this.addBracesWhenNeeded(new PsiReferenceExpression[]{(PsiReferenceExpression)this.myReference})[0];
                    this.inlineMethodCall((PsiReferenceExpression)this.myReference);
                }
            } else {
                RefactoringUtil.sortDepthFirstRightLeftOrder(usages);
                if (this.myMethod.isConstructor()) {
                    for (UsageInfo usage : usages) {
                        PsiElement element = usage.getElement();
                        if (element instanceof PsiJavaCodeReferenceElement) {
                            PsiCall constructorCall = RefactoringUtil.getEnclosingConstructorCall((PsiJavaCodeReferenceElement)element);
                            if (constructorCall == null) continue;
                            InlineMethodProcessor.inlineConstructorCall(constructorCall);
                            continue;
                        }
                        if (!(element instanceof PsiEnumConstant)) continue;
                        InlineMethodProcessor.inlineConstructorCall((PsiCall)((PsiEnumConstant)element));
                    }
                    this.myMethod.delete();
                } else {
                    ArrayList<PsiReferenceExpression> refExprList = new ArrayList<PsiReferenceExpression>();
                    for (UsageInfo usage : usages) {
                        PsiElement element = usage.getElement();
                        if (!(element instanceof PsiReferenceExpression)) continue;
                        refExprList.add((PsiReferenceExpression)element);
                    }
                    PsiReferenceExpression[] refs = refExprList.toArray(new PsiReferenceExpression[refExprList.size()]);
                    for (PsiReferenceExpression ref : refs = this.addBracesWhenNeeded(refs)) {
                        this.inlineMethodCall(ref);
                    }
                    this.myMethod.delete();
                }
            }
            this.removeAddedBracesWhenPossible();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void inlineConstructorCall(PsiCall constructorCall) {
        PsiExpression[] args;
        PsiStatement[] statements;
        PsiParameter[] parameters;
        PsiType varargType;
        PsiMethod oldConstructor = constructorCall.resolveMethod();
        LOG.assertTrue(oldConstructor != null);
        PsiExpression[] instanceCreationArguments = constructorCall.getArgumentList().getExpressions();
        if (oldConstructor.isVarArgs() && (varargType = (parameters = oldConstructor.getParameterList().getParameters())[parameters.length - 1].getType()) instanceof PsiEllipsisType) {
            PsiType arrayType = constructorCall.resolveMethodGenerics().getSubstitutor().substitute(((PsiEllipsisType)varargType).getComponentType());
            PsiExpression[] exprs = new PsiExpression[parameters.length];
            System.arraycopy(instanceCreationArguments, 0, exprs, 0, parameters.length - 1);
            StringBuffer varargs = new StringBuffer();
            for (int i = parameters.length - 1; i < instanceCreationArguments.length; ++i) {
                if (varargs.length() > 0) {
                    varargs.append(", ");
                }
                varargs.append(instanceCreationArguments[i].getText());
            }
            exprs[parameters.length - 1] = JavaPsiFacade.getElementFactory((Project)constructorCall.getProject()).createExpressionFromText("new " + arrayType.getCanonicalText() + "[]{" + varargs.toString() + "}", (PsiElement)constructorCall);
            instanceCreationArguments = exprs;
        }
        LOG.assertTrue((statements = oldConstructor.getBody().getStatements()).length == 1 && statements[0] instanceof PsiExpressionStatement);
        PsiExpression expression = ((PsiExpressionStatement)statements[0]).getExpression();
        LOG.assertTrue(expression instanceof PsiMethodCallExpression);
        ChangeContextUtil.encodeContextInfo((PsiElement)expression, true);
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression.copy();
        for (PsiExpression arg : args = methodCall.getArgumentList().getExpressions()) {
            InlineMethodProcessor.replaceParameterReferences((PsiElement)arg, oldConstructor, instanceCreationArguments);
        }
        try {
            PsiExpressionList exprList = (PsiExpressionList)constructorCall.getArgumentList().replace((PsiElement)methodCall.getArgumentList());
            ChangeContextUtil.decodeContextInfo((PsiElement)exprList, (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)constructorCall, PsiClass.class), null);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        ChangeContextUtil.clearContextInfo((PsiElement)expression);
    }

    private static void replaceParameterReferences(PsiElement element, PsiMethod oldConstructor, PsiExpression[] instanceCreationArguments) {
        PsiReferenceExpression expression;
        PsiElement resolved;
        boolean isParameterReference = false;
        if (element instanceof PsiReferenceExpression && (resolved = (expression = (PsiReferenceExpression)element).resolve()) instanceof PsiParameter && element.getManager().areElementsEquivalent(((PsiParameter)resolved).getDeclarationScope(), (PsiElement)oldConstructor)) {
            isParameterReference = true;
            PsiElement declarationScope = ((PsiParameter)resolved).getDeclarationScope();
            PsiParameter[] declarationParameters = ((PsiMethod)declarationScope).getParameterList().getParameters();
            for (int j = 0; j < declarationParameters.length; ++j) {
                if (declarationParameters[j] != resolved) continue;
                try {
                    expression.replace((PsiElement)instanceCreationArguments[j]);
                    continue;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        if (!isParameterReference) {
            PsiElement child = element.getFirstChild();
            while (child != null) {
                PsiElement next = child.getNextSibling();
                InlineMethodProcessor.replaceParameterReferences(child, oldConstructor, instanceCreationArguments);
                child = next;
            }
        }
    }

    private void inlineMethodCall(PsiReferenceExpression ref) throws IncorrectOperationException {
        InlineUtil.TailCallType tailCall = InlineUtil.getTailCallType((PsiReference)ref);
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myMethod, false);
        this.myMethodCopy = (PsiMethod)this.myMethod.copy();
        ChangeContextUtil.clearContextInfo((PsiElement)this.myMethod);
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)ref.getParent();
        PsiSubstitutor callSubstitutor = this.getCallSubstitutor(methodCall);
        BlockData blockData = this.prepareBlock(ref, callSubstitutor, methodCall.getArgumentList(), tailCall);
        this.solveVariableNameConflicts((PsiElement)blockData.block, (PsiElement)ref);
        if (callSubstitutor != PsiSubstitutor.EMPTY) {
            this.substituteMethodTypeParams((PsiElement)blockData.block, callSubstitutor);
        }
        this.addParmAndThisVarInitializers(blockData, methodCall);
        PsiElement anchor = RefactoringUtil.getParentStatement((PsiElement)methodCall, true);
        if (anchor == null) {
            PsiExpression returnExpr;
            PsiEnumConstant enumConstant = (PsiEnumConstant)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiEnumConstant.class);
            if (enumConstant != null && (returnExpr = InlineMethodProcessor.getSimpleReturnedExpression(this.myMethod)) != null) {
                methodCall.replace((PsiElement)returnExpr);
            }
            return;
        }
        PsiElement anchorParent = anchor.getParent();
        PsiLocalVariable thisVar = null;
        PsiLocalVariable[] parmVars = new PsiLocalVariable[blockData.parmVars.length];
        PsiLocalVariable resultVar = null;
        PsiStatement[] statements = blockData.block.getStatements();
        if (statements.length > 0) {
            PsiExpression returnValue;
            PsiStatement lastStatement;
            int first;
            int last = statements.length - 1;
            if (statements.length > 0 && statements[statements.length - 1] instanceof PsiReturnStatement && tailCall != InlineUtil.TailCallType.Return) {
                --last;
            }
            if ((first = 0) <= last) {
                PsiElement rBraceOrReturnStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statements[last], (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
                LOG.assertTrue(rBraceOrReturnStatement != null);
                PsiElement beforeRBraceStatement = rBraceOrReturnStatement.getPrevSibling();
                LOG.assertTrue(beforeRBraceStatement != null);
                PsiElement firstAdded = anchorParent.addRangeBefore((PsiElement)statements[first], beforeRBraceStatement, anchor);
                PsiElement current = firstAdded.getPrevSibling();
                LOG.assertTrue(current != null);
                if (blockData.thisVar != null) {
                    PsiDeclarationStatement statement = (PsiDeclarationStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)current, PsiDeclarationStatement.class);
                    thisVar = (PsiLocalVariable)statement.getDeclaredElements()[0];
                    current = statement;
                }
                for (int i = 0; i < parmVars.length; ++i) {
                    PsiDeclarationStatement statement = (PsiDeclarationStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)current, PsiDeclarationStatement.class);
                    parmVars[i] = (PsiLocalVariable)statement.getDeclaredElements()[0];
                    current = statement;
                }
                if (blockData.resultVar != null) {
                    PsiDeclarationStatement statement = (PsiDeclarationStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)current, PsiDeclarationStatement.class);
                    resultVar = (PsiLocalVariable)statement.getDeclaredElements()[0];
                }
            }
            if (statements.length > 0 && (lastStatement = statements[statements.length - 1]) instanceof PsiReturnStatement && tailCall != InlineUtil.TailCallType.Return && (returnValue = ((PsiReturnStatement)lastStatement).getReturnValue()) != null && PsiUtil.isStatement((PsiElement)returnValue)) {
                PsiExpressionStatement exprStatement = (PsiExpressionStatement)this.myFactory.createStatementFromText("a;", null);
                exprStatement.getExpression().replace((PsiElement)returnValue);
                anchorParent.addBefore((PsiElement)exprStatement, anchor);
            }
        }
        if (methodCall.getParent() instanceof PsiExpressionStatement || tailCall == InlineUtil.TailCallType.Return) {
            methodCall.getParent().delete();
        } else if (blockData.resultVar != null) {
            PsiExpression expr = this.myFactory.createExpressionFromText(blockData.resultVar.getName(), null);
            methodCall.replace((PsiElement)expr);
        }
        PsiClass thisClass = this.myMethod.getContainingClass();
        PsiExpression thisAccessExpr = thisVar != null ? (!this.canInlineParmOrThisVariable(thisVar) ? this.myFactory.createExpressionFromText(thisVar.getName(), null) : thisVar.getInitializer()) : null;
        ChangeContextUtil.decodeContextInfo(anchorParent, thisClass, thisAccessExpr);
        if (thisVar != null) {
            this.inlineParmOrThisVariable(thisVar, false);
        }
        PsiParameter[] parameters = this.myMethod.getParameterList().getParameters();
        for (int i = 0; i < parmVars.length; ++i) {
            PsiParameter parameter = parameters[i];
            boolean strictlyFinal = parameter.hasModifierProperty("final") && this.isStrictlyFinal(parameter);
            this.inlineParmOrThisVariable(parmVars[i], strictlyFinal);
        }
        if (resultVar != null) {
            this.inlineResultVariable((PsiVariable)resultVar);
        }
        ChangeContextUtil.clearContextInfo(anchorParent);
    }

    private PsiSubstitutor getCallSubstitutor(PsiMethodCallExpression methodCall) {
        JavaResolveResult resolveResult = methodCall.getMethodExpression().advancedResolve(false);
        LOG.assertTrue(this.myManager.areElementsEquivalent(resolveResult.getElement(), (PsiElement)this.myMethod));
        if (resolveResult.getSubstitutor() != PsiSubstitutor.EMPTY) {
            Iterator oldTypeParameters = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)this.myMethod);
            Iterator newTypeParameters = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)this.myMethodCopy);
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            while (newTypeParameters.hasNext()) {
                PsiTypeParameter newTypeParameter = (PsiTypeParameter)newTypeParameters.next();
                PsiTypeParameter oldTypeParameter = (PsiTypeParameter)oldTypeParameters.next();
                substitutor = substitutor.put(newTypeParameter, resolveResult.getSubstitutor().substitute(oldTypeParameter));
            }
            return substitutor;
        }
        return PsiSubstitutor.EMPTY;
    }

    private void substituteMethodTypeParams(PsiElement scope, PsiSubstitutor substitutor) {
        InlineUtil.substituteTypeParams(scope, substitutor, this.myFactory);
    }

    private boolean isStrictlyFinal(PsiParameter parameter) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false)) {
            PsiElement refElement = reference.getElement();
            PsiElement anonymousClass = PsiTreeUtil.getParentOfType((PsiElement)refElement, PsiAnonymousClass.class);
            if (anonymousClass == null || !PsiTreeUtil.isAncestor((PsiElement)this.myMethod, (PsiElement)anonymousClass, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private boolean syncNeeded(PsiReferenceExpression ref) {
        PsiClass targetContainingClass;
        if (!this.myMethod.hasModifierProperty("synchronized")) {
            return false;
        }
        PsiMethod containingMethod = Util.getContainingMethod((PsiElement)ref);
        if (containingMethod == null) {
            return true;
        }
        if (!containingMethod.hasModifierProperty("synchronized")) {
            return true;
        }
        PsiClass sourceContainingClass = this.myMethod.getContainingClass();
        return !sourceContainingClass.equals(targetContainingClass = containingMethod.getContainingClass());
    }

    private BlockData prepareBlock(PsiReferenceExpression ref, PsiSubstitutor callSubstitutor, PsiExpressionList argumentList, InlineUtil.TailCallType tailCallType) throws IncorrectOperationException {
        PsiClass containingClass;
        PsiCodeBlock block = this.myMethodCopy.getBody();
        PsiStatement[] originalStatements = block.getStatements();
        PsiLocalVariable resultVar = null;
        PsiType returnType = callSubstitutor.substitute(this.myMethod.getReturnType());
        String resultName = null;
        int applicabilityLevel = PsiUtil.getApplicabilityLevel((PsiMethod)this.myMethod, (PsiSubstitutor)callSubstitutor, (PsiExpressionList)argumentList);
        if (returnType != null && returnType != PsiType.VOID && tailCallType == InlineUtil.TailCallType.None) {
            resultName = this.myJavaCodeStyle.propertyNameToVariableName("result", VariableKind.LOCAL_VARIABLE);
            resultName = this.myJavaCodeStyle.suggestUniqueVariableName(resultName, block.getFirstChild(), true);
            PsiDeclarationStatement declaration = this.myFactory.createVariableDeclarationStatement(resultName, returnType, null);
            declaration = (PsiDeclarationStatement)block.addAfter((PsiElement)declaration, null);
            resultVar = (PsiLocalVariable)declaration.getDeclaredElements()[0];
        }
        PsiParameter[] parms = this.myMethodCopy.getParameterList().getParameters();
        PsiLocalVariable[] parmVars = new PsiLocalVariable[parms.length];
        for (int i = parms.length - 1; i >= 0; --i) {
            String defaultValue;
            String parmName;
            PsiParameter parm = parms[i];
            String name = parmName = parm.getName();
            name = this.myJavaCodeStyle.variableNameToPropertyName(name, VariableKind.PARAMETER);
            if (!(name = this.myJavaCodeStyle.propertyNameToVariableName(name, VariableKind.LOCAL_VARIABLE)).equals(parmName)) {
                name = this.myJavaCodeStyle.suggestUniqueVariableName(name, block.getFirstChild(), true);
            }
            RefactoringUtil.renameVariableReferences((PsiVariable)parm, name, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
            PsiType paramType = parm.getType();
            if (paramType instanceof PsiEllipsisType) {
                PsiEllipsisType ellipsisType = (PsiEllipsisType)paramType;
                paramType = ellipsisType.toArrayType();
                defaultValue = applicabilityLevel == 2 ? "new " + ellipsisType.getComponentType().getCanonicalText() + "[]{}" : PsiTypesUtil.getDefaultValueOfType((PsiType)paramType);
            } else {
                defaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)paramType);
            }
            PsiExpression initializer = this.myFactory.createExpressionFromText(defaultValue, null);
            PsiDeclarationStatement declaration = this.myFactory.createVariableDeclarationStatement(name, callSubstitutor.substitute(paramType), initializer);
            declaration = (PsiDeclarationStatement)block.addAfter((PsiElement)declaration, null);
            parmVars[i] = (PsiLocalVariable)declaration.getDeclaredElements()[0];
            PsiUtil.setModifierProperty((PsiModifierListOwner)parmVars[i], (String)"final", (boolean)parm.hasModifierProperty("final"));
        }
        PsiLocalVariable thisVar = null;
        if (!this.myMethod.hasModifierProperty("static") && (containingClass = this.myMethod.getContainingClass()) != null) {
            PsiClassType thisType = this.myFactory.createType(containingClass, callSubstitutor);
            String[] names = this.myJavaCodeStyle.suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, null, (PsiType)thisType).names;
            String thisVarName = names[0];
            thisVarName = this.myJavaCodeStyle.suggestUniqueVariableName(thisVarName, block.getFirstChild(), true);
            PsiExpression initializer = this.myFactory.createExpressionFromText("null", null);
            PsiDeclarationStatement declaration = this.myFactory.createVariableDeclarationStatement(thisVarName, (PsiType)thisType, initializer);
            declaration = (PsiDeclarationStatement)block.addAfter((PsiElement)declaration, null);
            thisVar = (PsiLocalVariable)declaration.getDeclaredElements()[0];
        }
        if (thisVar != null && this.syncNeeded(ref)) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)this.myFactory.createStatementFromText("synchronized(" + thisVar.getName() + "){}", (PsiElement)block);
            synchronizedStatement = (PsiSynchronizedStatement)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)synchronizedStatement);
            synchronizedStatement = (PsiSynchronizedStatement)block.add((PsiElement)synchronizedStatement);
            PsiCodeBlock synchronizedBody = synchronizedStatement.getBody();
            for (PsiStatement originalStatement : originalStatements) {
                synchronizedBody.add((PsiElement)originalStatement);
                originalStatement.delete();
            }
        }
        if (resultName != null || tailCallType == InlineUtil.TailCallType.Simple) {
            PsiReturnStatement[] returnStatements;
            for (PsiReturnStatement returnStatement : returnStatements = RefactoringUtil.findReturnStatements(this.myMethodCopy)) {
                PsiStatement statement;
                PsiExpression returnValue = returnStatement.getReturnValue();
                if (returnValue == null) continue;
                if (tailCallType == InlineUtil.TailCallType.Simple) {
                    if (returnValue instanceof PsiCallExpression) {
                        PsiExpressionStatement exprStatement = (PsiExpressionStatement)this.myFactory.createStatementFromText("a;", null);
                        exprStatement.getExpression().replace((PsiElement)returnValue);
                        returnStatement.getParent().addBefore((PsiElement)exprStatement, (PsiElement)returnStatement);
                    }
                    statement = this.myFactory.createStatementFromText("return;", null);
                } else {
                    statement = this.myFactory.createStatementFromText(resultName + "=0;", null);
                    statement = (PsiStatement)this.myCodeStyleManager.reformat((PsiElement)statement);
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)((PsiExpressionStatement)statement).getExpression();
                    assignment.getRExpression().replace((PsiElement)returnValue);
                }
                returnStatement.replace((PsiElement)statement);
            }
        }
        return new BlockData(block, thisVar, parmVars, resultVar);
    }

    private void solveVariableNameConflicts(PsiElement scope, PsiElement placeToInsert) throws IncorrectOperationException {
        PsiElement[] children;
        if (scope instanceof PsiVariable) {
            String newName;
            String name;
            PsiVariable var = (PsiVariable)scope;
            String oldName = name = var.getName();
            while (!(newName = this.myJavaCodeStyle.suggestUniqueVariableName(name, placeToInsert, true)).equals(name) && !(newName = this.myJavaCodeStyle.suggestUniqueVariableName(name = newName, (PsiElement)var, true)).equals(name)) {
                name = newName;
            }
            if (!name.equals(oldName)) {
                RefactoringUtil.renameVariableReferences(var, name, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
                var.getNameIdentifier().replace((PsiElement)this.myFactory.createIdentifier(name));
            }
        }
        for (PsiElement child : children = scope.getChildren()) {
            this.solveVariableNameConflicts(child, placeToInsert);
        }
    }

    private void addParmAndThisVarInitializers(BlockData blockData, PsiMethodCallExpression methodCall) throws IncorrectOperationException {
        PsiExpression[] args = methodCall.getArgumentList().getExpressions();
        if (blockData.parmVars.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                int j = Math.min(i, blockData.parmVars.length - 1);
                PsiExpression initializer = blockData.parmVars[j].getInitializer();
                LOG.assertTrue(initializer != null);
                if (initializer instanceof PsiNewExpression && ((PsiNewExpression)initializer).getArrayInitializer() != null) {
                    PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer();
                    arrayInitializer.add((PsiElement)args[i]);
                    continue;
                }
                initializer.replace((PsiElement)args[i]);
            }
        }
        if (blockData.thisVar != null) {
            PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                String name;
                PsiClass containingClass;
                PsiClass parentClass;
                PsiElement parent = methodCall.getParent();
                while (!(parent instanceof PsiClass) && !(parent instanceof PsiFile)) {
                    parent = parent.getParent();
                }
                qualifier = parent instanceof PsiClass ? (InheritanceUtil.isInheritorOrSelf((PsiClass)(parentClass = (PsiClass)parent), (PsiClass)(containingClass = this.myMethod.getContainingClass()), (boolean)true) ? this.myFactory.createExpressionFromText("this", null) : ((name = containingClass.getName()) != null ? this.myFactory.createExpressionFromText(name + ".this", null) : this.myFactory.createExpressionFromText("this", null))) : this.myFactory.createExpressionFromText("this", null);
            } else if (qualifier instanceof PsiSuperExpression) {
                qualifier = this.myFactory.createExpressionFromText("this", null);
            }
            blockData.thisVar.getInitializer().replace((PsiElement)qualifier);
        }
    }

    private boolean canInlineParmOrThisVariable(PsiLocalVariable variable) {
        boolean isAccessedForWriting = false;
        for (PsiReference ref : ReferencesSearch.search((PsiElement)variable)) {
            PsiElement refElement = ref.getElement();
            if (!(refElement instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refElement))) continue;
            isAccessedForWriting = true;
        }
        PsiExpression initializer = variable.getInitializer();
        if (variable.hasModifierProperty("final")) {
            // empty if block
        }
        boolean shouldBeFinal = false;
        return this.canInlineParmOrThisVariable(initializer, shouldBeFinal, false, ReferencesSearch.search((PsiElement)variable).findAll().size(), isAccessedForWriting);
    }

    private void inlineParmOrThisVariable(PsiLocalVariable variable, boolean strictlyFinal) throws IncorrectOperationException {
        boolean shouldBeFinal;
        PsiReference firstRef = (PsiReference)ReferencesSearch.search((PsiElement)variable).findFirst();
        if (firstRef == null) {
            variable.getParent().delete();
            return;
        }
        boolean isAccessedForWriting = false;
        Collection refs = ReferencesSearch.search((PsiElement)variable).findAll();
        for (PsiReference ref : refs) {
            PsiElement refElement = ref.getElement();
            if (!(refElement instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refElement))) continue;
            isAccessedForWriting = true;
        }
        PsiExpression initializer = variable.getInitializer();
        boolean bl = shouldBeFinal = variable.hasModifierProperty("final") && strictlyFinal;
        if (this.canInlineParmOrThisVariable(initializer, shouldBeFinal, strictlyFinal, refs.size(), isAccessedForWriting)) {
            if (shouldBeFinal) {
                InlineMethodProcessor.declareUsedLocalsFinal((PsiElement)initializer, strictlyFinal);
            }
            for (PsiReference ref : refs) {
                PsiElement newRefElement;
                PsiJavaCodeReferenceElement javaRef = (PsiJavaCodeReferenceElement)ref;
                if (initializer instanceof PsiThisExpression && ((PsiThisExpression)initializer).getQualifier() == null) {
                    PsiClass varThisClass = RefactoringUtil.getThisClass((PsiElement)variable);
                    if (RefactoringUtil.getThisClass((PsiElement)javaRef) != varThisClass) {
                        initializer = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory().createExpressionFromText(varThisClass.getName() + ".this", (PsiElement)variable);
                    }
                }
                PsiExpression expr = InlineUtil.inlineVariable((PsiVariable)variable, initializer, javaRef);
                InlineUtil.tryToInlineArrayCreationForVarargs(expr);
                if (!(expr instanceof PsiThisExpression) || !(expr.getParent() instanceof PsiReferenceExpression)) continue;
                PsiReferenceExpression refExpr = (PsiReferenceExpression)expr.getParent();
                PsiElement refElement = refExpr.resolve();
                PsiExpression exprCopy = (PsiExpression)refExpr.copy();
                refExpr = (PsiReferenceExpression)refExpr.replace((PsiElement)this.myFactory.createExpressionFromText(refExpr.getReferenceName(), null));
                if (refElement == null || refElement.equals(newRefElement = refExpr.resolve())) continue;
                refExpr.replace((PsiElement)exprCopy);
            }
            variable.getParent().delete();
        }
    }

    private boolean canInlineParmOrThisVariable(PsiExpression initializer, boolean shouldBeFinal, boolean strictlyFinal, int accessCount, boolean isAccessedForWriting) {
        if (strictlyFinal) {
            class CanAllLocalsBeDeclaredFinal
            extends JavaRecursiveElementWalkingVisitor {
                boolean success = true;

                CanAllLocalsBeDeclaredFinal() {
                }

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    PsiElement psiElement = expression.resolve();
                    if ((psiElement instanceof PsiLocalVariable || psiElement instanceof PsiParameter) && !RefactoringUtil.canBeDeclaredFinal((PsiVariable)psiElement)) {
                        this.success = false;
                    }
                }

                public void visitElement(PsiElement element) {
                    if (this.success) {
                        super.visitElement(element);
                    }
                }
            }
            CanAllLocalsBeDeclaredFinal canAllLocalsBeDeclaredFinal = new CanAllLocalsBeDeclaredFinal();
            initializer.accept((PsiElementVisitor)canAllLocalsBeDeclaredFinal);
            if (!canAllLocalsBeDeclaredFinal.success) {
                return false;
            }
        }
        if (initializer instanceof PsiReferenceExpression) {
            PsiVariable refVar = (PsiVariable)((PsiReferenceExpression)initializer).resolve();
            if (refVar == null) {
                return !isAccessedForWriting;
            }
            if (refVar instanceof PsiField) {
                return !isAccessedForWriting;
            }
            if (isAccessedForWriting) {
                if (refVar.hasModifierProperty("final") || shouldBeFinal) {
                    return false;
                }
                PsiReference[] refs = (PsiReference[])ReferencesSearch.search((PsiElement)refVar, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false).toArray((Object[])new PsiReference[0]);
                return refs.length == 1;
            }
            if (shouldBeFinal) {
                return refVar.hasModifierProperty("final") || RefactoringUtil.canBeDeclaredFinal(refVar);
            }
            return true;
        }
        if (isAccessedForWriting) {
            return false;
        }
        if (initializer instanceof PsiCallExpression) {
            PsiExpression[] expressions;
            PsiArrayInitializerExpression arrayInitializer;
            if (accessCount > 1) {
                return false;
            }
            if (initializer instanceof PsiNewExpression && (arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer()) != null) {
                for (PsiExpression expression : arrayInitializer.getInitializers()) {
                    if (this.canInlineParmOrThisVariable(expression, shouldBeFinal, strictlyFinal, accessCount, false)) continue;
                    return false;
                }
                return true;
            }
            PsiExpressionList argumentList = ((PsiCallExpression)initializer).getArgumentList();
            if (argumentList == null) {
                return false;
            }
            for (PsiExpression expression : expressions = argumentList.getExpressions()) {
                if (this.canInlineParmOrThisVariable(expression, shouldBeFinal, strictlyFinal, accessCount, false)) continue;
                return false;
            }
            return true;
        }
        if (initializer instanceof PsiLiteralExpression) {
            return true;
        }
        if (initializer instanceof PsiArrayAccessExpression) {
            PsiExpression arrayExpression = ((PsiArrayAccessExpression)initializer).getArrayExpression();
            PsiExpression indexExpression = ((PsiArrayAccessExpression)initializer).getIndexExpression();
            return this.canInlineParmOrThisVariable(arrayExpression, shouldBeFinal, strictlyFinal, accessCount, false) && this.canInlineParmOrThisVariable(indexExpression, shouldBeFinal, strictlyFinal, accessCount, false);
        }
        if (initializer instanceof PsiParenthesizedExpression) {
            PsiExpression expr = ((PsiParenthesizedExpression)initializer).getExpression();
            return expr == null || this.canInlineParmOrThisVariable(expr, shouldBeFinal, strictlyFinal, accessCount, false);
        }
        if (initializer instanceof PsiTypeCastExpression) {
            PsiExpression operand = ((PsiTypeCastExpression)initializer).getOperand();
            return operand != null && this.canInlineParmOrThisVariable(operand, shouldBeFinal, strictlyFinal, accessCount, false);
        }
        if (initializer instanceof PsiBinaryExpression) {
            PsiBinaryExpression binExpr = (PsiBinaryExpression)initializer;
            PsiExpression lOperand = binExpr.getLOperand();
            PsiExpression rOperand = binExpr.getROperand();
            return rOperand != null && this.canInlineParmOrThisVariable(lOperand, shouldBeFinal, strictlyFinal, accessCount, false) && this.canInlineParmOrThisVariable(rOperand, shouldBeFinal, strictlyFinal, accessCount, false);
        }
        if (initializer instanceof PsiClassObjectAccessExpression) {
            return true;
        }
        if (initializer instanceof PsiThisExpression) {
            return true;
        }
        return initializer instanceof PsiSuperExpression;
    }

    private static void declareUsedLocalsFinal(PsiElement expr, boolean strictlyFinal) throws IncorrectOperationException {
        PsiElement[] children;
        PsiElement refElement;
        if (expr instanceof PsiReferenceExpression && ((refElement = ((PsiReferenceExpression)expr).resolve()) instanceof PsiLocalVariable || refElement instanceof PsiParameter) && (strictlyFinal || RefactoringUtil.canBeDeclaredFinal((PsiVariable)refElement))) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiVariable)refElement), (String)"final", (boolean)true);
        }
        for (PsiElement child : children = expr.getChildren()) {
            InlineMethodProcessor.declareUsedLocalsFinal(child, strictlyFinal);
        }
    }

    private void inlineResultVariable(PsiVariable resultVar) throws IncorrectOperationException {
        PsiAssignmentExpression assignment = null;
        PsiReferenceExpression resultUsage = null;
        for (PsiReference ref1 : ReferencesSearch.search((PsiElement)resultVar, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false)) {
            PsiReferenceExpression ref = (PsiReferenceExpression)ref1;
            if (ref.getParent() instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)ref.getParent()).getLExpression().equals(ref)) {
                if (assignment != null) {
                    assignment = null;
                    break;
                }
                assignment = (PsiAssignmentExpression)ref.getParent();
                continue;
            }
            LOG.assertTrue(resultUsage == null);
            resultUsage = ref;
        }
        if (assignment == null) {
            return;
        }
        boolean condition = assignment.getParent() instanceof PsiExpressionStatement;
        LOG.assertTrue(condition);
        if (assignment.getParent().getParent() != resultVar.getParent().getParent()) {
            return;
        }
        if (resultUsage != null) {
            String name = resultVar.getName();
            PsiDeclarationStatement declaration = this.myFactory.createVariableDeclarationStatement(name, resultVar.getType(), assignment.getRExpression());
            declaration = (PsiDeclarationStatement)assignment.getParent().replace((PsiElement)declaration);
            resultVar.getParent().delete();
            resultVar = (PsiVariable)declaration.getDeclaredElements()[0];
            PsiElement parentStatement = RefactoringUtil.getParentStatement((PsiElement)resultUsage, true);
            boolean canInline = false;
            for (PsiElement next = declaration.getNextSibling(); next != null; next = next.getNextSibling()) {
                if (parentStatement.equals(next)) {
                    canInline = true;
                    break;
                }
                if (next instanceof PsiStatement) break;
            }
            if (canInline) {
                InlineUtil.inlineVariable(resultVar, resultVar.getInitializer(), (PsiJavaCodeReferenceElement)resultUsage);
                declaration.delete();
            }
        } else {
            PsiExpression rExpression = assignment.getRExpression();
            while (rExpression instanceof PsiReferenceExpression) {
                rExpression = ((PsiReferenceExpression)rExpression).getQualifierExpression();
            }
            if (rExpression == null || !PsiUtil.isStatement((PsiElement)rExpression)) {
                assignment.delete();
            } else {
                assignment.replace((PsiElement)rExpression);
            }
            resultVar.delete();
        }
    }

    private PsiReferenceExpression[] addBracesWhenNeeded(PsiReferenceExpression[] refs) throws IncorrectOperationException {
        ArrayList<PsiReferenceExpression> refsVector = new ArrayList<PsiReferenceExpression>();
        ArrayList<PsiBlockStatement> addedBracesVector = new ArrayList<PsiBlockStatement>();
        this.myAddedClassInitializers = new HashMap();
        for (PsiReferenceExpression ref : refs) {
            ref.putCopyableUserData(MARK_KEY, (Object)"");
        }
        block1: for (PsiReferenceExpression ref : refs) {
            if (!ref.isValid()) continue;
            PsiElement parentStatement = RefactoringUtil.getParentStatement((PsiElement)ref, true);
            if (parentStatement != null) {
                PsiElement parent = ref.getParent();
                while (!parent.equals(parentStatement)) {
                    if (parent instanceof PsiStatement && !(parent instanceof PsiDeclarationStatement)) {
                        String text = "{\n}";
                        PsiBlockStatement blockStatement = (PsiBlockStatement)this.myFactory.createStatementFromText(text, null);
                        blockStatement = (PsiBlockStatement)this.myCodeStyleManager.reformat((PsiElement)blockStatement);
                        blockStatement.getCodeBlock().add(parent);
                        blockStatement = (PsiBlockStatement)parent.replace((PsiElement)blockStatement);
                        PsiStatement newStatement = blockStatement.getCodeBlock().getStatements()[0];
                        InlineMethodProcessor.addMarkedElements(refsVector, (PsiElement)newStatement);
                        addedBracesVector.add(blockStatement);
                        continue block1;
                    }
                    parent = parent.getParent();
                }
            } else {
                PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiField.class);
                if (field != null) {
                    if (field instanceof PsiEnumConstant) {
                        this.inlineEnumConstantParameter(refsVector, ref);
                        continue;
                    }
                    field.normalizeDeclaration();
                    PsiExpression initializer = field.getInitializer();
                    LOG.assertTrue(initializer != null);
                    PsiClassInitializer classInitializer = this.myFactory.createClassInitializer();
                    PsiClass containingClass = field.getContainingClass();
                    classInitializer = (PsiClassInitializer)containingClass.addAfter((PsiElement)classInitializer, (PsiElement)field);
                    containingClass.addAfter(CodeEditUtil.createLineFeed(field.getManager()), (PsiElement)field);
                    PsiCodeBlock body = classInitializer.getBody();
                    PsiExpressionStatement statement = (PsiExpressionStatement)this.myFactory.createStatementFromText(field.getName() + " = 0;", (PsiElement)body);
                    statement = (PsiExpressionStatement)body.add((PsiElement)statement);
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement.getExpression();
                    assignment.getLExpression().replace((PsiElement)RenameJavaVariableProcessor.createMemberReference((PsiMember)field, (PsiElement)assignment));
                    assignment.getRExpression().replace((PsiElement)initializer);
                    InlineMethodProcessor.addMarkedElements(refsVector, (PsiElement)statement);
                    if (field.hasModifierProperty("static")) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)classInitializer, (String)"static", (boolean)true);
                    }
                    this.myAddedClassInitializers.put(field, classInitializer);
                    continue;
                }
            }
            refsVector.add(ref);
        }
        for (PsiReferenceExpression ref : refs) {
            ref.putCopyableUserData(MARK_KEY, null);
        }
        this.myAddedBraces = addedBracesVector.toArray(new PsiBlockStatement[addedBracesVector.size()]);
        return refsVector.toArray(new PsiReferenceExpression[refsVector.size()]);
    }

    private void inlineEnumConstantParameter(final List<PsiReferenceExpression> refsVector, PsiReferenceExpression ref) throws IncorrectOperationException {
        PsiExpression expr = InlineMethodProcessor.getSimpleReturnedExpression(this.myMethod);
        if (expr != null) {
            refsVector.add(ref);
        } else {
            PsiExpressionList args;
            PsiExpression[] argExpressions;
            PsiCall call = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiCall.class);
            String text = "new Object() { " + this.myMethod.getReturnTypeElement().getText() + " evaluate() { return " + call.getText() + ";}}.evaluate";
            PsiExpression callExpr = JavaPsiFacade.getInstance((Project)this.myProject).getParserFacade().createExpressionFromText(text, (PsiElement)call);
            PsiElement classExpr = ref.replace((PsiElement)callExpr);
            classExpr.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReturnStatement(PsiReturnStatement statement) {
                    super.visitReturnStatement(statement);
                    PsiExpression expr = statement.getReturnValue();
                    if (expr instanceof PsiMethodCallExpression) {
                        refsVector.add(((PsiMethodCallExpression)expr).getMethodExpression());
                    }
                }
            });
            if (classExpr.getParent() instanceof PsiMethodCallExpression && (argExpressions = (args = ((PsiMethodCallExpression)classExpr.getParent()).getArgumentList()).getExpressions()).length > 0) {
                args.deleteChildRange((PsiElement)argExpressions[0], (PsiElement)argExpressions[argExpressions.length - 1]);
            }
        }
    }

    @Nullable
    private static PsiExpression getSimpleReturnedExpression(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] psiStatements = body.getStatements();
        if (psiStatements.length != 1) {
            return null;
        }
        PsiStatement statement = psiStatements[0];
        if (!(statement instanceof PsiReturnStatement)) {
            return null;
        }
        return ((PsiReturnStatement)statement).getReturnValue();
    }

    private static void addMarkedElements(final List<PsiReferenceExpression> array, PsiElement scope) {
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element.getCopyableUserData(MARK_KEY) != null) {
                    array.add((PsiReferenceExpression)element);
                    element.putCopyableUserData(MARK_KEY, null);
                }
                super.visitElement(element);
            }
        });
    }

    private void removeAddedBracesWhenPossible() throws IncorrectOperationException {
        if (this.myAddedBraces == null) {
            return;
        }
        for (PsiBlockStatement blockStatement : this.myAddedBraces) {
            PsiStatement[] statements = blockStatement.getCodeBlock().getStatements();
            if (statements.length != 1) continue;
            blockStatement.replace((PsiElement)statements[0]);
        }
        Set<PsiField> fields = this.myAddedClassInitializers.keySet();
        for (PsiField psiField : fields) {
            PsiClassInitializer classInitializer;
            PsiExpression initializer = this.getSimpleFieldInitializer(psiField, classInitializer = this.myAddedClassInitializers.get(psiField));
            if (initializer != null) {
                psiField.getInitializer().replace((PsiElement)initializer);
                classInitializer.delete();
                continue;
            }
            psiField.getInitializer().delete();
        }
    }

    @Nullable
    private PsiExpression getSimpleFieldInitializer(PsiField field, PsiClassInitializer initializer) {
        PsiStatement[] statements = initializer.getBody().getStatements();
        if (statements.length != 1) {
            return null;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpression expression = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiExpression lExpression = ((PsiAssignmentExpression)expression).getLExpression();
        if (!(lExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolved = ((PsiReferenceExpression)lExpression).resolve();
        if (!this.myManager.areElementsEquivalent((PsiElement)field, resolved)) {
            return null;
        }
        return ((PsiAssignmentExpression)expression).getRExpression();
    }

    public static boolean checkBadReturns(PsiMethod method) {
        int offset;
        ControlFlow controlFlow;
        PsiReturnStatement[] returns = RefactoringUtil.findReturnStatements(method);
        if (returns.length == 0) {
            return false;
        }
        PsiCodeBlock body = method.getBody();
        try {
            controlFlow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow((PsiElement)body, new LocalsControlFlowPolicy((PsiElement)body), false);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Control flow:");
            LOG.debug(controlFlow.toString());
        }
        ArrayList<Instruction> instructions = new ArrayList<Instruction>(controlFlow.getInstructions());
        for (PsiReturnStatement aReturn : returns) {
            int endOffset = controlFlow.getEndOffset((PsiElement)aReturn);
            for (offset = controlFlow.getStartOffset((PsiElement)aReturn); offset <= endOffset && !(instructions.get(offset) instanceof GoToInstruction); ++offset) {
            }
            LOG.assertTrue(instructions.get(offset) instanceof GoToInstruction);
            instructions.set(offset, EmptyInstruction.INSTANCE);
        }
        for (PsiReturnStatement aReturn : returns) {
            offset = controlFlow.getEndOffset((PsiElement)aReturn);
            while (offset != instructions.size()) {
                Instruction instruction = (Instruction)instructions.get(offset);
                if (instruction instanceof GoToInstruction) {
                    offset = ((GoToInstruction)instruction).offset;
                    continue;
                }
                if (instruction instanceof ThrowToInstruction) {
                    offset = ((ThrowToInstruction)instruction).offset;
                    continue;
                }
                if (instruction instanceof ConditionalThrowToInstruction) {
                    ++offset;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        List<Object> list;
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/inline/InlineMethodProcessor.getElementsToWrite must not be null");
        }
        if (this.myInlineThisOnly) {
            list = Collections.singletonList(this.myReference);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/refactoring/inline/InlineMethodProcessor.getElementsToWrite must not return null");
            return list;
        }
        list = this.myReference == null ? Collections.singletonList(this.myMethod) : Arrays.asList(this.myReference, this.myMethod);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/refactoring/inline/InlineMethodProcessor.getElementsToWrite must not return null");
    }

    private static class BlockData {
        final PsiCodeBlock block;
        final PsiLocalVariable thisVar;
        final PsiLocalVariable[] parmVars;
        final PsiLocalVariable resultVar;

        public BlockData(PsiCodeBlock block, PsiLocalVariable thisVar, PsiLocalVariable[] parmVars, PsiLocalVariable resultVar) {
            this.block = block;
            this.thisVar = thisVar;
            this.parmVars = parmVars;
            this.resultVar = resultVar;
        }
    }
}

