/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.refactoring.inlineSuperClass.InlineSuperClassRefactoringProcessor;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.util.Function;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class InlineSuperClassRefactoringDialog
extends RefactoringDialog {
    private final PsiClass mySuperClass;
    private final PsiClass[] myTargetClasses;

    protected InlineSuperClassRefactoringDialog(@NotNull Project project, PsiClass superClass, PsiClass ... targetClasses) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringDialog.<init> must not be null");
        }
        super(project, false);
        this.mySuperClass = superClass;
        this.myTargetClasses = targetClasses;
        this.init();
        this.setTitle("Inline Super Class");
    }

    @Override
    protected void doAction() {
        this.invokeRefactoring(new InlineSuperClassRefactoringProcessor(this.getProject(), this.mySuperClass, this.myTargetClasses));
    }

    protected JComponent createCenterPanel() {
        return new JLabel("<html>Inline '" + this.mySuperClass.getQualifiedName() + "' to <br>&nbsp;&nbsp;&nbsp;'" + StringUtil.join((Object[])this.myTargetClasses, (Function)new Function<PsiClass, String>(){

            public String fun(PsiClass psiClass) {
                return psiClass.getQualifiedName();
            }
        }, (String)"',<br>&nbsp;&nbsp;&nbsp;'") + "'</html>");
    }
}

