/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass.usageInfo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;

public class ReplaceWithSubtypeUsageInfo
extends FixableUsageInfo {
    public static final Logger LOG = Logger.getInstance((String)("#" + ReplaceWithSubtypeUsageInfo.class.getName()));
    private final PsiTypeElement myTypeElement;
    private final PsiClassType myTargetClassType;
    private final PsiType myOriginalType;
    private String myConflict;

    public ReplaceWithSubtypeUsageInfo(PsiTypeElement typeElement, PsiClassType classType, PsiClass[] targetClasses) {
        super((PsiElement)typeElement);
        this.myTypeElement = typeElement;
        this.myTargetClassType = classType;
        this.myOriginalType = this.myTypeElement.getType();
        if (targetClasses.length > 1) {
            this.myConflict = typeElement.getText() + " can be replaced with any of " + StringUtil.join((Object[])targetClasses, (Function)new Function<PsiClass, String>(){

                public String fun(PsiClass psiClass) {
                    return psiClass.getQualifiedName();
                }
            }, (String)", ");
        }
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        if (this.myTypeElement.isValid()) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myTypeElement.getProject()).getElementFactory();
            this.myTypeElement.replace((PsiElement)elementFactory.createTypeElement((PsiType)this.myTargetClassType));
        }
    }

    @Override
    public String getConflictMessage() {
        if (!TypeConversionUtil.isAssignable((PsiType)this.myOriginalType, (PsiType)this.myTargetClassType)) {
            String conflict = "No consistent substitution found for " + this.getElement().getText() + ". Expected '" + this.myOriginalType.getPresentableText() + "' but found '" + this.myTargetClassType.getPresentableText() + "'.";
            this.myConflict = this.myConflict == null ? conflict : this.myConflict + "\n" + conflict;
        }
        return this.myConflict;
    }
}

