/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.codeInsight.intention.impl.CreateSubclassAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.JavaRefactoringListenerManager;
import com.intellij.refactoring.listeners.impl.JavaRefactoringListenerManagerImpl;
import com.intellij.refactoring.memberPushDown.JavaPushDownHandler;
import com.intellij.refactoring.memberPushDown.PushDownConflicts;
import com.intellij.refactoring.memberPushDown.PushDownUsageViewDescriptor;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PushDownProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.memberPushDown.PushDownProcessor");
    private final MemberInfo[] myMemberInfos;
    private PsiClass myClass;
    private final DocCommentPolicy myJavaDocPolicy;
    private CreateClassDialog myCreateClassDlg;
    private static final Key<Boolean> REMOVE_QUALIFIER_KEY = Key.create((String)"REMOVE_QUALIFIER_KEY");
    private static final Key<PsiClass> REPLACE_QUALIFIER_KEY = Key.create((String)"REPLACE_QUALIFIER_KEY");

    public PushDownProcessor(Project project, MemberInfo[] memberInfos, PsiClass aClass, DocCommentPolicy javaDocPolicy) {
        super(project);
        this.myMemberInfos = memberInfos;
        this.myClass = aClass;
        this.myJavaDocPolicy = javaDocPolicy;
    }

    @Override
    protected String getCommandName() {
        return JavaPushDownHandler.REFACTORING_NAME;
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new PushDownUsageViewDescriptor(this.myClass);
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        PsiClass[] inheritors = (PsiClass[])ClassInheritorsSearch.search((PsiClass)this.myClass, (SearchScope)this.myClass.getUseScope(), (boolean)false).toArray((Object[])PsiClass.EMPTY_ARRAY);
        UsageInfo[] usages = new UsageInfo[inheritors.length];
        for (int i = 0; i < inheritors.length; ++i) {
            usages[i] = new UsageInfo((PsiElement)inheritors[i]);
        }
        if (usages == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/memberPushDown/PushDownProcessor.findUsages must not return null");
        }
        return usages;
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        PushDownConflicts pushDownConflicts = new PushDownConflicts(this.myClass, this.myMemberInfos);
        pushDownConflicts.checkSourceClassConflicts();
        if (usagesIn.length == 0) {
            if (this.myClass.isEnum() || this.myClass.hasModifierProperty("final")) {
                if (Messages.showOkCancelDialog((String)((this.myClass.isEnum() ? "Enum " + this.myClass.getQualifiedName() + " doesn't have constants to inline to. " : "Final class " + this.myClass.getQualifiedName() + "does not have inheritors. ") + "Pushing members down will result in them being deleted. " + "Would you like to proceed?"), (String)JavaPushDownHandler.REFACTORING_NAME, (Icon)Messages.getWarningIcon()) != 0) {
                    return false;
                }
            } else {
                String noInheritors = this.myClass.isInterface() ? RefactoringBundle.message((String)"interface.0.does.not.have.inheritors", (Object[])new Object[]{this.myClass.getQualifiedName()}) : RefactoringBundle.message((String)"class.0.does.not.have.inheritors", (Object[])new Object[]{this.myClass.getQualifiedName()});
                String message = noInheritors + "\n" + RefactoringBundle.message((String)"push.down.will.delete.members");
                int answer = Messages.showYesNoCancelDialog((String)message, (String)JavaPushDownHandler.REFACTORING_NAME, (Icon)Messages.getWarningIcon());
                if (answer == 0) {
                    this.myCreateClassDlg = CreateSubclassAction.chooseSubclassToCreate(this.myClass);
                    if (this.myCreateClassDlg != null) {
                        pushDownConflicts.checkTargetClassConflicts(null, false, (PsiElement)this.myCreateClassDlg.getTargetDirectory());
                        return this.showConflicts(pushDownConflicts.getConflicts());
                    }
                    return false;
                }
                if (answer != 1) {
                    return false;
                }
            }
        }
        for (UsageInfo usage : usagesIn) {
            PsiElement element = usage.getElement();
            if (!(element instanceof PsiClass)) continue;
            pushDownConflicts.checkTargetClassConflicts((PsiClass)element, usagesIn.length > 1, element);
        }
        return this.showConflicts(pushDownConflicts.getConflicts());
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        if (elements.length == 1 && elements[0] instanceof PsiClass) {
            this.myClass = (PsiClass)elements[0];
        } else {
            LOG.assertTrue(false);
        }
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        try {
            PsiClass psiClass;
            this.encodeRefs();
            if (this.myCreateClassDlg != null && (psiClass = CreateSubclassAction.createSubclass(this.myClass, this.myCreateClassDlg.getTargetDirectory(), this.myCreateClassDlg.getClassName())) != null) {
                this.pushDownToClass(psiClass);
            }
            for (UsageInfo usage : usages) {
                if (!(usage.getElement() instanceof PsiClass)) continue;
                PsiClass targetClass = (PsiClass)usage.getElement();
                this.pushDownToClass(targetClass);
            }
            this.removeFromTargetClass();
        }
        catch (IncorrectOperationException e) {
            LOG.assertTrue(false);
        }
    }

    private void encodeRefs() {
        HashSet movedMembers = new HashSet();
        for (MemberInfo memberInfo : this.myMemberInfos) {
            movedMembers.add(memberInfo.getMember());
        }
        for (MemberInfo memberInfo : this.myMemberInfos) {
            PsiMember member = (PsiMember)memberInfo.getMember();
            member.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Set)movedMembers){
                final /* synthetic */ Set val$movedMembers;
                {
                    this.val$movedMembers = set;
                }

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    PushDownProcessor.this.encodeRef((PsiJavaCodeReferenceElement)expression, this.val$movedMembers, (PsiElement)expression);
                    super.visitReferenceExpression(expression);
                }

                public void visitNewExpression(PsiNewExpression expression) {
                    PsiJavaCodeReferenceElement classReference = expression.getClassReference();
                    if (classReference != null) {
                        PushDownProcessor.this.encodeRef(classReference, this.val$movedMembers, (PsiElement)expression);
                    }
                    super.visitNewExpression(expression);
                }

                public void visitTypeElement(PsiTypeElement type) {
                    PsiJavaCodeReferenceElement referenceElement = type.getInnermostComponentReferenceElement();
                    if (referenceElement != null) {
                        PushDownProcessor.this.encodeRef(referenceElement, this.val$movedMembers, (PsiElement)type);
                    }
                    super.visitTypeElement(type);
                }
            });
            ChangeContextUtil.encodeContextInfo((PsiElement)member, false);
        }
    }

    private void encodeRef(PsiJavaCodeReferenceElement expression, Set<PsiMember> movedMembers, PsiElement toPut) {
        PsiElement resolved = expression.resolve();
        if (resolved == null) {
            return;
        }
        PsiElement qualifier = expression.getQualifier();
        for (PsiMember movedMember : movedMembers) {
            PsiJavaCodeReferenceElement qElement;
            if (movedMember.equals(resolved)) {
                if (qualifier == null) {
                    toPut.putCopyableUserData(REMOVE_QUALIFIER_KEY, (Object)Boolean.TRUE);
                    continue;
                }
                if (!(qualifier instanceof PsiJavaCodeReferenceElement) || !((PsiJavaCodeReferenceElement)qualifier).isReferenceTo((PsiElement)this.myClass)) continue;
                toPut.putCopyableUserData(REPLACE_QUALIFIER_KEY, (Object)this.myClass);
                continue;
            }
            if (movedMember instanceof PsiClass && PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiClass.class, (boolean)false) == movedMember) {
                if (!(qualifier instanceof PsiJavaCodeReferenceElement) || !((PsiJavaCodeReferenceElement)qualifier).isReferenceTo((PsiElement)movedMember)) continue;
                toPut.putCopyableUserData(REPLACE_QUALIFIER_KEY, (Object)((PsiClass)movedMember));
                continue;
            }
            if (!(qualifier instanceof PsiThisExpression) || (qElement = ((PsiThisExpression)qualifier).getQualifier()) == null || !qElement.isReferenceTo((PsiElement)this.myClass)) continue;
            toPut.putCopyableUserData(REPLACE_QUALIFIER_KEY, (Object)this.myClass);
        }
    }

    private void decodeRefs(PsiMember member, final PsiClass targetClass) {
        try {
            ChangeContextUtil.decodeContextInfo((PsiElement)member, null, null);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        final PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        member.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PushDownProcessor.this.decodeRef((PsiJavaCodeReferenceElement)expression, factory, targetClass, (PsiElement)expression);
                super.visitReferenceExpression(expression);
            }

            public void visitNewExpression(PsiNewExpression expression) {
                PsiJavaCodeReferenceElement classReference = expression.getClassReference();
                if (classReference != null) {
                    PushDownProcessor.this.decodeRef(classReference, factory, targetClass, (PsiElement)expression);
                }
                super.visitNewExpression(expression);
            }

            public void visitTypeElement(PsiTypeElement type) {
                PsiJavaCodeReferenceElement referenceElement = type.getInnermostComponentReferenceElement();
                if (referenceElement != null) {
                    PushDownProcessor.this.decodeRef(referenceElement, factory, targetClass, (PsiElement)type);
                }
                super.visitTypeElement(type);
            }
        });
    }

    private void decodeRef(PsiJavaCodeReferenceElement ref, PsiElementFactory factory, PsiClass targetClass, PsiElement toGet) {
        try {
            if (toGet.getCopyableUserData(REMOVE_QUALIFIER_KEY) != null) {
                toGet.putCopyableUserData(REMOVE_QUALIFIER_KEY, null);
                PsiElement qualifier = ref.getQualifier();
                if (qualifier != null) {
                    qualifier.delete();
                }
            } else {
                PsiClass psiClass = (PsiClass)toGet.getCopyableUserData(REPLACE_QUALIFIER_KEY);
                if (psiClass != null) {
                    toGet.putCopyableUserData(REPLACE_QUALIFIER_KEY, null);
                    PsiElement qualifier = ref.getQualifier();
                    if (qualifier != null) {
                        if (psiClass == this.myClass) {
                            psiClass = targetClass;
                        } else if (psiClass.getContainingClass() == this.myClass) {
                            LOG.assertTrue((psiClass = targetClass.findInnerClassByName(psiClass.getName(), false)) != null);
                        }
                        if (!(qualifier instanceof PsiThisExpression) && ref instanceof PsiReferenceExpression) {
                            ((PsiReferenceExpression)ref).setQualifierExpression((PsiExpression)factory.createReferenceExpression(psiClass));
                        } else {
                            if (qualifier instanceof PsiThisExpression) {
                                qualifier = ((PsiThisExpression)qualifier).getQualifier();
                            }
                            qualifier.replace((PsiElement)factory.createReferenceElementByType(factory.createType(psiClass)));
                        }
                    }
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void removeFromTargetClass() throws IncorrectOperationException {
        for (MemberInfo memberInfo : this.myMemberInfos) {
            PsiElement member = memberInfo.getMember();
            if (member instanceof PsiField) {
                member.delete();
                continue;
            }
            if (member instanceof PsiMethod) {
                if (memberInfo.isToAbstract()) {
                    PsiMethod method = (PsiMethod)member;
                    if (method.hasModifierProperty("private")) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"protected", (boolean)true);
                    }
                    RefactoringUtil.abstractizeMethod(this.myClass, method);
                    this.myJavaDocPolicy.processOldJavaDoc(method.getDocComment());
                    continue;
                }
                member.delete();
                continue;
            }
            if (!(member instanceof PsiClass)) continue;
            if (Boolean.FALSE.equals(memberInfo.getOverrides())) {
                RefactoringUtil.removeFromReferenceList(this.myClass.getImplementsList(), (PsiClass)member);
                continue;
            }
            member.delete();
        }
    }

    private void pushDownToClass(PsiClass targetClass) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory();
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.myClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.myClass)) {
            block1: for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter)) {
                PsiElement element = reference.getElement();
                PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
                if (member == null) continue;
                for (MemberInfo memberInfo : this.myMemberInfos) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)memberInfo.getMember(), (PsiElement)member, (boolean)false)) continue;
                    PsiType substitutedType = substitutor.substitute(parameter);
                    if (substitutedType == null) continue block1;
                    element.getParent().replace((PsiElement)factory.createTypeElement(substitutedType));
                    continue block1;
                }
            }
        }
        for (MemberInfo memberInfo : this.myMemberInfos) {
            PsiMember member = (PsiMember)memberInfo.getMember();
            ArrayList<PsiReference> refsToRebind = new ArrayList<PsiReference>();
            PsiModifierList list = member.getModifierList();
            LOG.assertTrue(list != null);
            if (list.hasModifierProperty("static")) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)member)) {
                    PsiExpression qualifierExpression;
                    PsiElement element = reference.getElement();
                    if (element instanceof PsiReferenceExpression && (qualifierExpression = ((PsiReferenceExpression)element).getQualifierExpression()) instanceof PsiReferenceExpression && !(((PsiReferenceExpression)qualifierExpression).resolve() instanceof PsiClass)) continue;
                    refsToRebind.add(reference);
                }
            }
            PsiMember newMember = null;
            if (member instanceof PsiField) {
                ((PsiField)member).normalizeDeclaration();
                newMember = (PsiMember)targetClass.add((PsiElement)member);
            } else if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                PsiMethod methodBySignature = targetClass.findMethodBySignature(method, false);
                if (methodBySignature == null) {
                    newMember = (PsiMethod)targetClass.add((PsiElement)method);
                    if (memberInfo.isToAbstract()) {
                        if (newMember.hasModifierProperty("private")) {
                            PsiUtil.setModifierProperty((PsiModifierListOwner)newMember, (String)"protected", (boolean)true);
                        }
                        this.myJavaDocPolicy.processNewJavaDoc(((PsiMethod)newMember).getDocComment());
                    }
                } else {
                    PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)methodBySignature, (String[])new String[]{"java.lang.Override"});
                    if (annotation != null) {
                        annotation.delete();
                    }
                }
            } else if (member instanceof PsiClass) {
                if (Boolean.FALSE.equals(memberInfo.getOverrides())) {
                    PsiClass aClass = (PsiClass)member;
                    if (!targetClass.isInheritor(aClass, false)) {
                        PsiJavaCodeReferenceElement classRef = factory.createClassReferenceElement(aClass);
                        targetClass.getImplementsList().add((PsiElement)classRef);
                    }
                } else {
                    newMember = (PsiMember)targetClass.add((PsiElement)member);
                }
            }
            if (newMember == null) continue;
            this.decodeRefs(newMember, targetClass);
            Collections.sort(refsToRebind, new Comparator<PsiReference>(){

                @Override
                public int compare(PsiReference o1, PsiReference o2) {
                    return PsiUtil.BY_POSITION.compare(o1.getElement(), o2.getElement());
                }
            });
            for (PsiReference psiReference : refsToRebind) {
                JavaCodeStyleManagerImpl.getInstance((Project)this.myProject).shortenClassReferences(psiReference.bindToElement((PsiElement)newMember));
            }
            JavaRefactoringListenerManager listenerManager = JavaRefactoringListenerManager.getInstance((Project)newMember.getProject());
            ((JavaRefactoringListenerManagerImpl)listenerManager).fireMemberMoved(this.myClass, newMember);
        }
    }
}

