/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.AutomaticRenamingDialog;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.RenameViewDescriptor;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RelatedUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameProcessor");
    protected final LinkedHashMap<PsiElement, String> myAllRenames;
    private PsiElement myPrimaryElement;
    private String myNewName;
    private boolean mySearchInComments;
    private boolean mySearchTextOccurrences;
    protected boolean myForceShowPreview;
    private String myCommandName;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final List<AutomaticRenamerFactory> myRenamerFactories;
    private final List<AutomaticRenamer> myRenamers;

    public RenameProcessor(Project project, PsiElement element, @NotNull @NonNls String newName, boolean isSearchInComments, boolean isSearchTextOccurrences) {
        if (newName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/refactoring/rename/RenameProcessor.<init> must not be null");
        }
        super(project);
        this.myAllRenames = new LinkedHashMap();
        this.myNewName = null;
        this.myNonCodeUsages = new NonCodeUsageInfo[0];
        this.myRenamerFactories = new ArrayList<AutomaticRenamerFactory>();
        this.myRenamers = new ArrayList<AutomaticRenamer>();
        this.myPrimaryElement = element;
        this.mySearchInComments = isSearchInComments;
        this.mySearchTextOccurrences = isSearchTextOccurrences;
        this.setNewName(newName);
    }

    public RenameProcessor(Project project) {
        this(project, null, "", false, false);
    }

    public Set<PsiElement> getElements() {
        return Collections.unmodifiableSet(this.myAllRenames.keySet());
    }

    public void addRenamerFactory(AutomaticRenamerFactory factory) {
        if (!this.myRenamerFactories.contains(factory)) {
            this.myRenamerFactories.add(factory);
        }
    }

    public void removeRenamerFactory(AutomaticRenamerFactory factory) {
        this.myRenamerFactories.remove(factory);
    }

    @Override
    public void doRun() {
        this.prepareRenaming();
        super.doRun();
    }

    public void prepareRenaming() {
        RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement(this.myPrimaryElement);
        processor.prepareRenaming(this.myPrimaryElement, this.myNewName, this.myAllRenames);
        this.myForceShowPreview = processor.forcesShowPreview();
    }

    @Nullable
    private String getHelpID() {
        return RenamePsiElementProcessor.forElement(this.myPrimaryElement).getHelpID(this.myPrimaryElement);
    }

    @Override
    public boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        RenameUtil.addConflictDescriptions(usagesIn, (MultiMap<PsiElement, String>)conflicts);
        RenamePsiElementProcessor.forElement(this.myPrimaryElement).findExistingNameConflicts(this.myPrimaryElement, this.myNewName, (MultiMap<PsiElement, String>)conflicts);
        if (!conflicts.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, (MultiMap<PsiElement, String>)conflicts);
            conflictsDialog.show();
            if (!conflictsDialog.isOK()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        HashSet usagesSet = new HashSet(Arrays.asList(usagesIn));
        RenameUtil.removeConflictUsages((Set<UsageInfo>)usagesSet);
        ArrayList<UsageInfo> variableUsages = new ArrayList<UsageInfo>();
        if (!this.myRenamers.isEmpty()) {
            if (!this.findRenamedVariables(variableUsages)) {
                return false;
            }
            for (AutomaticRenamer renamer : this.myRenamers) {
                List<PsiNamedElement> variables = renamer.getElements();
                for (PsiNamedElement variable : variables) {
                    String newName = renamer.getNewName(variable);
                    if (newName == null) continue;
                    this.addElement((PsiElement)variable, newName);
                }
            }
        }
        if (!variableUsages.isEmpty()) {
            usagesSet.addAll(variableUsages);
            refUsages.set((Object)usagesSet.toArray(new UsageInfo[usagesSet.size()]));
        }
        this.prepareSuccessful();
        return true;
    }

    private boolean findRenamedVariables(final List<UsageInfo> variableUsages) {
        for (AutomaticRenamer automaticVariableRenamer : this.myRenamers) {
            if (!automaticVariableRenamer.hasAnythingToRename() || this.showAutomaticRenamingDialog(automaticVariableRenamer)) continue;
            return false;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (AutomaticRenamer renamer : RenameProcessor.this.myRenamers) {
                    renamer.findUsages(variableUsages, RenameProcessor.this.mySearchInComments, RenameProcessor.this.mySearchTextOccurrences);
                }
            }
        };
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, RefactoringBundle.message((String)"searching.for.variables"), true, this.myProject);
    }

    protected boolean showAutomaticRenamingDialog(AutomaticRenamer automaticVariableRenamer) {
        AutomaticRenamingDialog dialog = new AutomaticRenamingDialog(this.myProject, automaticVariableRenamer);
        dialog.show();
        return dialog.isOK();
    }

    public void addElement(@NotNull PsiElement element, @NotNull String newName) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/RenameProcessor.addElement must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/rename/RenameProcessor.addElement must not be null");
        }
        this.myAllRenames.put(element, newName);
    }

    private void setNewName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/RenameProcessor.setNewName must not be null");
        }
        if (this.myPrimaryElement == null) {
            this.myCommandName = RefactoringBundle.message((String)"renaming.something");
            return;
        }
        this.myNewName = newName;
        this.myAllRenames.put(this.myPrimaryElement, newName);
        this.myCommandName = RefactoringBundle.message((String)"renaming.0.1.to.2", (Object[])new Object[]{UsageViewUtil.getType(this.myPrimaryElement), UsageViewUtil.getDescriptiveName(this.myPrimaryElement), newName});
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        return new RenameViewDescriptor(this.myAllRenames);
    }

    @Override
    @NotNull
    public UsageInfo[] findUsages() {
        this.myRenamers.clear();
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>(this.myAllRenames.keySet());
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = (PsiElement)elements.get(i);
            String newName = this.myAllRenames.get(element);
            UsageInfo[] usages = RenameUtil.findUsages(element, newName, this.mySearchInComments, this.mySearchTextOccurrences, this.myAllRenames);
            List<UsageInfo> usagesList = Arrays.asList(usages);
            result.addAll(usagesList);
            for (AutomaticRenamerFactory factory : this.myRenamerFactories) {
                if (!factory.isApplicable(element)) continue;
                this.myRenamers.add(factory.createRenamer(element, newName, usagesList));
            }
            for (AutomaticRenamerFactory factory : (AutomaticRenamerFactory[])Extensions.getExtensions(AutomaticRenamerFactory.EP_NAME)) {
                if (factory.getOptionName() != null || !factory.isApplicable(element)) continue;
                this.myRenamers.add(factory.createRenamer(element, newName, usagesList));
            }
        }
        UsageInfo[] usageInfos = result.toArray(new UsageInfo[result.size()]);
        if ((usageInfos = UsageViewUtil.removeDuplicatedUsages(usageInfos)) == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/rename/RenameProcessor.findUsages must not return null");
        }
        return usageInfos;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        LOG.assertTrue(elements.length > 0);
        if (this.myPrimaryElement != null) {
            this.myPrimaryElement = elements[0];
        }
        Iterator<String> newNames = this.myAllRenames.values().iterator();
        LinkedHashMap<PsiElement, String> newAllRenames = new LinkedHashMap<PsiElement, String>();
        for (PsiElement resolved : elements) {
            newAllRenames.put(resolved, newNames.next());
        }
        this.myAllRenames.clear();
        this.myAllRenames.putAll(newAllRenames);
    }

    @Override
    protected boolean isPreviewUsages(UsageInfo[] usages) {
        if (this.myForceShowPreview) {
            return true;
        }
        if (super.isPreviewUsages(usages)) {
            return true;
        }
        if (UsageViewUtil.hasNonCodeUsages(usages)) {
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"occurrences.found.in.comments.strings.and.non.java.files"));
            return true;
        }
        return false;
    }

    @Override
    public void performRefactoring(UsageInfo[] usages) {
        String message = null;
        try {
            for (Map.Entry<PsiElement, String> entry : this.myAllRenames.entrySet()) {
                RenameUtil.checkRename(entry.getKey(), entry.getValue());
            }
        }
        catch (IncorrectOperationException e) {
            message = e.getMessage();
        }
        if (message != null) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"rename.title"), (String)message, (String)this.getHelpID(), (Project)this.myProject);
            return;
        }
        ArrayList<Runnable> postRenameCallbacks = new ArrayList<Runnable>();
        for (Map.Entry<PsiElement, String> entry : this.myAllRenames.entrySet()) {
            PsiElement element = entry.getKey();
            String newName = entry.getValue();
            RefactoringElementListener elementListener = this.getTransaction().getElementListener(element);
            RenameUtil.doRename(element, newName, RenameProcessor.extractUsagesForElement(element, usages), this.myProject, elementListener);
            Runnable postRenameCallback = RenamePsiElementProcessor.forElement(element).getPostRenameCallback(element, newName, elementListener);
            if (postRenameCallback == null) continue;
            postRenameCallbacks.add(postRenameCallback);
        }
        for (Runnable runnable : postRenameCallbacks) {
            runnable.run();
        }
        ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof NonCodeUsageInfo)) continue;
            nonCodeUsages.add((NonCodeUsageInfo)usage);
        }
        this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[nonCodeUsages.size()]);
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
    }

    @Override
    protected String getCommandName() {
        return this.myCommandName;
    }

    public static UsageInfo[] extractUsagesForElement(PsiElement element, UsageInfo[] usages) {
        ArrayList<MoveRenameUsageInfo> extractedUsages = new ArrayList<MoveRenameUsageInfo>(usages.length);
        for (UsageInfo usage : usages) {
            LOG.assertTrue(usage instanceof MoveRenameUsageInfo);
            if (usage.getReference() instanceof LightElement) continue;
            MoveRenameUsageInfo usageInfo = (MoveRenameUsageInfo)usage;
            if (usage instanceof RelatedUsageInfo) {
                if (((RelatedUsageInfo)usage).getRelatedElement() != element) continue;
                extractedUsages.add(usageInfo);
                continue;
            }
            PsiElement referenced = usageInfo.getReferencedElement();
            if (!element.equals(referenced) && (referenced == null || element != referenced.getNavigationElement())) continue;
            extractedUsages.add(usageInfo);
        }
        return extractedUsages.toArray(new UsageInfo[extractedUsages.size()]);
    }

    @Override
    protected void prepareTestRun() {
        if (!PsiElementRenameHandler.canRename(this.myProject, null, this.myPrimaryElement)) {
            return;
        }
        this.prepareRenaming();
    }

    public Collection<String> getNewNames() {
        return this.myAllRenames.values();
    }

    public void setSearchInComments(boolean value) {
        this.mySearchInComments = value;
    }

    public void setSearchTextOccurrences(boolean searchTextOccurrences) {
        this.mySearchTextOccurrences = searchTextOccurrences;
    }

    public boolean isSearchInComments() {
        return this.mySearchInComments;
    }

    public boolean isSearchTextOccurrences() {
        return this.mySearchTextOccurrences;
    }

    public void setCommandName(String commandName) {
        this.myCommandName = commandName;
    }
}

