/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.codeInsight.daemon.impl.JavaReferenceImporter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class CodeFragmentTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private Document myDocument;
    protected PsiCodeFragment myCodeFragment;
    private final Project myProject;
    private EditorTextField myEditorTextField;

    public CodeFragmentTableCellEditor(Project project) {
        this.myProject = project;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.myCodeFragment = (PsiCodeFragment)value;
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)this.myCodeFragment);
        this.myEditorTextField = new EditorTextField(this.myDocument, this.myProject, (FileType)StdFileTypes.JAVA){

            @Override
            protected boolean shouldHaveBorder() {
                return false;
            }
        };
        return this.myEditorTextField;
    }

    public PsiCodeFragment getCellEditorValue() {
        return this.myCodeFragment;
    }

    @Override
    public boolean stopCellEditing() {
        Editor editor = this.myEditorTextField.getEditor();
        if (editor != null) {
            JavaReferenceImporter.autoImportReferenceAtCursor(editor, (PsiFile)this.myCodeFragment, true);
        }
        super.stopCellEditing();
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
        return true;
    }
}

