/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class DuplicatesImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.duplicates.DuplicatesImpl");

    private DuplicatesImpl() {
    }

    public static void invoke(Project project, Editor editor, MatchProvider provider) {
        List<Match> duplicates = provider.getDuplicates();
        int idx = 0;
        for (Match match : duplicates) {
            if (!match.getMatchStart().isValid() || !match.getMatchEnd().isValid() || !DuplicatesImpl.replaceMatch(project, provider, match, editor, ++idx, duplicates.size())) continue;
            return;
        }
    }

    public static void invoke(Project project, MatchProvider provider) {
        List<Match> duplicates = provider.getDuplicates();
        int idx = 0;
        for (Match match : duplicates) {
            PsiFile file = match.getFile();
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null || !virtualFile.isValid()) {
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), false);
            LOG.assertTrue(editor != null);
            if (!match.getMatchStart().isValid() || !match.getMatchEnd().isValid() || !DuplicatesImpl.replaceMatch(project, provider, match, editor, ++idx, duplicates.size())) continue;
            return;
        }
    }

    private static boolean replaceMatch(Project project, final MatchProvider provider, final Match match, Editor editor, int idx, int size) {
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        DuplicatesImpl.highlightMatch(project, editor, match, highlighters);
        TextRange textRange = match.getTextRange();
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(textRange.getStartOffset());
        DuplicatesImpl.expandAllRegionsCoveringRange(project, editor, textRange);
        editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
        String prompt = provider.getConfirmDuplicatePrompt(match);
        int matchAnswer = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((Project)project, (String)prompt, (String)RefactoringBundle.message((String)"process.duplicates.title", (Object[])new Object[]{idx, size}), (Icon)Messages.getQuestionIcon());
        HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, highlighters.get(0));
        if (matchAnswer == 0) {
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    try {
                        provider.processMatch(match);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            };
            ApplicationManager.getApplication().runWriteAction(action);
        } else if (matchAnswer == 2) {
            return true;
        }
        return false;
    }

    private static void expandAllRegionsCoveringRange(Project project, Editor editor, TextRange textRange) {
        final FoldRegion[] foldRegions = CodeFoldingManager.getInstance(project).getFoldRegionsAtOffset(editor, textRange.getStartOffset());
        boolean anyCollapsed = false;
        for (FoldRegion foldRegion : foldRegions) {
            if (foldRegion.isExpanded()) continue;
            anyCollapsed = true;
            break;
        }
        if (anyCollapsed) {
            editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                @Override
                public void run() {
                    for (FoldRegion foldRegion : foldRegions) {
                        if (foldRegion.isExpanded()) continue;
                        foldRegion.setExpanded(true);
                    }
                }
            });
        }
    }

    public static void highlightMatch(Project project, Editor editor, Match match, ArrayList<RangeHighlighter> highlighters) {
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        HighlightManager.getInstance((Project)project).addRangeHighlight(editor, match.getTextRange().getStartOffset(), match.getTextRange().getEndOffset(), attributes, true, highlighters);
    }

    public static void processDuplicates(MatchProvider provider, Project project, Editor editor) {
        int answer;
        boolean hasDuplicates = provider.hasDuplicates();
        if (hasDuplicates && (answer = Messages.showYesNoDialog((Project)project, (String)RefactoringBundle.message((String)"0.has.detected.1.code.fragments.in.this.file.that.can.be.replaced.with.a.call.to.extracted.method", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), provider.getDuplicates().size()}), (String)"Process Duplicates", (Icon)Messages.getQuestionIcon())) == 0) {
            DuplicatesImpl.invoke(project, editor, provider);
        }
    }
}

