/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceUtil;
import com.intellij.slicer.forward.SliceFUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import gnu.trove.TObjectHashingStrategy;
import org.jetbrains.annotations.NotNull;

public class SliceUsage
extends UsageInfo2UsageAdapter {
    private final SliceUsage myParent;
    public final SliceAnalysisParams params;
    private final PsiSubstitutor mySubstitutor;

    public SliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceUsage.<init> must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceUsage.<init> must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/slicer/SliceUsage.<init> must not be null");
        }
        super(new UsageInfo(element));
        this.myParent = parent;
        this.mySubstitutor = substitutor;
        this.params = parent.params;
        assert (this.params != null);
    }

    public SliceUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceUsage.<init> must not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceUsage.<init> must not be null");
        }
        super(new UsageInfo(element));
        this.myParent = null;
        this.params = params;
        this.mySubstitutor = PsiSubstitutor.EMPTY;
    }

    public void processChildren(Processor<SliceUsage> processor) {
        final PsiElement element = this.getElement();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.checkCanceled();
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor, (TObjectHashingStrategy)new TObjectHashingStrategy<SliceUsage>(){

            public int computeHashCode(SliceUsage object) {
                return object.getUsageInfo().hashCode();
            }

            public boolean equals(SliceUsage o1, SliceUsage o2) {
                return o1.getUsageInfo().equals((Object)o2.getUsageInfo());
            }
        });
        ApplicationManager.getApplication().runReadAction(new Runnable((Processor)uniqueProcessor){
            final /* synthetic */ Processor val$uniqueProcessor;
            {
                this.val$uniqueProcessor = processor;
            }

            @Override
            public void run() {
                if (SliceUsage.this.params.dataFlowToThis) {
                    SliceUtil.processUsagesFlownDownTo(element, (Processor<SliceUsage>)this.val$uniqueProcessor, SliceUsage.this, SliceUsage.this.mySubstitutor);
                } else {
                    SliceFUtil.processUsagesFlownFromThe(element, (Processor<SliceUsage>)this.val$uniqueProcessor, SliceUsage.this);
                }
            }
        });
    }

    public SliceUsage getParent() {
        return this.myParent;
    }

    @NotNull
    public AnalysisScope getScope() {
        AnalysisScope analysisScope = this.params.scope;
        if (analysisScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceUsage.getScope must not return null");
        }
        return analysisScope;
    }

    SliceUsage copy() {
        PsiElement element = this.getUsageInfo().getElement();
        return this.getParent() == null ? new SliceUsage(element, this.params) : new SliceUsage(element, this.getParent(), this.mySubstitutor);
    }

    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }
}

