/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.UsefulTestCase;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public abstract class LexerTestCase
extends UsefulTestCase {
    protected void doTest(@NonNls String text) {
        IElementType tokenType;
        Lexer lexer = this.createLexer();
        lexer.start((CharSequence)text);
        String result = "";
        while ((tokenType = lexer.getTokenType()) != null) {
            String tokenText = LexerTestCase.getTokenText(lexer);
            String tokenTypeName = tokenType.toString();
            String line = tokenTypeName + " ('" + tokenText + "')\n";
            result = result + line;
            lexer.advance();
        }
        LexerTestCase.assertSameLinesWithFile(PathManager.getHomePath() + "/" + this.getDirPath() + "/" + this.getTestName(true) + ".txt", result);
    }

    protected void doFileTest(@NonNls String fileExt) {
        String fileName = PathManager.getHomePath() + "/" + this.getDirPath() + "/" + this.getTestName(true) + "." + fileExt;
        String text = "";
        try {
            text = new String(FileUtil.loadFileText((File)new File(fileName))).trim();
        }
        catch (IOException e) {
            LexerTestCase.fail((String)("can't load file " + fileName + ": " + e.getMessage()));
        }
        this.doTest(text);
    }

    private static String getTokenText(Lexer lexer) {
        String text = ((Object)lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd())).toString();
        text = StringUtil.replace((String)text, (String)"\n", (String)"\\n");
        return text;
    }

    protected abstract Lexer createLexer();

    protected abstract String getDirPath();
}

