/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.builders.EmptyModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import java.io.File;
import org.jetbrains.annotations.NonNls;

public abstract class CodeInsightFixtureTestCase
extends UsefulTestCase {
    protected CodeInsightTestFixture myFixture;
    protected Module myModule;

    protected void setUp() throws Exception {
        super.setUp();
        TestFixtureBuilder<IdeaProjectTestFixture> projectBuilder = IdeaTestFixtureFactory.getFixtureFactory().createFixtureBuilder();
        this.myFixture = IdeaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture(projectBuilder.getFixture());
        EmptyModuleFixtureBuilder moduleFixtureBuilder = projectBuilder.addModule(EmptyModuleFixtureBuilder.class);
        moduleFixtureBuilder.addSourceContentRoot(this.myFixture.getTempDirPath());
        this.tuneFixture(moduleFixtureBuilder);
        this.myFixture.setUp();
        this.myFixture.setTestDataPath(this.getTestDataPath());
        this.myModule = moduleFixtureBuilder.getFixture().getModule();
    }

    @Override
    protected void tearDown() throws Exception {
        this.myFixture.tearDown();
        this.myFixture = null;
        this.myModule = null;
        super.tearDown();
    }

    protected void tuneFixture(EmptyModuleFixtureBuilder moduleBuilder) {
    }

    @NonNls
    protected String getBasePath() {
        return "";
    }

    @NonNls
    protected final String getTestDataPath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/') + this.getBasePath();
    }
}

