/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileTypeFilter
extends FileFilter {
    private final FileType myType;
    private final String myDescription;

    public FileTypeFilter(FileType fileType) {
        this.myType = fileType;
        this.myDescription = this.myType.getDescription();
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        FileType type = FileTypeManager.getInstance().getFileTypeByFileName(f.getName());
        return this.myType == type;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }
}

