/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.highlighting.DomElementsHighlightingUtil;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolderImpl;
import com.intellij.util.xml.highlighting.DomHighlightStatus;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.highlighting.DomHighlightingHelperImpl;
import com.intellij.util.xml.highlighting.MockAnnotatingDomInspection;
import com.intellij.util.xml.highlighting.MockDomInspection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementAnnotationsManagerImpl
extends DomElementAnnotationsManager {
    public static final Object LOCK = new Object();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl");
    private static final Key<DomElementsProblemsHolderImpl> DOM_PROBLEM_HOLDER_KEY = Key.create((String)"DomProblemHolder");
    private static final Key<CachedValue<Boolean>> CACHED_VALUE_KEY = Key.create((String)"DomProblemHolderCachedValue");
    private final EventDispatcher<DomElementAnnotationsManager.DomHighlightingListener> myDispatcher = EventDispatcher.create(DomElementAnnotationsManager.DomHighlightingListener.class);
    private final Map<Class, List<DomElementsAnnotator>> myClass2Annotator = new THashMap();
    private static final DomElementsProblemsHolder EMPTY_PROBLEMS_HOLDER = new DomElementsProblemsHolder(){

        @NotNull
        public List<DomElementProblemDescriptor> getProblems(DomElement domElement) {
            List<DomElementProblemDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl$1.getProblems must not return null");
            }
            return list;
        }

        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren, HighlightSeverity minSeverity) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean withChildren, HighlightSeverity minSeverity) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getAllProblems() {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getAllProblems(@NotNull DomElementsInspection inspection) {
            if (inspection == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl$1.getAllProblems must not be null");
            }
            return Collections.emptyList();
        }

        public boolean isInspectionCompleted(@NotNull DomElementsInspection inspectionClass) {
            if (inspectionClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl$1.isInspectionCompleted must not be null");
            }
            return false;
        }
    };
    private final DomHighlightingHelperImpl myHighlightingHelper = new DomHighlightingHelperImpl(this);
    private final ModificationTracker myModificationTracker;
    private final ProjectRootManager myProjectRootManager;
    private final CachedValuesManager myCachedValuesManager;
    private long myModificationCount;

    public DomElementAnnotationsManagerImpl(Project project, final InspectionProfileManager inspectionProfileManager, ProjectRootManager projectRootManager, CachedValuesManager cachedValuesManager) {
        this.myCachedValuesManager = cachedValuesManager;
        this.myProjectRootManager = projectRootManager;
        this.myModificationTracker = new ModificationTracker(){

            public long getModificationCount() {
                return DomElementAnnotationsManagerImpl.this.myModificationCount;
            }
        };
        final ProfileChangeAdapter profileChangeAdapter = new ProfileChangeAdapter(){

            public void profileActivated(Profile oldProfile, Profile profile) {
                DomElementAnnotationsManagerImpl.this.dropAnnotationsCache();
            }

            public void profileChanged(Profile profile) {
                DomElementAnnotationsManagerImpl.this.dropAnnotationsCache();
            }
        };
        inspectionProfileManager.addProfileChangeListener(profileChangeAdapter, (Disposable)project);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                inspectionProfileManager.removeProfileChangeListener(profileChangeAdapter);
            }
        });
    }

    public void dropAnnotationsCache() {
        ++this.myModificationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<DomElementProblemDescriptor> appendProblems(@NotNull DomFileElement element, @NotNull DomElementAnnotationHolder annotationHolder, Class<? extends DomElementsInspection> inspectionClass) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.appendProblems must not be null");
        }
        if (annotationHolder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.appendProblems must not be null");
        }
        DomElementAnnotationHolderImpl holderImpl = (DomElementAnnotationHolderImpl)annotationHolder;
        Object object = LOCK;
        synchronized (object) {
            DomElementsProblemsHolderImpl holder = this._getOrCreateProblemsHolder(element);
            holder.appendProblems(holderImpl, inspectionClass);
        }
        ((DomElementAnnotationsManager.DomHighlightingListener)this.myDispatcher.getMulticaster()).highlightingFinished(element);
        return Collections.unmodifiableList(holderImpl);
    }

    private DomElementsProblemsHolderImpl _getOrCreateProblemsHolder(final DomFileElement element) {
        DomElement rootElement = element.getRootElement();
        XmlTag rootTag = rootElement.getXmlTag();
        if (rootTag == null) {
            return new DomElementsProblemsHolderImpl(element);
        }
        DomElementsProblemsHolderImpl holder = (DomElementsProblemsHolderImpl)rootTag.getUserData(DOM_PROBLEM_HOLDER_KEY);
        if (DomElementAnnotationsManagerImpl.isHolderOutdated(element.getFile()) || holder == null) {
            holder = new DomElementsProblemsHolderImpl(element);
            rootTag.putUserData(DOM_PROBLEM_HOLDER_KEY, (Object)holder);
            CachedValue cachedValue = this.myCachedValuesManager.createCachedValue((CachedValueProvider)new CachedValueProvider<Boolean>(){

                public CachedValueProvider.Result<Boolean> compute() {
                    return new CachedValueProvider.Result((Object)Boolean.FALSE, new Object[]{element, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, DomElementAnnotationsManagerImpl.this.myModificationTracker, DomElementAnnotationsManagerImpl.this.myProjectRootManager});
                }
            }, false);
            cachedValue.getValue();
            element.getFile().putUserData(CACHED_VALUE_KEY, (Object)cachedValue);
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHolderUpToDate(DomElement element) {
        Object object = LOCK;
        synchronized (object) {
            return !DomElementAnnotationsManagerImpl.isHolderOutdated(DomUtil.getFile((DomElement)element));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outdateProblemHolder(DomElement element) {
        Object object = LOCK;
        synchronized (object) {
            DomUtil.getFile((DomElement)element).putUserData(CACHED_VALUE_KEY, null);
        }
    }

    private static boolean isHolderOutdated(XmlFile file) {
        CachedValue cachedValue = (CachedValue)file.getUserData(CACHED_VALUE_KEY);
        return cachedValue == null || !cachedValue.hasUpToDateValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public DomElementsProblemsHolder getProblemHolder(DomElement element) {
        DomElementsProblemsHolder domElementsProblemsHolder;
        DomElementsProblemsHolder domElementsProblemsHolder2;
        if (element == null || !element.isValid()) {
            domElementsProblemsHolder2 = EMPTY_PROBLEMS_HOLDER;
            if (domElementsProblemsHolder2 == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.getProblemHolder must not return null");
            return domElementsProblemsHolder2;
        }
        DomFileElement fileElement = DomUtil.getFileElement((DomElement)element);
        Object object = LOCK;
        synchronized (object) {
            DomElementsProblemsHolder readyHolder;
            XmlTag tag = fileElement.getRootElement().getXmlTag();
            if (tag != null && (readyHolder = (DomElementsProblemsHolder)tag.getUserData(DOM_PROBLEM_HOLDER_KEY)) != null) {
                DomElementsProblemsHolder domElementsProblemsHolder3 = readyHolder;
                // MONITOREXIT @DISABLED, blocks:[2, 8] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                domElementsProblemsHolder2 = domElementsProblemsHolder3;
                if (domElementsProblemsHolder3 == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.getProblemHolder must not return null");
                return domElementsProblemsHolder2;
            }
            domElementsProblemsHolder = EMPTY_PROBLEMS_HOLDER;
        }
        domElementsProblemsHolder2 = domElementsProblemsHolder;
        if (domElementsProblemsHolder != null) return domElementsProblemsHolder2;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.getProblemHolder must not return null");
    }

    @NotNull
    public DomElementsProblemsHolder getCachedProblemHolder(DomElement element) {
        DomElementsProblemsHolder domElementsProblemsHolder = this.getProblemHolder(element);
        if (domElementsProblemsHolder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.getCachedProblemHolder must not return null");
        }
        return domElementsProblemsHolder;
    }

    public void annotate(DomElement element, DomElementAnnotationHolder holder, Class rootClass) {
        List<DomElementsAnnotator> list = this.getAnnotators(rootClass);
        if (list != null) {
            for (DomElementsAnnotator annotator : list) {
                annotator.annotate(element, holder);
            }
        }
    }

    public final void registerDomElementsAnnotator(DomElementsAnnotator annotator, Class<? extends DomElement> aClass) {
        this.getOrCreateAnnotators(aClass).add(annotator);
    }

    private List<DomElementsAnnotator> getOrCreateAnnotators(Class aClass) {
        List<DomElementsAnnotator> annotators = this.getAnnotators(aClass);
        if (annotators == null) {
            annotators = new ArrayList<DomElementsAnnotator>();
            this.myClass2Annotator.put(aClass, annotators);
        }
        return annotators;
    }

    @Nullable
    private List<DomElementsAnnotator> getAnnotators(Class aClass) {
        return this.myClass2Annotator.get(aClass);
    }

    public List<ProblemDescriptor> createProblemDescriptors(InspectionManager manager, DomElementProblemDescriptor problemDescriptor) {
        return ContainerUtil.createMaybeSingletonList((Object)DomElementsHighlightingUtil.createProblemDescriptors(manager, problemDescriptor));
    }

    public boolean isHighlightingFinished(DomElement[] domElements) {
        for (DomElement domElement : domElements) {
            if (this.getHighlightStatus(domElement) == DomHighlightStatus.INSPECTIONS_FINISHED) continue;
            return false;
        }
        return true;
    }

    public void addHighlightingListener(DomElementAnnotationsManager.DomHighlightingListener listener, Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public DomHighlightingHelper getHighlightingHelper() {
        return this.myHighlightingHelper;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public <T extends DomElement> List<DomElementProblemDescriptor> checkFileElement(@NotNull DomFileElement<T> domFileElement, @NotNull DomElementsInspection<T> inspection) {
        List<DomElementProblemDescriptor> list;
        if (domFileElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.checkFileElement must not be null");
        }
        if (inspection == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.checkFileElement must not be null");
        }
        DomElementsProblemsHolder problemHolder = this.getProblemHolder((DomElement)domFileElement);
        if (DomElementAnnotationsManagerImpl.isHolderUpToDate(domFileElement) && problemHolder.isInspectionCompleted(inspection)) {
            list = problemHolder.getAllProblems(inspection);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.checkFileElement must not return null");
            return list;
        }
        DomElementAnnotationHolderImpl holder = new DomElementAnnotationHolderImpl();
        inspection.checkFileElement(domFileElement, (DomElementAnnotationHolder)holder);
        list = this.appendProblems(domFileElement, holder, inspection.getClass());
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.checkFileElement must not return null");
    }

    public List<DomElementsInspection> getSuitableDomInspections(DomFileElement fileElement, boolean enabledOnly) {
        Class rootType = fileElement.getRootElementClass();
        InspectionProfile profile = this.getInspectionProfile(fileElement);
        SmartList inspections = new SmartList();
        for (InspectionProfileEntry profileEntry : profile.getInspectionTools((PsiElement)fileElement.getFile())) {
            if (enabledOnly && !profile.isToolEnabled(HighlightDisplayKey.find((String)profileEntry.getShortName()), (PsiElement)fileElement.getFile())) continue;
            ContainerUtil.addIfNotNull((Object)DomElementAnnotationsManagerImpl.getSuitableInspection(profileEntry, rootType), (Collection)inspections);
        }
        return inspections;
    }

    protected InspectionProfile getInspectionProfile(DomFileElement fileElement) {
        return InspectionProjectProfileManager.getInstance(fileElement.getManager().getProject()).getInspectionProfile();
    }

    @Nullable
    private static DomElementsInspection getSuitableInspection(InspectionProfileEntry entry, Class rootType) {
        if (entry instanceof LocalInspectionToolWrapper) {
            return DomElementAnnotationsManagerImpl.getSuitableInspection((InspectionProfileEntry)((LocalInspectionToolWrapper)entry).getTool(), rootType);
        }
        if (entry instanceof DomElementsInspection && ((DomElementsInspection)entry).getDomClasses().contains(rootType)) {
            return (DomElementsInspection)entry;
        }
        return null;
    }

    @Nullable
    public <T extends DomElement> DomElementsInspection<T> getMockInspection(DomFileElement<T> root) {
        if (root.getFileDescription().isAutomaticHighlightingEnabled()) {
            return new MockAnnotatingDomInspection(root.getRootElementClass());
        }
        if (this.getSuitableDomInspections(root, false).isEmpty()) {
            return new MockDomInspection(root.getRootElementClass());
        }
        return null;
    }

    private static boolean areInspectionsFinished(DomElementsProblemsHolderImpl holder, List<DomElementsInspection> suitableInspections) {
        for (DomElementsInspection inspection : suitableInspections) {
            if (holder.isInspectionCompleted(inspection)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public DomHighlightStatus getHighlightStatus(DomElement element) {
        DomHighlightStatus domHighlightStatus;
        DomHighlightStatus domHighlightStatus2;
        Object object = LOCK;
        synchronized (object) {
            DomElementsProblemsHolder holder;
            DomFileElement root = DomUtil.getFileElement((DomElement)element);
            if (!DomElementAnnotationsManagerImpl.isHolderOutdated(root.getFile()) && (holder = this.getProblemHolder(element)) instanceof DomElementsProblemsHolderImpl) {
                DomElementsProblemsHolderImpl holderImpl = (DomElementsProblemsHolderImpl)holder;
                List<DomElementsInspection> suitableInspections = this.getSuitableDomInspections(root, true);
                DomElementsInspection mockInspection = this.getMockInspection(root);
                boolean annotatorsFinished = mockInspection == null || holderImpl.isInspectionCompleted(mockInspection);
                boolean inspectionsFinished = DomElementAnnotationsManagerImpl.areInspectionsFinished(holderImpl, suitableInspections);
                if (annotatorsFinished) {
                    if (suitableInspections.isEmpty() || inspectionsFinished) {
                        DomHighlightStatus domHighlightStatus3 = DomHighlightStatus.INSPECTIONS_FINISHED;
                        // MONITOREXIT @DISABLED, blocks:[3, 9, 11, 12] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                        domHighlightStatus2 = domHighlightStatus3;
                        if (domHighlightStatus3 == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.getHighlightStatus must not return null");
                        return domHighlightStatus2;
                    } else {
                        DomHighlightStatus domHighlightStatus4 = DomHighlightStatus.ANNOTATORS_FINISHED;
                        // MONITOREXIT @DISABLED, blocks:[3, 8, 11, 12] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                        domHighlightStatus2 = domHighlightStatus4;
                        if (domHighlightStatus4 == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.getHighlightStatus must not return null");
                        return domHighlightStatus2;
                    }
                }
            }
            domHighlightStatus = DomHighlightStatus.NONE;
        }
        domHighlightStatus2 = domHighlightStatus;
        if (domHighlightStatus != null) return domHighlightStatus2;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementAnnotationsManagerImpl.getHighlightStatus must not return null");
    }
}

