/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.xml.XmlChangeSet;
import com.intellij.pom.xml.XmlChangeVisitor;
import com.intellij.pom.xml.events.XmlAttributeSet;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.events.XmlDocumentChanged;
import com.intellij.pom.xml.events.XmlElementChanged;
import com.intellij.pom.xml.events.XmlTagChildAdd;
import com.intellij.pom.xml.events.XmlTagChildChanged;
import com.intellij.pom.xml.events.XmlTagChildRemoved;
import com.intellij.pom.xml.events.XmlTagNameChanged;
import com.intellij.pom.xml.events.XmlTextChanged;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.events.ElementChangedEvent;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class ExternalChangeProcessor
implements XmlChangeVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.ExternalChangeProcessor");
    private final Map<XmlTag, DomInvocationHandler> myChangeSets = new HashMap<XmlTag, DomInvocationHandler>();
    private boolean myDocumentChanged;
    private final DomManagerImpl myDomManager;

    public ExternalChangeProcessor(DomManagerImpl domManager, XmlChangeSet changeSet) {
        this.myDomManager = domManager;
        for (XmlChange xmlChange : changeSet.getChanges()) {
            xmlChange.accept((XmlChangeVisitor)this);
        }
    }

    public void processChanges() {
        if (this.myDocumentChanged) {
            return;
        }
        for (DomInvocationHandler handler : this.myChangeSets.values()) {
            this.myDomManager.fireEvent((DomEvent)new ElementChangedEvent(handler.getProxy()));
        }
    }

    private void addChange(XmlTag tag) {
        DomFileElementImpl element;
        PsiFile file = tag.getContainingFile();
        DomInvocationHandler handler = this.myChangeSets.get(tag);
        if (handler != null) {
            return;
        }
        while (tag != null) {
            DomInvocationHandler data = (DomInvocationHandler)((Object)tag.getUserData(DomManagerImpl.CACHED_DOM_HANDLER));
            if (data != null) {
                Type abstractType;
                Type chosenType;
                if (handler == null) {
                    handler = data;
                }
                if (!(chosenType = data.getDomElementType()).equals(abstractType = data.getAbstractType()) && !chosenType.equals(this.myDomManager.getTypeChooserManager().getTypeChooser(chosenType).chooseType(tag))) {
                    handler = data;
                }
            }
            tag = tag.getParentTag();
        }
        if (handler == null && file instanceof XmlFile && (element = DomManagerImpl.getCachedFileElement((XmlFile)file)) != null) {
            handler = element.getRootHandler();
        }
        if (handler != null) {
            this.myChangeSets.put(tag, handler);
        }
    }

    public void visitXmlAttributeSet(XmlAttributeSet xmlAttributeSet) {
        this.addChange(xmlAttributeSet.getTag());
    }

    public void visitDocumentChanged(XmlDocumentChanged change) {
        this.documentChanged((XmlFile)change.getDocument().getParent());
    }

    private void documentChanged(XmlFile xmlFile) {
        this.myDocumentChanged = true;
        DomFileElementImpl oldElement = DomManagerImpl.getCachedFileElement(xmlFile);
        if (oldElement != null) {
            DomEvent[] events = this.myDomManager.recomputeFileElement(xmlFile);
            if (this.myDomManager.getFileElement(xmlFile) != oldElement) {
                for (DomEvent event : events) {
                    this.myDomManager.fireEvent(event);
                }
                return;
            }
            DomRootInvocationHandler rootHandler = oldElement.getRootHandler();
            rootHandler.detach();
            XmlTag rootTag = oldElement.getRootTag();
            if (rootTag != null) {
                LOG.assertTrue(rootTag.isValid());
                rootHandler.setXmlElement((XmlElement)rootTag);
            }
            this.myDomManager.fireEvent((DomEvent)new ElementChangedEvent(oldElement.getRootElement()));
        }
    }

    public void visitXmlElementChanged(XmlElementChanged xmlElementChanged) {
        XmlElement element = xmlElementChanged.getElement();
        PsiElement parent = element.getParent();
        if (parent instanceof XmlTag) {
            this.addChange((XmlTag)parent);
        }
    }

    public void visitXmlTagChildAdd(XmlTagChildAdd xmlTagChildAdd) {
        this.addChange(xmlTagChildAdd.getTag());
    }

    public void visitXmlTagChildChanged(XmlTagChildChanged xmlTagChildChanged) {
        this.addChange(xmlTagChildChanged.getTag());
    }

    public void visitXmlTagChildRemoved(XmlTagChildRemoved xmlTagChildRemoved) {
        this.addChange(xmlTagChildRemoved.getTag());
    }

    public void visitXmlTagNameChanged(XmlTagNameChanged xmlTagNameChanged) {
        XmlTag tag = xmlTagNameChanged.getTag();
        XmlTag parentTag = tag.getParentTag();
        if (parentTag != null) {
            this.addChange(parentTag);
        } else {
            PsiFile file = tag.getContainingFile();
            if (file instanceof XmlFile) {
                this.documentChanged((XmlFile)file);
            }
        }
    }

    public void visitXmlTextChanged(XmlTextChanged xmlTextChanged) {
        this.addChange(xmlTextChanged.getText().getParentTag());
    }
}

