/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XAddToWatchesFromEditorActionHandler
extends XDebuggerActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session, DataContext dataContext) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler.isEnabled must not be null");
        }
        return XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session) != null;
    }

    @Nullable
    private static String getTextToEvaluate(DataContext dataContext, XDebugSession session) {
        XDebuggerEvaluator evaluator;
        XStackFrame stackFrame;
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        String text = editor.getSelectionModel().getSelectedText();
        if (text == null && session.isSuspended() && (stackFrame = session.getCurrentStackFrame()) != null && (evaluator = stackFrame.getEvaluator()) != null) {
            int offset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            TextRange textRange = evaluator.getExpressionRangeAtOffset(session.getProject(), document, offset);
            if (textRange != null) {
                text = textRange.substring(document.getText());
            }
        }
        return StringUtil.isEmptyOrSpaces((String)text) ? null : text;
    }

    @Override
    protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler.perform must not be null");
        }
        String text = XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session);
        if (text == null) {
            return;
        }
        ((XDebugSessionImpl)session).getSessionTab().getWatchesView().addWatchExpression(text, -1);
    }
}

