/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NotNull;

public class XmlSplitTagAction
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = XmlBundle.message((String)"xml.split.tag.intention.action", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/actions/XmlSplitTagAction.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)"xml.split.tag.intention.action", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/actions/XmlSplitTagAction.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement grandParent;
        PsiElement parent;
        int offset;
        PsiElement psiElement;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/actions/XmlSplitTagAction.isAvailable must not be null");
        }
        return file instanceof XmlFile && editor != null && (psiElement = file.findElementAt(offset = editor.getCaretModel().getOffset())) != null && (parent = psiElement.getParent()) != null && parent instanceof XmlText && parent.getText().trim().length() > 0 && (grandParent = parent.getParent()) != null && !XmlSplitTagAction.isInsideUnsplittableElement(grandParent);
    }

    private static boolean isInsideUnsplittableElement(PsiElement grandParent) {
        if (!(grandParent instanceof HtmlTag) && grandParent.getContainingFile().getLanguage() != XHTMLLanguage.INSTANCE) {
            return false;
        }
        String name = ((XmlTag)grandParent).getName();
        return "html".equals(name) || "body".equals(name) || "title".equals(name);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        int offset;
        PsiElement psiElement;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/actions/XmlSplitTagAction.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        if (editor != null && (psiElement = file.findElementAt(offset = editor.getCaretModel().getOffset())) != null) {
            PsiElement xmlText = psiElement.getParent();
            TextRange textRange = xmlText.getTextRange();
            int offsetInElement = offset - textRange.getStartOffset();
            PsiElement containingTag = xmlText.getParent();
            if (containingTag instanceof XmlTag) {
                XmlTag xmlTag = (XmlTag)containingTag;
                String s = xmlText.getText();
                String first = s.substring(0, offsetInElement);
                String second = s.substring(offsetInElement);
                String filetext = XmlSplitTagAction.buildNewText(xmlTag, first, second);
                XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.xml", (Language)XMLLanguage.INSTANCE, (CharSequence)filetext);
                PsiElement parent2 = containingTag.getParent();
                XmlTag tag = xmlFile.getDocument().getRootTag();
                XmlTag last = null;
                PsiElement[] children = tag.getChildren();
                for (int i = children.length - 1; i >= 0; --i) {
                    PsiElement element = children[i];
                    if (!(element instanceof XmlTag)) continue;
                    XmlTag tag1 = (XmlTag)parent2.addAfter(element, containingTag);
                    if (last != null) continue;
                    last = tag1;
                }
                containingTag.delete();
                editor.getCaretModel().moveToOffset(last.getValue().getTextRange().getStartOffset());
            }
        }
    }

    private static String buildNewText(XmlTag xmlTag, String first, String second) {
        StringBuilder attrs = new StringBuilder();
        StringBuilder attrsWoId = new StringBuilder();
        for (XmlAttribute attribute : xmlTag.getAttributes()) {
            if (!"id".equals(attribute.getName())) {
                attrs.append(attribute.getName()).append("=\"").append(attribute.getValue()).append("\" ");
                attrsWoId.append(attribute.getName()).append("=\"").append(attribute.getValue()).append("\" ");
                continue;
            }
            attrs.append(attribute.getName()).append("=\"").append(attribute.getValue()).append("\" ");
        }
        StringBuilder sb = new StringBuilder();
        String name = xmlTag.getName();
        sb.append("<root><").append(name);
        if (attrs.length() > 0) {
            sb.append(' ').append(attrs.toString());
        }
        sb.append('>');
        sb.append(first);
        sb.append("</").append(name).append("><").append(name);
        if (attrsWoId.length() > 0) {
            sb.append(' ').append(attrsWoId.toString());
        }
        sb.append('>');
        sb.append(second).append("</").append(name).append("></root>");
        return sb.toString();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

