/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.actions.xmlbeans.GenerateInstanceDocumentFromSchemaAction;
import com.intellij.xml.actions.xmlbeans.UIUtils;
import com.intellij.xml.actions.xmlbeans.Xsd2InstanceUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class GenerateInstanceDocumentFromSchemaDialog
extends DialogWrapper {
    private JPanel panel;
    private TextFieldWithBrowseButton generateFromUrl;
    private JLabel status;
    private JLabel statusText;
    private JLabel generateFromUrlText;
    private JComboBox rootElementChooser;
    private JLabel rootElementChooserText;
    private JCheckBox enableRestrictionCheck;
    private JCheckBox enableUniqueCheck;
    private JTextField outputFileName;
    private JLabel outputFileNameText;
    private String previousUri;
    private Runnable myOkAction;
    private Project myProject;

    public GenerateInstanceDocumentFromSchemaDialog(Project project, VirtualFile file) {
        super(project, true);
        this.myProject = project;
        this.$$$setupUI$$$();
        UIUtils.configureBrowseButton(project, this.generateFromUrl, new String[]{"xsd"}, XmlBundle.message((String)"select.xsd.schema.dialog.title", (Object[])new Object[0]), false);
        this.doInitFor(this.rootElementChooserText, this.rootElementChooser);
        this.doInitFor(this.generateFromUrlText, this.generateFromUrl.getTextField());
        this.doInitFor(this.outputFileNameText, this.outputFileName);
        this.generateFromUrl.setText(file.getPresentableUrl());
        this.updateFile();
        this.setTitle(XmlBundle.message((String)"generate.instance.document.from.schema.dialog.title", (Object[])new Object[0]));
        this.init();
        this.outputFileName.setText(file.getName() + ".xml");
    }

    public void doInitFor(JLabel textComponent, JComponent component) {
        textComponent.setLabelFor(component);
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    GenerateInstanceDocumentFromSchemaDialog.this.validateData();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    GenerateInstanceDocumentFromSchemaDialog.this.validateData();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    GenerateInstanceDocumentFromSchemaDialog.this.validateData();
                }
            });
        } else if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenerateInstanceDocumentFromSchemaDialog.this.validateData();
                }
            });
            ((JTextField)jComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    GenerateInstanceDocumentFromSchemaDialog.this.validateData();
                    GenerateInstanceDocumentFromSchemaDialog.this.updateFile();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    GenerateInstanceDocumentFromSchemaDialog.this.validateData();
                    GenerateInstanceDocumentFromSchemaDialog.this.updateFile();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    GenerateInstanceDocumentFromSchemaDialog.this.validateData();
                    GenerateInstanceDocumentFromSchemaDialog.this.updateFile();
                }
            });
            if (jComboBox.isEditable()) {
                jComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        GenerateInstanceDocumentFromSchemaDialog.this.validateData();
                    }
                });
            }
        }
    }

    private void validateData() {
        String msg = this.doValidateWithData();
        this.setOKActionEnabled(msg == null);
        this.status.setText(msg == null ? "" : msg);
        this.status.setForeground(Color.RED);
    }

    public void configureComboBox(JComboBox combo, List<String> lastValues) {
        combo.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(lastValues)));
    }

    private void updateFile() {
        String uri = this.generateFromUrl.getText();
        boolean hasPrevious = this.previousUri != null && this.previousUri.equals(uri);
        PsiFile psifile = this.findFile(uri);
        if (psifile == null) {
            this.configureComboBox(this.rootElementChooser, Collections.EMPTY_LIST);
            return;
        }
        XmlTag rootTag = this.getRootTag(psifile);
        if (rootTag == null) {
            this.configureComboBox(this.rootElementChooser, Collections.EMPTY_LIST);
            this.rootElementChooser.setSelectedIndex(-1);
            this.previousUri = uri;
            return;
        }
        List<String> myRootValues = Xsd2InstanceUtils.addVariantsFromRootTag(rootTag);
        Object selectedItem = this.rootElementChooser.getSelectedItem();
        this.configureComboBox(this.rootElementChooser, myRootValues);
        if (hasPrevious) {
            this.rootElementChooser.setSelectedItem(selectedItem);
        } else {
            this.rootElementChooser.setSelectedIndex(myRootValues.size() > 0 ? 0 : -1);
        }
        this.previousUri = uri;
    }

    private XmlTag getRootTag(PsiFile psifile) {
        return ((XmlFile)psifile).getDocument().getRootTag();
    }

    private PsiFile findFile(String uri) {
        VirtualFile file = uri != null ? VfsUtil.findRelativeFile((String)ExternalResourceManager.getInstance().getResourceLocation(uri), null) : null;
        return file != null ? PsiManager.getInstance((Project)this.myProject).findFile(file) : null;
    }

    public String getOutputFileName() {
        return this.outputFileName.getText();
    }

    public Boolean areCurrentParametersStillValid() {
        this.updateFile();
        return this.rootElementChooser.getSelectedItem() != null;
    }

    @Nullable
    protected String doValidateWithData() {
        XmlElementDescriptor descriptor;
        XmlTag tag;
        String rootElementName = this.getElementName();
        if (rootElementName == null || rootElementName.length() == 0) {
            return XmlBundle.message((String)"schema2.instance.no.valid.root.element.name.validation.error", (Object[])new Object[0]);
        }
        PsiFile psiFile = this.findFile(this.getUrl().getText());
        if (psiFile instanceof XmlFile && (tag = this.getRootTag(psiFile)) != null && (descriptor = Xsd2InstanceUtils.getDescriptor(tag, rootElementName)) == null) {
            return XmlBundle.message((String)"schema2.instance.no.valid.root.element.name.validation.error", (Object[])new Object[0]);
        }
        String fileName = this.getOutputFileName();
        if (fileName == null || fileName.length() == 0) {
            return XmlBundle.message((String)"schema2.instance.output.file.name.is.empty.validation.problem", (Object[])new Object[0]);
        }
        return null;
    }

    protected boolean isAcceptableFile(VirtualFile virtualFile) {
        return GenerateInstanceDocumentFromSchemaAction.isAcceptableFileForGenerateSchemaFromInstanceDocument(virtualFile);
    }

    protected TextFieldWithBrowseButton getUrl() {
        return this.generateFromUrl;
    }

    protected JLabel getUrlText() {
        return this.generateFromUrlText;
    }

    protected JLabel getStatusTextField() {
        return this.statusText;
    }

    protected JLabel getStatusField() {
        return this.status;
    }

    protected JComponent createCenterPanel() {
        return this.panel;
    }

    boolean enableUniquenessCheck() {
        return this.enableUniqueCheck.isSelected();
    }

    boolean enableRestrictionCheck() {
        return this.enableRestrictionCheck.isSelected();
    }

    String getElementName() {
        return (String)this.rootElementChooser.getSelectedItem();
    }

    public void setOkAction(Runnable runnable) {
        this.myOkAction = runnable;
    }

    protected void doOKAction() {
        super.doOKAction();
        if (this.myOkAction != null) {
            this.myOkAction.run();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JComboBox jComboBox;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(1, 1, 1, 1), -1, -1, false, false));
        this.generateFromUrlText = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/XmlBundle").getString("schema2instance.dialog.schema.path"));
        jLabel5.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.schema2instance.url.tooltip"));
        jPanel.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.statusText = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/XmlBundle").getString("any.dialog.status"));
        jLabel4.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("webservice.status.tooltip"));
        jPanel.add((Component)jLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.status = jLabel3 = new JLabel();
        jLabel3.setText("");
        jLabel3.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("webservice.status.tooltip"));
        jPanel.add((Component)jLabel3, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.generateFromUrl = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.instance2schema.url.tooltip"));
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.rootElementChooserText = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/XmlBundle").getString("schema2instance.dialog.element.name"));
        jLabel2.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.rootelement.tooltip"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.rootElementChooser = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jComboBox.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.rootelement.tooltip"));
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.enableRestrictionCheck = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.particle.valid.tooltip"));
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/XmlBundle").getString("schema2instance.dialog.enable.restriction.check"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.enableUniqueCheck = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox.setHorizontalTextPosition(4);
        jCheckBox.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.unique.particle.tooltip"));
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/XmlBundle").getString("schema2instance.dialog.enable.unique.check"));
        jCheckBox.setHorizontalAlignment(2);
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.outputFileNameText = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/XmlBundle").getString("schema2instance.dialog.instance.document.name"));
        jLabel.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.instance.document.name.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputFileName = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.instance.document.name.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

