/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.refactoring;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.refactoring.XmlTagInplaceRenamer;
import com.intellij.xml.refactoring.XmlTagRenameDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagRenameHandler
implements RenameHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.refactoring.XmlTagRenameHandler");

    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PsiElement element = XmlTagRenameHandler.getElement(dataContext);
        if (PsiElementRenameHandler.isVetoed(element)) {
            return false;
        }
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(XmlTag.class)).accepts((Object)element) && XmlTagRenameHandler.isDeclarationOutOfProjectOrAbsent(element.getProject(), dataContext);
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    private static boolean isInplaceRenameAvailable(Editor editor) {
        return editor.getSettings().isVariableInplaceRenameEnabled();
    }

    private static boolean isDeclarationOutOfProjectOrAbsent(@NotNull Project project, DataContext context) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/refactoring/XmlTagRenameHandler.isDeclarationOutOfProjectOrAbsent must not be null");
        }
        PsiElement[] elements = BaseRefactoringAction.getPsiElementArray(context);
        return elements.length == 0 || elements.length == 1 && XmlTagRenameHandler.shouldBeRenamedInplace(project, elements);
    }

    private static boolean shouldBeRenamedInplace(Project project, PsiElement[] elements) {
        boolean inProject = PsiManager.getInstance((Project)project).isInProject(elements[0]);
        if (inProject && elements[0] instanceof XmlTag) {
            XmlElementDescriptor descriptor = ((XmlTag)elements[0]).getDescriptor();
            return descriptor instanceof AnyXmlElementDescriptor;
        }
        return !inProject;
    }

    @Nullable
    private static Editor getEditor(@Nullable DataContext context) {
        return (Editor)PlatformDataKeys.EDITOR.getData(context);
    }

    @Nullable
    private static PsiElement getElement(@Nullable DataContext context) {
        Editor editor;
        if (context != null && (editor = XmlTagRenameHandler.getEditor(context)) != null) {
            PsiFile psiAtOffset;
            Language language;
            int offset = editor.getCaretModel().getOffset();
            PsiFile file = (PsiFile)LangDataKeys.PSI_FILE.getData(context);
            if (file instanceof XmlFile) {
                return file.getViewProvider().findElementAt(offset);
            }
            if (file != null && (language = PsiUtilBase.getLanguageAtOffset((PsiFile)file, (int)offset)) != file.getLanguage() && (psiAtOffset = file.getViewProvider().getPsi(language)) instanceof XmlFile) {
                return psiAtOffset.findElementAt(offset);
            }
        }
        return null;
    }

    private void invoke(@Nullable Editor editor, @NotNull PsiElement element, @Nullable DataContext context) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/refactoring/XmlTagRenameHandler.invoke must not be null");
        }
        if (!this.isRenaming(context)) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        if (XmlTagRenameHandler.isInplaceRenameAvailable(editor)) {
            XmlTagInplaceRenamer.rename(editor, (XmlTag)element.getParent());
        } else {
            XmlTagRenameDialog.renameXmlTag(editor, element, (XmlTag)element.getParent());
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @Nullable DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/refactoring/XmlTagRenameHandler.invoke must not be null");
        }
        if (!this.isRenaming(dataContext)) {
            return;
        }
        PsiElement element = XmlTagRenameHandler.getElement(dataContext);
        assert (element != null);
        this.invoke(editor, element, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/refactoring/XmlTagRenameHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/refactoring/XmlTagRenameHandler.invoke must not be null");
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = XmlTagRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element != null);
        this.invoke(XmlTagRenameHandler.getEditor(dataContext), element, dataContext);
    }
}

