/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.completion;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.file.FileLookupInfoProvider;
import com.intellij.util.indexing.FileBasedIndex;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.index.ImageInfoIndex;
import org.jetbrains.annotations.NotNull;

public class ImageLookupInfoProvider
extends FileLookupInfoProvider {
    public Pair<String, String> getLookupInfo(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/completion/ImageLookupInfoProvider.getLookupInfo must not be null");
        }
        final String[] s = new String[]{null};
        ImageInfoIndex.processValues(file, new FileBasedIndex.ValueProcessor<ImageInfoIndex.ImageInfo>(){

            @Override
            public boolean process(VirtualFile file, ImageInfoIndex.ImageInfo value) {
                s[0] = String.format("%sx%s", value.width, value.height);
                return true;
            }
        }, project);
        return s[0] == null ? null : new Pair((Object)file.getName(), (Object)s[0]);
    }

    @NotNull
    public FileType[] getFileTypes() {
        FileType[] fileTypeArray = new FileType[]{ImageFileTypeManager.getInstance().getImageFileType()};
        if (fileTypeArray == null) {
            throw new IllegalStateException("@NotNull method org/intellij/images/completion/ImageLookupInfoProvider.getFileTypes must not return null");
        }
        return fileTypeArray;
    }
}

