/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.IClass;
import org.testng.IInstanceInfo;
import org.testng.IObjectFactory;
import org.testng.ITestContext;
import org.testng.TestNGException;
import org.testng.annotations.IAnnotation;
import org.testng.internal.BaseClassFinder;
import org.testng.internal.ClassHelper;
import org.testng.internal.FactoryMethod;
import org.testng.internal.ObjectFactoryImpl;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGClassFinder
extends BaseClassFinder {
    private ITestContext m_testContext = null;
    private Map<Class, List<Object>> m_instanceMap = new HashMap<Class, List<Object>>();
    static /* synthetic */ Class class$org$testng$annotations$IObjectFactoryAnnotation;
    static /* synthetic */ Class class$org$testng$IObjectFactory;
    static /* synthetic */ Class class$org$testng$ITestContext;
    static /* synthetic */ Class class$org$testng$IInstanceInfo;

    public TestNGClassFinder(Class[] classes, Map<Class, List<Object>> instanceMap, XmlTest xmlTest, IAnnotationFinder annotationFinder, ITestContext testContext) {
        this.m_testContext = testContext;
        if (null == instanceMap) {
            instanceMap = new HashMap<Class, List<Object>>();
        }
        Class[] allClasses = classes;
        IObjectFactory objectFactory = testContext.getSuite().getObjectFactory();
        if (objectFactory == null) {
            objectFactory = new ObjectFactoryImpl();
            block4: for (Class cls : allClasses) {
                try {
                    if (null == cls) continue;
                    for (Method m : cls.getMethods()) {
                        IAnnotation a = annotationFinder.findAnnotation(m, class$org$testng$annotations$IObjectFactoryAnnotation == null ? TestNGClassFinder.class$("org.testng.annotations.IObjectFactoryAnnotation") : class$org$testng$annotations$IObjectFactoryAnnotation);
                        if (null == a) continue;
                        if (!(class$org$testng$IObjectFactory == null ? (class$org$testng$IObjectFactory = TestNGClassFinder.class$("org.testng.IObjectFactory")) : class$org$testng$IObjectFactory).isAssignableFrom(m.getReturnType())) {
                            throw new TestNGException(new StringBuffer().append("Return type of ").append(m).append(" is not IObjectFactory").toString());
                        }
                        try {
                            Object instance = cls.newInstance();
                            if (m.getParameterTypes().length > 0 && m.getParameterTypes()[0].equals(class$org$testng$ITestContext == null ? (class$org$testng$ITestContext = TestNGClassFinder.class$("org.testng.ITestContext")) : class$org$testng$ITestContext)) {
                                objectFactory = (IObjectFactory)m.invoke(instance, testContext);
                                break block4;
                            }
                            objectFactory = (IObjectFactory)m.invoke(instance, new Object[0]);
                            break block4;
                        }
                        catch (Exception ex) {
                            throw new TestNGException("Error creating object factory", ex);
                        }
                    }
                }
                catch (NoClassDefFoundError e) {
                    Utils.log("[TestNGClassFinder]", 1, new StringBuffer().append("Unable to read methods on class ").append(cls.getName()).append(" - unable to resolve class reference ").append(e.getMessage()).toString());
                    for (XmlClass xmlClass : xmlTest.getXmlClasses()) {
                        if (xmlClass.getDeclaredClass() != Boolean.TRUE || !xmlClass.getName().equals(cls.getName())) continue;
                        throw e;
                    }
                }
            }
        }
        for (Class cls : allClasses) {
            if (null == cls) {
                TestNGClassFinder.ppp("FOUND NULL CLASS IN FOLLOWING ARRAY:");
                int i = 0;
                for (Class c : allClasses) {
                    TestNGClassFinder.ppp(new StringBuffer().append("  ").append(i).append(": ").append(c).toString());
                }
                continue;
            }
            if (TestNGClassFinder.isTestNGClass(cls, annotationFinder)) {
                Object thisInstance;
                List<Object> allInstances = instanceMap.get(cls);
                Object object = thisInstance = null != allInstances ? allInstances.get(0) : null;
                if (null == thisInstance && Modifier.isAbstract(cls.getModifiers())) {
                    Utils.log("", 5, new StringBuffer().append("[WARN] Found an abstract class with no valid instance attached: ").append(cls).toString());
                    continue;
                }
                IClass ic = this.findOrCreateIClass(cls, thisInstance, xmlTest, annotationFinder, objectFactory);
                if (null == ic) continue;
                Object[] theseInstances = ic.getInstances(false);
                if (theseInstances.length == 0) {
                    theseInstances = ic.getInstances(true);
                }
                Object instance = theseInstances[0];
                this.putIClass(cls, ic);
                Method factoryMethod = ClassHelper.findFactoryMethod(cls, annotationFinder);
                if (null == factoryMethod) continue;
                FactoryMethod fm = new FactoryMethod(factoryMethod, instance, xmlTest, annotationFinder, this.m_testContext);
                ArrayList moreClasses = new ArrayList();
                Object[] instances = fm.invoke();
                if (instances.length > 0) {
                    Class<?> elementClass;
                    if ((class$org$testng$IInstanceInfo == null ? TestNGClassFinder.class$("org.testng.IInstanceInfo") : class$org$testng$IInstanceInfo).isAssignableFrom(elementClass = instances[0].getClass())) {
                        for (Object o : instances) {
                            IInstanceInfo ii = (IInstanceInfo)o;
                            this.addInstance(ii.getInstanceClass(), ii.getInstance());
                            moreClasses.add(ii.getInstanceClass());
                        }
                    } else {
                        for (Object o : instances) {
                            this.addInstance(o.getClass(), o);
                            if (this.classExists(o.getClass())) continue;
                            moreClasses.add(o.getClass());
                        }
                    }
                }
                if (moreClasses.size() <= 0) continue;
                TestNGClassFinder finder = new TestNGClassFinder(moreClasses.toArray(new Class[moreClasses.size()]), this.m_instanceMap, xmlTest, annotationFinder, this.m_testContext);
                IClass[] moreIClasses = finder.findTestClasses();
                for (IClass ic2 : moreIClasses) {
                    this.putIClass(ic2.getRealClass(), ic2);
                }
                continue;
            }
            Utils.log("TestNGClassFinder", 3, new StringBuffer().append("SKIPPING CLASS ").append(cls).append(" no TestNG annotations found").toString());
        }
        for (Class c : this.m_instanceMap.keySet()) {
            List<Object> instances = this.m_instanceMap.get(c);
            for (Object instance : instances) {
                IClass ic = this.getIClass(c);
                if (null == ic) continue;
                ic.addInstance(instance);
            }
        }
    }

    public static boolean isTestNGClass(Class cls, IAnnotationFinder annotationFinder) {
        Class[] allAnnotations = AnnotationHelper.getAllAnnotations();
        try {
            for (Class annotation : allAnnotations) {
                for (Method m : cls.getMethods()) {
                    IAnnotation ma = annotationFinder.findAnnotation(m, annotation);
                    if (null == ma) continue;
                    return true;
                }
                IAnnotation a = annotationFinder.findAnnotation(cls, annotation);
                if (null != a) {
                    return true;
                }
                for (Constructor<?> ctor : cls.getConstructors()) {
                    IAnnotation ca = annotationFinder.findAnnotation(ctor, annotation);
                    if (null == ca) continue;
                    return true;
                }
            }
            return false;
        }
        catch (NoClassDefFoundError e) {
            Utils.log("[TestNGClassFinder]", 1, new StringBuffer().append("Unable to read methods on class ").append(cls.getName()).append(" - unable to resolve class reference ").append(e.getMessage()).toString());
            return false;
        }
    }

    private void addInstance(Class clazz, Object o) {
        List<Object> list = this.m_instanceMap.get(clazz);
        if (null == list) {
            list = new ArrayList<Object>();
            this.m_instanceMap.put(clazz, list);
        }
        list.add(o);
    }

    public static void ppp(String s) {
        System.out.println(new StringBuffer().append("[TestNGClassFinder] ").append(s).toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

