/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.bool.ConjunctionPredicate;
import com.siyeh.ipp.psiutils.BoolUtils;
import com.siyeh.ipp.psiutils.ComparisonUtils;
import com.siyeh.ipp.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class DemorgansIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
        PsiJavaToken sign = binaryExpression.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        if (tokenType.equals(JavaTokenType.ANDAND)) {
            return IntentionPowerPackBundle.message("demorgans.intention.name1", new Object[0]);
        }
        return IntentionPowerPackBundle.message("demorgans.intention.name2", new Object[0]);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConjunctionPredicate conjunctionPredicate = new ConjunctionPredicate();
        if (conjunctionPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/bool/DemorgansIntention.getElementPredicate must not return null");
        }
        return conjunctionPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        PsiJavaToken sign = exp.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        PsiElement parent = exp.getParent();
        while (DemorgansIntention.isConjunctionExpression(parent, tokenType)) {
            exp = (PsiBinaryExpression)parent;
            assert (exp != null);
            parent = exp.getParent();
        }
        String newExpression = DemorgansIntention.convertConjunctionExpression(exp, tokenType);
        DemorgansIntention.replaceExpressionWithNegatedExpressionString(newExpression, (PsiExpression)exp);
    }

    private static String convertConjunctionExpression(PsiBinaryExpression exp, IElementType tokenType) {
        PsiExpression lhs = exp.getLOperand();
        String lhsText = DemorgansIntention.isConjunctionExpression((PsiElement)lhs, tokenType) ? DemorgansIntention.convertConjunctionExpression((PsiBinaryExpression)lhs, tokenType) : DemorgansIntention.convertLeafExpression(lhs);
        PsiExpression rhs = exp.getROperand();
        String rhsText = DemorgansIntention.isConjunctionExpression((PsiElement)rhs, tokenType) ? DemorgansIntention.convertConjunctionExpression((PsiBinaryExpression)rhs, tokenType) : DemorgansIntention.convertLeafExpression(rhs);
        String flippedConjunction = tokenType.equals(JavaTokenType.ANDAND) ? "||" : "&&";
        return lhsText + flippedConjunction + rhsText;
    }

    private static String convertLeafExpression(PsiExpression condition) {
        if (BoolUtils.isNegation(condition)) {
            PsiExpression negated = BoolUtils.getNegated(condition);
            if (negated == null) {
                return "";
            }
            if (ParenthesesUtils.getPrecedence(negated) > 14) {
                return '(' + negated.getText() + ')';
            }
            return negated.getText();
        }
        if (ComparisonUtils.isComparison(condition)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiJavaToken sign = binaryExpression.getOperationSign();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            assert (rhs != null);
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (ParenthesesUtils.getPrecedence(condition) > 3) {
            return "!(" + condition.getText() + ')';
        }
        return '!' + condition.getText();
    }

    private static boolean isConjunctionExpression(PsiElement exp, IElementType conjunctionType) {
        if (!(exp instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binExp = (PsiBinaryExpression)exp;
        PsiJavaToken sign = binExp.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        return tokenType.equals(conjunctionType);
    }
}

