/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.ConvertCatchtoThrowsPredicate;
import org.jetbrains.annotations.NotNull;

public class ConvertCatchToThrowsIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConvertCatchtoThrowsPredicate convertCatchtoThrowsPredicate = new ConvertCatchtoThrowsPredicate();
        if (convertCatchtoThrowsPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/exceptions/ConvertCatchToThrowsIntention.getElementPredicate must not return null");
        }
        return convertCatchtoThrowsPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/exceptions/ConvertCatchToThrowsIntention.processIntention must not be null");
        }
        PsiCatchSection catchSection = (PsiCatchSection)element.getParent();
        PsiType catchType = catchSection.getCatchType();
        if (!(catchType instanceof PsiClassType)) {
            return;
        }
        PsiClassType classType = (PsiClassType)catchType;
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)catchSection, PsiMethod.class);
        if (method == null) {
            return;
        }
        PsiReferenceList throwsList = method.getThrowsList();
        PsiManager manager = element.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType(classType);
        throwsList.add((PsiElement)referenceElement);
        PsiTryStatement tryStatement = catchSection.getTryStatement();
        PsiCatchSection[] catchSections = tryStatement.getCatchSections();
        if (catchSections.length > 1) {
            catchSection.delete();
        } else {
            PsiStatement[] statements;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            PsiElement parent = tryStatement.getParent();
            for (PsiStatement statement : statements = tryBlock.getStatements()) {
                parent.addBefore((PsiElement)statement, (PsiElement)tryStatement);
            }
            tryStatement.delete();
        }
    }
}

