/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class IterableForEachLoopPredicate
implements PsiElementPredicate {
    IterableForEachLoopPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        IElementType tokenType = token.getTokenType();
        if (!JavaTokenType.FOR_KEYWORD.equals(tokenType)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiForeachStatement)) {
            return false;
        }
        PsiForeachStatement foreachStatement = (PsiForeachStatement)parent;
        PsiExpression iteratedValue = foreachStatement.getIteratedValue();
        if (iteratedValue == null) {
            return false;
        }
        PsiType type = iteratedValue.getType();
        return type instanceof PsiClassType && !ErrorUtil.containsError(parent);
    }
}

