/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.fqnames;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.fqnames.FullyQualifiedNamePredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import com.siyeh.ipp.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReplaceFullyQualifiedNameWithImportIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        FullyQualifiedNamePredicate fullyQualifiedNamePredicate = new FullyQualifiedNamePredicate();
        if (fullyQualifiedNamePredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/fqnames/ReplaceFullyQualifiedNameWithImportIntention.getElementPredicate must not return null");
        }
        return fullyQualifiedNamePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/fqnames/ReplaceFullyQualifiedNameWithImportIntention.processIntention must not be null");
        }
        PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)element;
        PsiElement target = reference.resolve();
        if (!(target instanceof PsiClass)) {
            while (reference.getParent() instanceof PsiJavaCodeReferenceElement && !((target = (reference = (PsiJavaCodeReferenceElement)reference.getParent()).resolve()) instanceof PsiClass)) {
            }
        }
        if (!(target instanceof PsiClass)) {
            return;
        }
        PsiClass aClass = (PsiClass)target;
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        PsiJavaFile file = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiJavaFile.class);
        if (file == null) {
            return;
        }
        if (!ImportUtils.nameCanBeImported(qualifiedName, (PsiElement)file)) {
            return;
        }
        PsiImportList importList = file.getImportList();
        if (importList == null) {
            return;
        }
        String packageName = ClassUtil.extractPackageName((String)qualifiedName);
        String filePackageName = file.getPackageName();
        if (packageName.equals("java.lang") || packageName.equals(filePackageName)) {
            if (ImportUtils.hasOnDemandImportConflict(qualifiedName, file)) {
                ReplaceFullyQualifiedNameWithImportIntention.addImport(importList, aClass);
            }
        } else if (importList.findSingleClassImportStatement(qualifiedName) == null && importList.findOnDemandImportStatement(packageName) == null) {
            ReplaceFullyQualifiedNameWithImportIntention.addImport(importList, aClass);
        }
        String fullyQualifiedText = reference.getText();
        QualificationRemover qualificationRemover = new QualificationRemover(fullyQualifiedText);
        file.accept((PsiElementVisitor)qualificationRemover);
        Collection<PsiJavaCodeReferenceElement> shortenedElements = qualificationRemover.getShortenedElements();
        HighlightUtil.highlightElements(shortenedElements);
        ReplaceFullyQualifiedNameWithImportIntention.showStatusMessage(file.getProject(), shortenedElements.size());
    }

    private static void showStatusMessage(Project project, int elementCount) {
        WindowManager windowManager = WindowManager.getInstance();
        StatusBar statusBar = windowManager.getStatusBar(project);
        if (elementCount == 1) {
            statusBar.setInfo(IntentionPowerPackBundle.message("1.fully.qualified.name.status.bar.escape.highlighting.message", new Object[0]));
        } else {
            statusBar.setInfo(IntentionPowerPackBundle.message("multiple.fully.qualified.names.status.bar.escape.highlighting.message", elementCount - 1));
        }
    }

    private static void addImport(PsiImportList importList, PsiClass aClass) throws IncorrectOperationException {
        PsiManager manager = importList.getManager();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiImportStatement importStatement = elementFactory.createImportStatement(aClass);
        importList.add((PsiElement)importStatement);
    }

    private static class QualificationRemover
    extends JavaRecursiveElementWalkingVisitor {
        private final String fullyQualifiedText;
        private final List<PsiJavaCodeReferenceElement> shortenedElements = new ArrayList<PsiJavaCodeReferenceElement>();

        QualificationRemover(String fullyQualifiedText) {
            this.fullyQualifiedText = fullyQualifiedText;
        }

        public Collection<PsiJavaCodeReferenceElement> getShortenedElements() {
            return Collections.unmodifiableCollection(this.shortenedElements);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            PsiElement parent = reference.getParent();
            if (parent instanceof PsiImportStatement) {
                return;
            }
            String text = reference.getText();
            if (text.equals(this.fullyQualifiedText)) {
                PsiElement qualifier = reference.getQualifier();
                if (qualifier == null) {
                    return;
                }
                try {
                    qualifier.delete();
                }
                catch (IncorrectOperationException e) {
                    Class<?> aClass = ((Object)((Object)this)).getClass();
                    String className = aClass.getName();
                    Logger logger = Logger.getInstance((String)className);
                    logger.error((Throwable)e);
                }
                this.shortenedElements.add(reference);
            }
        }
    }
}

