/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.switchtoif;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ControlFlowUtils;
import com.siyeh.ipp.psiutils.DeclarationUtils;
import com.siyeh.ipp.psiutils.EquivalenceChecker;
import com.siyeh.ipp.switchtoif.CaseUtil;
import com.siyeh.ipp.switchtoif.IfStatementBranch;
import com.siyeh.ipp.switchtoif.IfToSwitchPredicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceIfWithSwitchIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        IfToSwitchPredicate ifToSwitchPredicate = new IfToSwitchPredicate();
        if (ifToSwitchPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/switchtoif/ReplaceIfWithSwitchIntention.getElementPredicate must not return null");
        }
        return ifToSwitchPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiStatement elseBranch;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/switchtoif/ReplaceIfWithSwitchIntention.processIntention must not be null");
        }
        PsiJavaToken switchToken = (PsiJavaToken)element;
        PsiIfStatement ifStatement = (PsiIfStatement)switchToken.getParent();
        assert (ifStatement != null);
        boolean breaksNeedRelabeled = false;
        PsiStatement breakTarget = null;
        String labelString = "";
        if (ControlFlowUtils.statementContainsExitingBreak((PsiStatement)ifStatement)) {
            for (PsiElement ancestor = ifStatement.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                if (!(ancestor instanceof PsiForStatement) && !(ancestor instanceof PsiDoWhileStatement) && !(ancestor instanceof PsiWhileStatement) && !(ancestor instanceof PsiSwitchStatement)) continue;
                breakTarget = (PsiStatement)ancestor;
                break;
            }
            if (breakTarget != null) {
                labelString = CaseUtil.findUniqueLabel((PsiStatement)ifStatement, "Label");
                breaksNeedRelabeled = true;
            }
        }
        PsiIfStatement statementToReplace = ifStatement;
        PsiExpression caseExpression = CaseUtil.getCaseExpression(ifStatement);
        assert (caseExpression != null);
        ArrayList<IfStatementBranch> branches = new ArrayList<IfStatementBranch>(20);
        while (true) {
            HashSet<String> topLevelVariables = new HashSet<String>(5);
            HashSet<String> innerVariables = new HashSet<String>(5);
            PsiExpression condition = ifStatement.getCondition();
            PsiExpression[] labels = ReplaceIfWithSwitchIntention.getValuesFromCondition(condition, caseExpression);
            PsiStatement thenBranch = ifStatement.getThenBranch();
            DeclarationUtils.calculateVariablesDeclared(thenBranch, topLevelVariables, innerVariables, true);
            IfStatementBranch ifBranch = new IfStatementBranch();
            if (!branches.isEmpty()) {
                ReplaceIfWithSwitchIntention.extractIfComments((PsiElement)ifStatement, ifBranch);
            }
            ifBranch.setInnerVariables(innerVariables);
            ifBranch.setTopLevelVariables(topLevelVariables);
            ReplaceIfWithSwitchIntention.extractStatementComments((PsiElement)thenBranch, ifBranch);
            ifBranch.setStatement(thenBranch);
            for (PsiExpression label : labels) {
                if (label instanceof PsiReferenceExpression) {
                    PsiReferenceExpression reference = (PsiReferenceExpression)label;
                    PsiElement referent = reference.resolve();
                    if (referent instanceof PsiEnumConstant) {
                        PsiEnumConstant constant = (PsiEnumConstant)referent;
                        String constantName = constant.getName();
                        ifBranch.addCondition(constantName);
                        continue;
                    }
                    String labelText = label.getText();
                    ifBranch.addCondition(labelText);
                    continue;
                }
                String labelText = label.getText();
                ifBranch.addCondition(labelText);
            }
            branches.add(ifBranch);
            elseBranch = ifStatement.getElseBranch();
            if (!(elseBranch instanceof PsiIfStatement)) break;
            ifStatement = (PsiIfStatement)elseBranch;
        }
        if (elseBranch != null) {
            HashSet<String> elseTopLevelVariables = new HashSet<String>(5);
            HashSet<String> elseInnerVariables = new HashSet<String>(5);
            DeclarationUtils.calculateVariablesDeclared(elseBranch, elseTopLevelVariables, elseInnerVariables, true);
            IfStatementBranch elseIfBranch = new IfStatementBranch();
            PsiKeyword elseKeyword = ifStatement.getElseElement();
            ReplaceIfWithSwitchIntention.extractIfComments((PsiElement)elseKeyword, elseIfBranch);
            ReplaceIfWithSwitchIntention.extractStatementComments((PsiElement)elseBranch, elseIfBranch);
            elseIfBranch.setInnerVariables(elseInnerVariables);
            elseIfBranch.setTopLevelVariables(elseTopLevelVariables);
            elseIfBranch.setElse();
            elseIfBranch.setStatement(elseBranch);
            branches.add(elseIfBranch);
        }
        StringBuilder switchStatementText = new StringBuilder(1024);
        switchStatementText.append("switch(");
        switchStatementText.append(caseExpression.getText());
        switchStatementText.append(')');
        switchStatementText.append('{');
        for (IfStatementBranch branch : branches) {
            boolean hasConflicts = false;
            for (IfStatementBranch testBranch : branches) {
                if (!branch.topLevelDeclarationsConfictWith(testBranch)) continue;
                hasConflicts = true;
            }
            PsiStatement branchStatement = branch.getStatement();
            if (branch.isElse()) {
                List<String> comments = branch.getComments();
                List<String> statementComments = branch.getStatementComments();
                ReplaceIfWithSwitchIntention.dumpDefaultBranch(switchStatementText, comments, branchStatement, statementComments, hasConflicts, breaksNeedRelabeled, labelString);
                continue;
            }
            List<String> conditions = branch.getConditions();
            List<String> comments = branch.getComments();
            List<String> statementComments = branch.getStatementComments();
            ReplaceIfWithSwitchIntention.dumpBranch(switchStatementText, comments, conditions, statementComments, branchStatement, hasConflicts, breaksNeedRelabeled, labelString);
        }
        switchStatementText.append('}');
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        if (breaksNeedRelabeled) {
            StringBuilder out = new StringBuilder();
            out.append(labelString);
            out.append(':');
            ReplaceIfWithSwitchIntention.termReplace(out, (PsiElement)breakTarget, (PsiElement)statementToReplace, switchStatementText);
            String newStatementText = out.toString();
            PsiStatement newStatement = factory.createStatementFromText(newStatementText, element);
            breakTarget.replace((PsiElement)newStatement);
        } else {
            PsiStatement newStatement = factory.createStatementFromText(switchStatementText.toString(), element);
            statementToReplace.replace((PsiElement)newStatement);
        }
    }

    @Nullable
    public static <T extends PsiElement> T getPrevSiblingOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, Class<? extends PsiElement> ... stopAt) {
        PsiElement sibling;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ipp/switchtoif/ReplaceIfWithSwitchIntention.getPrevSiblingOfType must not be null");
        }
        if (stopAt == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ipp/switchtoif/ReplaceIfWithSwitchIntention.getPrevSiblingOfType must not be null");
        }
        if (element == null) {
            return null;
        }
        for (sibling = element.getPrevSibling(); sibling != null && !aClass.isInstance(sibling); sibling = sibling.getPrevSibling()) {
            for (Class<? extends PsiElement> stopClass : stopAt) {
                if (!stopClass.isInstance(sibling)) continue;
                return null;
            }
        }
        return (T)sibling;
    }

    private static void extractIfComments(PsiElement element, IfStatementBranch out) {
        PsiComment comment = ReplaceIfWithSwitchIntention.getPrevSiblingOfType(element, PsiComment.class, PsiStatement.class);
        while (comment != null) {
            String whiteSpaceText;
            PsiElement sibling = comment.getPrevSibling();
            String commentText = sibling instanceof PsiWhiteSpace ? ((whiteSpaceText = sibling.getText()).startsWith("\n") ? whiteSpaceText.substring(1) + comment.getText() : comment.getText()) : comment.getText();
            out.addComment(commentText);
            comment = ReplaceIfWithSwitchIntention.getPrevSiblingOfType((PsiElement)comment, PsiComment.class, PsiStatement.class);
        }
    }

    private static void extractStatementComments(PsiElement element, IfStatementBranch out) {
        PsiComment comment = ReplaceIfWithSwitchIntention.getPrevSiblingOfType(element, PsiComment.class, PsiStatement.class, PsiKeyword.class);
        while (comment != null) {
            String whiteSpaceText;
            PsiElement sibling = comment.getPrevSibling();
            String commentText = sibling instanceof PsiWhiteSpace ? ((whiteSpaceText = sibling.getText()).startsWith("\n") ? whiteSpaceText.substring(1) + comment.getText() : comment.getText()) : comment.getText();
            out.addStatementComment(commentText);
            comment = ReplaceIfWithSwitchIntention.getPrevSiblingOfType((PsiElement)comment, PsiComment.class, PsiStatement.class, PsiKeyword.class);
        }
    }

    private static void termReplace(StringBuilder out, PsiElement target, PsiElement replace, StringBuilder stringToReplaceWith) {
        if (target.equals(replace)) {
            out.append((CharSequence)stringToReplaceWith);
        } else if (target.getChildren().length == 0) {
            String text = target.getText();
            out.append(text);
        } else {
            PsiElement[] children;
            for (PsiElement child : children = target.getChildren()) {
                ReplaceIfWithSwitchIntention.termReplace(out, child, replace, stringToReplaceWith);
            }
        }
    }

    private static PsiExpression[] getValuesFromCondition(PsiExpression condition, PsiExpression caseExpression) {
        ArrayList<PsiExpression> values = new ArrayList<PsiExpression>(10);
        ReplaceIfWithSwitchIntention.getValuesFromExpression(condition, caseExpression, values);
        return values.toArray(new PsiExpression[values.size()]);
    }

    private static void getValuesFromExpression(PsiExpression expression, PsiExpression caseExpression, List<PsiExpression> values) {
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            PsiJavaToken sign = binaryExpression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (JavaTokenType.OROR.equals(tokenType)) {
                ReplaceIfWithSwitchIntention.getValuesFromExpression(lhs, caseExpression, values);
                ReplaceIfWithSwitchIntention.getValuesFromExpression(rhs, caseExpression, values);
            } else if (EquivalenceChecker.expressionsAreEquivalent(caseExpression, rhs)) {
                values.add(lhs);
            } else {
                values.add(rhs);
            }
        } else if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenExpression = (PsiParenthesizedExpression)expression;
            PsiExpression contents = parenExpression.getExpression();
            ReplaceIfWithSwitchIntention.getValuesFromExpression(contents, caseExpression, values);
        }
    }

    private static void dumpBranch(StringBuilder switchStatementString, List<String> comments, List<String> labels, List<String> statementComments, PsiStatement body, boolean wrap, boolean renameBreaks, String breakLabelName) {
        ReplaceIfWithSwitchIntention.dumpComments(switchStatementString, comments);
        ReplaceIfWithSwitchIntention.dumpLabels(switchStatementString, labels);
        ReplaceIfWithSwitchIntention.dumpComments(switchStatementString, statementComments);
        ReplaceIfWithSwitchIntention.dumpBody(switchStatementString, body, wrap, renameBreaks, breakLabelName);
    }

    private static void dumpComments(StringBuilder switchStatementString, List<String> comments) {
        if (!comments.isEmpty()) {
            switchStatementString.append('\n');
            for (String comment : comments) {
                switchStatementString.append(comment);
                switchStatementString.append('\n');
            }
        }
    }

    private static void dumpDefaultBranch(@NonNls StringBuilder switchStatementString, List<String> comments, PsiStatement body, List<String> statementComments, boolean wrap, boolean renameBreaks, String breakLabelName) {
        ReplaceIfWithSwitchIntention.dumpComments(switchStatementString, comments);
        switchStatementString.append("default: ");
        ReplaceIfWithSwitchIntention.dumpComments(switchStatementString, statementComments);
        ReplaceIfWithSwitchIntention.dumpBody(switchStatementString, body, wrap, renameBreaks, breakLabelName);
    }

    private static void dumpLabels(@NonNls StringBuilder switchStatementString, List<String> labels) {
        for (String label : labels) {
            switchStatementString.append("case ");
            switchStatementString.append(label);
            switchStatementString.append(": ");
        }
    }

    private static void dumpBody(@NonNls StringBuilder switchStatementString, PsiStatement bodyStatement, boolean wrap, boolean renameBreaks, String breakLabelName) {
        if (bodyStatement instanceof PsiBlockStatement) {
            if (wrap) {
                ReplaceIfWithSwitchIntention.appendElement(switchStatementString, (PsiElement)bodyStatement, renameBreaks, breakLabelName);
            } else {
                PsiCodeBlock codeBlock = ((PsiBlockStatement)bodyStatement).getCodeBlock();
                PsiElement[] children = codeBlock.getChildren();
                for (int i = 1; i < children.length - 1; ++i) {
                    PsiElement child = children[i];
                    ReplaceIfWithSwitchIntention.appendElement(switchStatementString, child, renameBreaks, breakLabelName);
                }
            }
        } else if (wrap) {
            switchStatementString.append('{');
            ReplaceIfWithSwitchIntention.appendElement(switchStatementString, (PsiElement)bodyStatement, renameBreaks, breakLabelName);
            switchStatementString.append('}');
        } else {
            ReplaceIfWithSwitchIntention.appendElement(switchStatementString, (PsiElement)bodyStatement, renameBreaks, breakLabelName);
        }
        if (ControlFlowUtils.statementMayCompleteNormally(bodyStatement)) {
            switchStatementString.append("break; ");
        }
    }

    private static void appendElement(@NonNls StringBuilder switchStatementString, PsiElement element, boolean renameBreakElements, String breakLabelString) {
        String text = element.getText();
        if (!renameBreakElements) {
            switchStatementString.append(text);
        } else if (element instanceof PsiBreakStatement) {
            PsiIdentifier identifier = ((PsiBreakStatement)element).getLabelIdentifier();
            if (identifier == null) {
                switchStatementString.append("break ");
                switchStatementString.append(breakLabelString);
                switchStatementString.append(';');
            } else {
                String identifierText = identifier.getText();
                if ("".equals(identifierText)) {
                    switchStatementString.append("break ");
                    switchStatementString.append(breakLabelString);
                    switchStatementString.append(';');
                } else {
                    switchStatementString.append(text);
                }
            }
        } else if (element instanceof PsiBlockStatement || element instanceof PsiCodeBlock || element instanceof PsiIfStatement) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                ReplaceIfWithSwitchIntention.appendElement(switchStatementString, child, renameBreakElements, breakLabelString);
            }
        } else {
            switchStatementString.append(text);
        }
    }
}

