/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.componentTree;

import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import org.jetbrains.annotations.NotNull;

public final class ComponentPtr {
    private final GuiEditor myEditor;
    private final String myId;
    private RadComponent myComponent;

    public ComponentPtr(@NotNull GuiEditor editor, @NotNull RadComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/componentTree/ComponentPtr.<init> must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/componentTree/ComponentPtr.<init> must not be null");
        }
        this(editor, component, true);
    }

    public ComponentPtr(@NotNull GuiEditor editor, @NotNull RadComponent component, boolean validate) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/componentTree/ComponentPtr.<init> must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/componentTree/ComponentPtr.<init> must not be null");
        }
        this.myEditor = editor;
        this.myId = component.getId();
        if (validate) {
            this.validate();
            if (!this.isValid()) {
                throw new IllegalArgumentException("invalid component: " + component);
            }
        } else {
            this.myComponent = component;
        }
    }

    public RadComponent getComponent() {
        return this.myComponent;
    }

    public boolean isValid() {
        return this.myComponent != null;
    }

    public void validate() {
        RadRootContainer container = this.myEditor.getRootContainer();
        this.myComponent = (RadComponent)FormEditingUtil.findComponent(container, this.myId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComponentPtr)) {
            return false;
        }
        return this.myId.equals(((ComponentPtr)obj).myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }
}

