/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.palette.PaletteDragEventListener;
import com.intellij.ide.palette.impl.PaletteManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.uiDesigner.CutCopyPasteSupport;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.HierarchyChangeListener;
import com.intellij.uiDesigner.LoaderFactory;
import com.intellij.uiDesigner.SelectionState;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.XmlReader;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.componentTree.ComponentPtr;
import com.intellij.uiDesigner.componentTree.ComponentSelectionListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Util;
import com.intellij.uiDesigner.designSurface.ActiveDecorationLayer;
import com.intellij.uiDesigner.designSurface.DesignDropTargetListener;
import com.intellij.uiDesigner.designSurface.DragLayer;
import com.intellij.uiDesigner.designSurface.GlassLayer;
import com.intellij.uiDesigner.designSurface.GridCaptionPanel;
import com.intellij.uiDesigner.designSurface.InplaceEditingLayer;
import com.intellij.uiDesigner.designSurface.MainProcessor;
import com.intellij.uiDesigner.designSurface.PassiveDecorationLayer;
import com.intellij.uiDesigner.designSurface.QuickFixManagerImpl;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.propertyInspector.PropertyInspector;
import com.intellij.uiDesigner.propertyInspector.UIDesignerToolWindowManager;
import com.intellij.uiDesigner.propertyInspector.properties.IntroStringProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.uiDesigner.radComponents.RadTabbedPane;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GuiEditor
extends JPanel
implements DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.GuiEditor");
    @NotNull
    private final Module myModule;
    @NotNull
    private final VirtualFile myFile;
    private Exception myWhere;
    private static final Integer LAYER_COMPONENT = JLayeredPane.DEFAULT_LAYER;
    private static final Integer LAYER_PASSIVE_DECORATION = JLayeredPane.POPUP_LAYER;
    private static final Integer LAYER_DND = JLayeredPane.DRAG_LAYER;
    private static final Integer LAYER_GLASS = new Integer(JLayeredPane.DRAG_LAYER + 100);
    private static final Integer LAYER_ACTIVE_DECORATION = new Integer(LAYER_GLASS + 100);
    private static final Integer LAYER_INPLACE_EDITING = new Integer(LAYER_ACTIVE_DECORATION + 100);
    private final EventListenerList myListenerList;
    private final Document myDocument;
    final MainProcessor myProcessor;
    @NotNull
    private final MyLayeredPane myLayeredPane;
    private final PassiveDecorationLayer myDecorationLayer;
    private final DragLayer myDragLayer;
    private final InplaceEditingLayer myInplaceEditingLayer;
    private final MyDeleteProvider myDeleteProvider;
    private final MyPsiTreeChangeListener myPsiTreeChangeListener;
    private RadRootContainer myRootContainer;
    private boolean myInsideChange;
    private final DocumentAdapter myDocumentListener;
    private final CardLayout myCardLayout;
    @NonNls
    private static final String CARD_VALID = "valid";
    @NonNls
    private static final String CARD_INVALID = "invalid";
    private final JPanel myValidCard;
    private final JPanel myInvalidCard;
    private boolean myInvalid;
    private final CutCopyPasteSupport myCutCopyPasteSupport;
    private final SelectionState mySelectionState;
    @NotNull
    private final GlassLayer myGlassLayer;
    private final ActiveDecorationLayer myActiveDecorationLayer;
    private boolean myShowGrid;
    private boolean myShowComponentTags;
    private final DesignDropTargetListener myDropTargetListener;
    private JLabel myFormInvalidLabel;
    private final QuickFixManagerImpl myQuickFixManager;
    private final GridCaptionPanel myHorzCaptionPanel;
    private final GridCaptionPanel myVertCaptionPanel;
    private final MyPaletteKeyListener myPaletteKeyListener;
    private final MyPaletteDragListener myPaletteDragListener;
    private final MyPaletteSelectionListener myPaletteSelectionListener;
    private ComponentPtr mySelectionAnchor;
    private ComponentPtr mySelectionLead;
    private Object myNextSaveGroupId;
    @NonNls
    private static final String ourHelpID = "guiDesigner.uiTour.workspace";
    public static final DataKey<GuiEditor> DATA_KEY = DataKey.create((String)GuiEditor.class.getName());

    public GuiEditor(final @NotNull Module module, @NotNull VirtualFile file) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/designSurface/GuiEditor.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/designSurface/GuiEditor.<init> must not be null");
        }
        this.myInvalid = false;
        this.myShowGrid = true;
        this.myShowComponentTags = true;
        this.myNextSaveGroupId = new Object();
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(file.isValid());
        this.myModule = module;
        this.myFile = file;
        this.myCutCopyPasteSupport = new CutCopyPasteSupport(this);
        this.myCardLayout = new CardLayout();
        this.setLayout(this.myCardLayout);
        this.myValidCard = new JPanel(new BorderLayout());
        this.myInvalidCard = this.createInvalidCard();
        this.add((Component)this.myValidCard, CARD_VALID);
        this.add((Component)this.myInvalidCard, CARD_INVALID);
        this.myListenerList = new EventListenerList();
        this.myDecorationLayer = new PassiveDecorationLayer(this);
        this.myDragLayer = new DragLayer(this);
        this.myLayeredPane = new MyLayeredPane();
        this.myInplaceEditingLayer = new InplaceEditingLayer(this);
        this.myLayeredPane.add((Component)this.myInplaceEditingLayer, LAYER_INPLACE_EDITING);
        this.myActiveDecorationLayer = new ActiveDecorationLayer(this);
        this.myLayeredPane.add((Component)this.myActiveDecorationLayer, LAYER_ACTIVE_DECORATION);
        this.myGlassLayer = new GlassLayer(this);
        this.myLayeredPane.add((Component)this.myGlassLayer, LAYER_GLASS);
        this.myLayeredPane.add((Component)this.myDecorationLayer, LAYER_PASSIVE_DECORATION);
        this.myLayeredPane.add((Component)this.myDragLayer, LAYER_DND);
        this.myGlassLayer.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GuiEditor.this.myDecorationLayer.repaint();
                GuiEditor.this.fireSelectedComponentChanged();
            }

            @Override
            public void focusLost(FocusEvent e) {
                GuiEditor.this.myDecorationLayer.repaint();
            }
        });
        this.mySelectionState = new SelectionState(this);
        this.myDeleteProvider = new MyDeleteProvider();
        final Alarm alarm = new Alarm();
        this.myDocumentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (!GuiEditor.this.myInsideChange) {
                    UndoManager undoManager = UndoManager.getInstance((Project)module.getProject());
                    alarm.cancelAllRequests();
                    alarm.addRequest((Runnable)new MySynchronizeRequest(module, undoManager.isUndoInProgress() || undoManager.isRedoInProgress()), 100, ModalityState.stateForComponent((Component)GuiEditor.this));
                }
            }
        };
        this.myDocument = FileDocumentManager.getInstance().getDocument(file);
        this.myDocument.addDocumentListener((DocumentListener)this.myDocumentListener);
        this.readFromFile(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.LIGHT_GRAY);
        this.myHorzCaptionPanel = new GridCaptionPanel(this, false);
        this.myVertCaptionPanel = new GridCaptionPanel(this, true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        panel.add((Component)this.myVertCaptionPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        panel.add((Component)this.myHorzCaptionPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(this.myLayeredPane);
        scrollPane.setBackground(Color.WHITE);
        panel.add((Component)scrollPane, gbc);
        this.myHorzCaptionPanel.attachToScrollPane(scrollPane);
        this.myVertCaptionPanel.attachToScrollPane(scrollPane);
        this.myValidCard.add((Component)panel, "Center");
        CancelCurrentOperationAction cancelCurrentOperationAction = new CancelCurrentOperationAction();
        cancelCurrentOperationAction.registerCustomShortcutSet(CommonShortcuts.ESCAPE, this);
        this.myProcessor = new MainProcessor(this);
        this.myPsiTreeChangeListener = new MyPsiTreeChangeListener();
        PsiManager.getInstance((Project)module.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        this.myQuickFixManager = new QuickFixManagerImpl(this, this.myGlassLayer, scrollPane.getViewport());
        this.myDropTargetListener = new DesignDropTargetListener(this);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            new DropTarget(this.getGlassLayer(), 3, this.myDropTargetListener);
        }
        this.myActiveDecorationLayer.installSelectionWatcher();
        PaletteManager paletteManager = PaletteManager.getInstance((Project)this.getProject());
        this.myPaletteKeyListener = new MyPaletteKeyListener();
        paletteManager.addKeyListener((KeyListener)this.myPaletteKeyListener);
        this.myPaletteDragListener = new MyPaletteDragListener();
        paletteManager.addDragEventListener((PaletteDragEventListener)this.myPaletteDragListener);
        this.myPaletteSelectionListener = new MyPaletteSelectionListener();
        paletteManager.addSelectionListener((ListSelectionListener)this.myPaletteSelectionListener);
        ActionManager.getInstance().getAction("GuiDesigner.IncreaseIndent").registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 0)), (JComponent)this.myGlassLayer);
        ActionManager.getInstance().getAction("GuiDesigner.DecreaseIndent").registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 1)), (JComponent)this.myGlassLayer);
    }

    @NotNull
    public SelectionState getSelectionState() {
        SelectionState selectionState = this.mySelectionState;
        if (selectionState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/designSurface/GuiEditor.getSelectionState must not return null");
        }
        return selectionState;
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myWhere != null) {
            LOG.error("Already disposed: old trace: ", (Throwable)this.myWhere);
            LOG.error("Already disposed: new trace: ");
        } else {
            this.myWhere = new Exception();
        }
        PaletteManager paletteManager = PaletteManager.getInstance((Project)this.getProject());
        paletteManager.removeKeyListener((KeyListener)this.myPaletteKeyListener);
        paletteManager.removeDragEventListener((PaletteDragEventListener)this.myPaletteDragListener);
        paletteManager.removeSelectionListener((ListSelectionListener)this.myPaletteSelectionListener);
        this.myDocument.removeDocumentListener((DocumentListener)this.myDocumentListener);
        PsiManager.getInstance((Project)this.myModule.getProject()).removePsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        this.myPsiTreeChangeListener.dispose();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myModule.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/designSurface/GuiEditor.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/designSurface/GuiEditor.getModule must not return null");
        }
        return module;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/designSurface/GuiEditor.getFile must not return null");
        }
        return virtualFile;
    }

    public PsiFile getPsiFile() {
        return PsiManager.getInstance((Project)this.getProject()).findFile(this.myFile);
    }

    public boolean isEditable() {
        Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
        return document != null && document.isWritable();
    }

    public boolean ensureEditable() {
        PsiClass psiClass;
        String classToBind;
        if (this.isEditable()) {
            return true;
        }
        VirtualFile sourceFileToCheckOut = null;
        if (!GuiDesignerConfiguration.getInstance((Project)this.getProject()).INSTRUMENT_CLASSES && (classToBind = this.myRootContainer.getClassToBind()) != null && classToBind.length() > 0 && (psiClass = FormEditingUtil.findClassToBind(this.myModule, classToBind)) != null) {
            sourceFileToCheckOut = psiClass.getContainingFile().getVirtualFile();
        }
        ReadonlyStatusHandler.OperationStatus status = sourceFileToCheckOut != null ? ReadonlyStatusHandler.getInstance((Project)this.getProject()).ensureFilesWritable(new VirtualFile[]{this.myFile, sourceFileToCheckOut}) : ReadonlyStatusHandler.getInstance((Project)this.getProject()).ensureFilesWritable(new VirtualFile[]{this.myFile});
        return !status.hasReadonlyFiles();
    }

    public void refresh() {
        GuiEditor.refreshImpl(this.myRootContainer);
        this.myRootContainer.getDelegee().revalidate();
        this.repaintLayeredPane();
    }

    public void refreshAndSave(boolean forceSync) {
        UIDesignerToolWindowManager manager = UIDesignerToolWindowManager.getInstance(this.getProject());
        manager.getPropertyInspector().synchWithTree(forceSync);
        this.refresh();
        this.saveToFile();
        this.myHorzCaptionPanel.repaint();
        this.myVertCaptionPanel.repaint();
    }

    public Object getNextSaveGroupId() {
        return this.myNextSaveGroupId;
    }

    private static void refreshImpl(RadComponent component) {
        if (component.getParent() != null) {
            Dimension size = component.getSize();
            int oldWidth = size.width;
            int oldHeight = size.height;
            Util.adjustSize((Component)component.getDelegee(), (GridConstraints)component.getConstraints(), (Dimension)size);
            if (oldWidth != size.width || oldHeight != size.height) {
                if (component.getParent().isXY()) {
                    component.setSize(size);
                }
                component.getDelegee().invalidate();
            }
        }
        if (component instanceof RadContainer) {
            RadContainer container = (RadContainer)component;
            for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                GuiEditor.refreshImpl(container.getComponent(i));
            }
        }
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return ourHelpID;
        }
        UIDesignerToolWindowManager manager = UIDesignerToolWindowManager.getInstance(this.getProject());
        PropertyInspector inspector = manager.getPropertyInspector();
        if (inspector != null && inspector.isEditing()) {
            return null;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myDeleteProvider;
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCutCopyPasteSupport;
        }
        return null;
    }

    private JPanel createInvalidCard() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myFormInvalidLabel = new JLabel(UIDesignerBundle.message("error.form.file.is.invalid", new Object[0]));
        panel.add((Component)this.myFormInvalidLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public DragLayer getDragLayer() {
        return this.myDragLayer;
    }

    @NotNull
    public RadRootContainer getRootContainer() {
        RadRootContainer radRootContainer = this.myRootContainer;
        if (radRootContainer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/designSurface/GuiEditor.getRootContainer must not return null");
        }
        return radRootContainer;
    }

    public void fireSelectedComponentChanged() {
        ComponentSelectionListener[] listeners;
        for (ComponentSelectionListener listener : listeners = (ComponentSelectionListener[])this.myListenerList.getListeners(ComponentSelectionListener.class)) {
            listener.selectedComponentChanged(this);
        }
    }

    private void fireHierarchyChanged() {
        HierarchyChangeListener[] listeners;
        for (HierarchyChangeListener listener : listeners = (HierarchyChangeListener[])this.myListenerList.getListeners(HierarchyChangeListener.class)) {
            listener.hierarchyChanged();
        }
    }

    @NotNull
    public GlassLayer getGlassLayer() {
        GlassLayer glassLayer = this.myGlassLayer;
        if (glassLayer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/designSurface/GuiEditor.getGlassLayer must not return null");
        }
        return glassLayer;
    }

    public InplaceEditingLayer getInplaceEditingLayer() {
        return this.myInplaceEditingLayer;
    }

    @NotNull
    public JLayeredPane getLayeredPane() {
        MyLayeredPane myLayeredPane = this.myLayeredPane;
        if (myLayeredPane == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/designSurface/GuiEditor.getLayeredPane must not return null");
        }
        return myLayeredPane;
    }

    public void repaintLayeredPane() {
        this.myLayeredPane.repaint();
    }

    public void addComponentSelectionListener(ComponentSelectionListener l) {
        this.myListenerList.add(ComponentSelectionListener.class, l);
    }

    public void removeComponentSelectionListener(ComponentSelectionListener l) {
        this.myListenerList.remove(ComponentSelectionListener.class, l);
    }

    public void addHierarchyChangeListener(@NotNull HierarchyChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/designSurface/GuiEditor.addHierarchyChangeListener must not be null");
        }
        this.myListenerList.add(HierarchyChangeListener.class, l);
    }

    public void removeHierarchyChangeListener(@NotNull HierarchyChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/designSurface/GuiEditor.removeHierarchyChangeListener must not be null");
        }
        this.myListenerList.remove(HierarchyChangeListener.class, l);
    }

    private void saveToFile() {
        LOG.debug("GuiEditor.saveToFile(): group ID=" + this.myNextSaveGroupId);
        CommandProcessor.getInstance().executeCommand(this.myModule.getProject(), new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block6: {
                            GuiEditor.this.myInsideChange = true;
                            try {
                                XmlWriter writer = new XmlWriter();
                                GuiEditor.this.getRootContainer().write(writer);
                                String newText = writer.getText();
                                String oldText = GuiEditor.this.myDocument.getText();
                                try {
                                    ReplaceInfo replaceInfo = GuiEditor.findFragmentToChange(oldText, newText);
                                    if (replaceInfo.getStartOffset() == -1) {
                                        break block6;
                                    }
                                    GuiEditor.this.myDocument.replaceString(replaceInfo.getStartOffset(), replaceInfo.getEndOffset(), (CharSequence)replaceInfo.getReplacement());
                                }
                                catch (Exception e) {
                                    LOG.error((Throwable)e);
                                    GuiEditor.this.myDocument.replaceString(0, oldText.length(), (CharSequence)newText);
                                }
                            }
                            finally {
                                GuiEditor.this.myInsideChange = false;
                            }
                        }
                    }
                });
            }
        }, "UI Designer Save", this.myNextSaveGroupId);
        this.myNextSaveGroupId = new Object();
        this.fireHierarchyChanged();
    }

    public ActiveDecorationLayer getActiveDecorationLayer() {
        return this.myActiveDecorationLayer;
    }

    public void setStringDescriptorLocale(Locale locale) {
        this.myRootContainer.setStringDescriptorLocale(locale);
        this.refreshProperties();
        UIDesignerToolWindowManager.getInstance(this.getProject()).updateComponentTree();
        DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
    }

    @Nullable
    public Locale getStringDescriptorLocale() {
        return this.myRootContainer.getStringDescriptorLocale();
    }

    private void refreshProperties() {
        final Ref anythingModified = new Ref();
        FormEditingUtil.iterate(this.myRootContainer, new FormEditingUtil.ComponentVisitor(){

            public boolean visit(IComponent component) {
                RadComponent radComponent = (RadComponent)component;
                boolean componentModified = false;
                for (IProperty prop : component.getModifiedProperties()) {
                    if (!(prop instanceof IntroStringProperty)) continue;
                    IntroStringProperty strProp = (IntroStringProperty)prop;
                    componentModified = strProp.refreshValue(radComponent) || componentModified;
                }
                if (component instanceof RadContainer) {
                    boolean bl = componentModified = ((RadContainer)component).updateBorder() || componentModified;
                }
                if (component.getParentContainer() instanceof RadTabbedPane) {
                    boolean bl = componentModified = ((RadTabbedPane)component.getParentContainer()).refreshChildTitle(radComponent) || componentModified;
                }
                if (componentModified) {
                    anythingModified.set((Object)Boolean.TRUE);
                }
                return true;
            }
        });
        if (!anythingModified.isNull()) {
            this.refresh();
            UIDesignerToolWindowManager twm = UIDesignerToolWindowManager.getInstance(this.getProject());
            twm.getComponentTree().repaint();
            twm.getPropertyInspector().synchWithTree(true);
        }
    }

    public MainProcessor getMainProcessor() {
        return this.myProcessor;
    }

    public void refreshIntentionHint() {
        this.myQuickFixManager.refreshIntentionHint();
    }

    public void setSelectionAnchor(RadComponent component) {
        this.mySelectionAnchor = new ComponentPtr(this, component);
    }

    @Nullable
    public RadComponent getSelectionAnchor() {
        if (this.mySelectionAnchor == null) {
            return null;
        }
        this.mySelectionAnchor.validate();
        return this.mySelectionAnchor.getComponent();
    }

    public void setSelectionLead(RadComponent component) {
        this.mySelectionLead = new ComponentPtr(this, component);
    }

    @Nullable
    public RadComponent getSelectionLead() {
        if (this.mySelectionLead == null) {
            return null;
        }
        this.mySelectionLead.validate();
        return this.mySelectionLead.getComponent();
    }

    public void scrollComponentInView(RadComponent component) {
        Rectangle rect = SwingUtilities.convertRectangle(component.getDelegee().getParent(), component.getBounds(), this.myLayeredPane);
        this.myLayeredPane.scrollRectToVisible(rect);
    }

    public static ReplaceInfo findFragmentToChange(String oldText, String newText) {
        char c2;
        char c1;
        int idxInNew;
        int endOffset;
        int startOffset;
        if (oldText.equals(newText)) {
            return new ReplaceInfo(-1, -1, null);
        }
        int oldLength = oldText.length();
        int newLength = newText.length();
        for (startOffset = 0; startOffset < oldLength && startOffset < newLength && oldText.charAt(startOffset) == newText.charAt(startOffset); ++startOffset) {
        }
        for (endOffset = oldLength; endOffset > startOffset && (idxInNew = newLength - (oldLength - endOffset) - 1) >= startOffset && (c1 = oldText.charAt(endOffset - 1)) == (c2 = newText.charAt(idxInNew)); --endOffset) {
        }
        return new ReplaceInfo(startOffset, endOffset, newText.substring(startOffset, newLength - (oldLength - endOffset)));
    }

    private void setRootContainer(@NotNull RadRootContainer rootContainer) {
        if (rootContainer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/designSurface/GuiEditor.setRootContainer must not be null");
        }
        if (this.myRootContainer != null) {
            this.myLayeredPane.remove(this.myRootContainer.getDelegee());
        }
        this.myRootContainer = rootContainer;
        this.setDesignTimeInsets(2);
        this.myLayeredPane.add((Component)this.myRootContainer.getDelegee(), LAYER_COMPONENT);
        this.fireHierarchyChanged();
    }

    public void setDesignTimeInsets(int insets) {
        Integer oldInsets = (Integer)this.myRootContainer.getDelegee().getClientProperty(GridLayoutManager.DESIGN_TIME_INSETS);
        if (oldInsets == null || oldInsets != insets) {
            this.myRootContainer.getDelegee().putClientProperty(GridLayoutManager.DESIGN_TIME_INSETS, insets);
            GuiEditor.revalidateRecursive(this.myRootContainer.getDelegee());
        }
    }

    private static void revalidateRecursive(JComponent component) {
        for (Component child : component.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            GuiEditor.revalidateRecursive((JComponent)child);
        }
        component.revalidate();
        component.repaint();
    }

    public void readFromFile(boolean keepSelection) {
        try {
            ComponentPtr[] selection = null;
            Map<String, String> tabbedPaneSelectedTabs = null;
            if (keepSelection) {
                selection = SelectionState.getSelection(this);
                tabbedPaneSelectedTabs = this.saveTabbedPaneSelectedTabs();
            }
            Locale oldLocale = null;
            if (this.myRootContainer != null) {
                oldLocale = this.myRootContainer.getStringDescriptorLocale();
            }
            String text = this.myDocument.getText();
            ClassLoader classLoader = LoaderFactory.getInstance(this.myModule.getProject()).getLoader(this.myFile);
            LwRootContainer rootContainer = Utils.getRootContainer((String)text, (PropertiesProvider)new CompiledClassPropertiesProvider(classLoader));
            RadRootContainer container = XmlReader.createRoot(this.myModule, rootContainer, classLoader, oldLocale);
            this.setRootContainer(container);
            if (keepSelection) {
                SelectionState.restoreSelection(this, selection);
                this.restoreTabbedPaneSelectedTabs(tabbedPaneSelectedTabs);
            }
            this.myInvalid = false;
            this.myCardLayout.show(this, CARD_VALID);
            this.refresh();
        }
        catch (Exception exc) {
            this.showInvalidCard(exc);
        }
        catch (LinkageError exc) {
            this.showInvalidCard(exc);
        }
    }

    private void showInvalidCard(Throwable exc) {
        LOG.info(exc);
        this.setRootContainer(new RadRootContainer(this.myModule, "0"));
        this.myFormInvalidLabel.setText(UIDesignerBundle.message("error.form.file.is.invalid.message", exc.getMessage()));
        this.myInvalid = true;
        this.myCardLayout.show(this, CARD_INVALID);
        this.repaint();
    }

    public boolean isFormInvalid() {
        return this.myInvalid;
    }

    private Map<String, String> saveTabbedPaneSelectedTabs() {
        final HashMap<String, String> result = new HashMap<String, String>();
        FormEditingUtil.iterate(this.getRootContainer(), new FormEditingUtil.ComponentVisitor(){

            public boolean visit(IComponent component) {
                RadTabbedPane tabbedPane;
                RadComponent c;
                if (component instanceof RadTabbedPane && (c = (tabbedPane = (RadTabbedPane)component).getSelectedTab()) != null) {
                    result.put(tabbedPane.getId(), c.getId());
                }
                return true;
            }
        });
        return result;
    }

    private void restoreTabbedPaneSelectedTabs(final Map<String, String> tabbedPaneSelectedTabs) {
        FormEditingUtil.iterate(this.getRootContainer(), new FormEditingUtil.ComponentVisitor(){

            public boolean visit(IComponent component) {
                RadTabbedPane tabbedPane;
                String selectedTabId;
                if (component instanceof RadTabbedPane && (selectedTabId = (String)tabbedPaneSelectedTabs.get((tabbedPane = (RadTabbedPane)component).getId())) != null) {
                    for (RadComponent c : tabbedPane.getComponents()) {
                        if (!c.getId().equals(selectedTabId)) continue;
                        tabbedPane.selectTab(c);
                        break;
                    }
                }
                return true;
            }
        });
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myValidCard.isVisible()) {
            return this.myGlassLayer;
        }
        return this.myInvalidCard;
    }

    public static void repaintLayeredPane(RadComponent component) {
        GuiEditor uiEditor = (GuiEditor)SwingUtilities.getAncestorOfClass(GuiEditor.class, component.getDelegee());
        if (uiEditor != null) {
            uiEditor.repaintLayeredPane();
        }
    }

    public boolean isShowGrid() {
        return this.myShowGrid;
    }

    public void setShowGrid(boolean showGrid) {
        if (this.myShowGrid != showGrid) {
            this.myShowGrid = showGrid;
            this.repaint();
        }
    }

    public boolean isShowComponentTags() {
        return this.myShowComponentTags;
    }

    public void setShowComponentTags(boolean showComponentTags) {
        if (this.myShowComponentTags != showComponentTags) {
            this.myShowComponentTags = showComponentTags;
            this.repaint();
        }
    }

    public DesignDropTargetListener getDropTargetListener() {
        return this.myDropTargetListener;
    }

    @Nullable
    public GridCaptionPanel getFocusedCaptionPanel() {
        if (this.myHorzCaptionPanel.isFocusOwner()) {
            return this.myHorzCaptionPanel;
        }
        if (this.myVertCaptionPanel.isFocusOwner()) {
            return this.myVertCaptionPanel;
        }
        return null;
    }

    private boolean isActiveEditor() {
        return UIDesignerToolWindowManager.getInstance(this.getProject()).getActiveFormEditor() == this;
    }

    void hideIntentionHint() {
        this.myQuickFixManager.hideIntentionHint();
    }

    private class MyPaletteSelectionListener
    implements ListSelectionListener {
        private MyPaletteSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PaletteManager.getInstance((Project)GuiEditor.this.getProject()).getActiveItem() == null) {
                GuiEditor.this.myProcessor.cancelPaletteInsert();
            }
        }
    }

    private class MyPaletteDragListener
    implements PaletteDragEventListener {
        private MyPaletteDragListener() {
        }

        public void dropActionChanged(int gestureModifiers) {
            if ((gestureModifiers & 1) != 0 && GuiEditor.this.isActiveEditor()) {
                GuiEditor.this.setDesignTimeInsets(12);
            } else {
                GuiEditor.this.setDesignTimeInsets(2);
            }
        }
    }

    private class MyPaletteKeyListener
    extends KeyAdapter {
        private MyPaletteKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            PaletteManager paletteManager = PaletteManager.getInstance((Project)GuiEditor.this.getProject());
            if (e.getKeyCode() == 16 && paletteManager.getActiveItem(ComponentItem.class) != null && GuiEditor.this.isActiveEditor()) {
                GuiEditor.this.setDesignTimeInsets(12);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 16) {
                GuiEditor.this.setDesignTimeInsets(2);
            }
        }
    }

    private class MyRefreshPropertiesRequest
    implements Runnable {
        private MyRefreshPropertiesRequest() {
        }

        @Override
        public void run() {
            if (!GuiEditor.this.myModule.isDisposed() && !GuiEditor.this.getProject().isDisposed()) {
                GuiEditor.this.refreshProperties();
            }
        }
    }

    private class MySynchronizeRequest
    implements Runnable {
        private final Module myModule;
        private final boolean myKeepSelection;

        public MySynchronizeRequest(Module module, boolean keepSelection) {
            this.myModule = module;
            this.myKeepSelection = keepSelection;
        }

        @Override
        public void run() {
            LOG.debug("Synchronizing GUI editor " + GuiEditor.this.myFile.getName() + " to document");
            PsiDocumentManager.getInstance((Project)this.myModule.getProject()).commitDocument(GuiEditor.this.myDocument);
            GuiEditor.this.readFromFile(this.myKeepSelection);
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private final Alarm myAlarm;
        private final MyRefreshPropertiesRequest myRefreshPropertiesRequest;
        private final MySynchronizeRequest mySynchronizeRequest;

        public MyPsiTreeChangeListener() {
            this.myRefreshPropertiesRequest = new MyRefreshPropertiesRequest();
            this.mySynchronizeRequest = new MySynchronizeRequest(GuiEditor.this.myModule, true);
            this.myAlarm = new Alarm();
        }

        public void dispose() {
            this.myAlarm.cancelAllRequests();
        }

        public void childAdded(PsiTreeChangeEvent event) {
            this.handleEvent(event);
        }

        public void childMoved(PsiTreeChangeEvent event) {
            this.handleEvent(event);
        }

        public void childrenChanged(PsiTreeChangeEvent event) {
            this.handleEvent(event);
        }

        public void childRemoved(PsiTreeChangeEvent event) {
            this.handleEvent(event);
        }

        public void childReplaced(PsiTreeChangeEvent event) {
            this.handleEvent(event);
        }

        public void propertyChanged(PsiTreeChangeEvent event) {
            if ("roots".equals(event.getPropertyName())) {
                this.myAlarm.cancelRequest((Runnable)this.myRefreshPropertiesRequest);
                this.myAlarm.addRequest((Runnable)this.myRefreshPropertiesRequest, 500, ModalityState.stateForComponent((Component)GuiEditor.this));
            }
        }

        private void handleEvent(PsiTreeChangeEvent event) {
            if (event.getParent() != null) {
                PsiFile containingFile = event.getParent().getContainingFile();
                if (containingFile instanceof PropertiesFile) {
                    LOG.debug("Received PSI change event for properties file");
                    this.myAlarm.cancelRequest((Runnable)this.myRefreshPropertiesRequest);
                    this.myAlarm.addRequest((Runnable)this.myRefreshPropertiesRequest, 500, ModalityState.stateForComponent((Component)GuiEditor.this));
                } else if (containingFile instanceof PsiPlainTextFile && containingFile.getFileType().equals(StdFileTypes.GUI_DESIGNER_FORM)) {
                    String resourceName = FormEditingUtil.buildResourceName(containingFile);
                    if (GuiEditor.this.myDocument.getText().indexOf(resourceName) >= 0) {
                        LOG.debug("Received PSI change event for nested form");
                        this.myAlarm.cancelRequest((Runnable)this.mySynchronizeRequest);
                        this.myAlarm.addRequest((Runnable)this.mySynchronizeRequest, 500, ModalityState.stateForComponent((Component)GuiEditor.this));
                    }
                }
            }
        }
    }

    private final class MyDeleteProvider
    implements DeleteProvider {
        private MyDeleteProvider() {
        }

        public void deleteElement(DataContext dataContext) {
            if (!GuiEditor.this.ensureEditable()) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(GuiEditor.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    FormEditingUtil.deleteSelection(GuiEditor.this);
                }
            }, UIDesignerBundle.message("command.delete.selection", new Object[0]), null);
        }

        public boolean canDeleteElement(DataContext dataContext) {
            UIDesignerToolWindowManager manager = UIDesignerToolWindowManager.getInstance(GuiEditor.this.getProject());
            return !manager.getPropertyInspector().isEditing() && !GuiEditor.this.myInplaceEditingLayer.isEditing() && FormEditingUtil.canDeleteSelection(GuiEditor.this);
        }
    }

    private final class CancelCurrentOperationAction
    extends AnAction {
        private CancelCurrentOperationAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            GuiEditor.this.myProcessor.cancelOperation();
            GuiEditor.this.myQuickFixManager.hideIntentionHint();
        }

        public void update(AnActionEvent e) {
            UIDesignerToolWindowManager manager = UIDesignerToolWindowManager.getInstance(GuiEditor.this.getProject());
            e.getPresentation().setEnabled(!manager.getPropertyInspector().isEditing());
        }
    }

    private final class MyLayeredPane
    extends JLayeredPane
    implements Scrollable {
        private MyLayeredPane() {
        }

        @Override
        public void doLayout() {
            for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                Component component = this.getComponent(i);
                component.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            int width = 0;
            int height = 0;
            for (int i = 0; i < GuiEditor.this.myRootContainer.getComponentCount(); ++i) {
                RadComponent component = GuiEditor.this.myRootContainer.getComponent(i);
                width = Math.max(width, component.getX() + component.getWidth());
                height = Math.max(height, component.getY() + component.getHeight());
            }
            return new Dimension(width += 50, height += 40);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 0) {
                return visibleRect.width - 10;
            }
            return visibleRect.height - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    public static final class ReplaceInfo {
        private final int myStartOffset;
        private final int myEndOffset;
        private final String myReplacement;

        public ReplaceInfo(int startOffset, int endOffset, String replacement) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myReplacement = replacement;
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }

        public int getEndOffset() {
            return this.myEndOffset;
        }

        public String getReplacement() {
            return this.myReplacement;
        }
    }
}

