/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.shared.XYLayoutManager;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JComponent;

public final class XYLayoutManagerImpl
extends XYLayoutManager {
    private final Dimension myPreferredSize = new Dimension();
    private static final Dimension MIN_SIZE = new Dimension(20, 20);

    public void setPreferredSize(Dimension size) {
        this.myPreferredSize.setSize(size);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.myPreferredSize;
    }

    public void layoutContainer(Container parent) {
    }

    public Dimension minimumLayoutSize(Container container) {
        Container parent = container.getParent();
        if (!(parent instanceof JComponent)) {
            return MIN_SIZE;
        }
        RadComponent component = (RadComponent)((JComponent)parent).getClientProperty("radComponent");
        if (component == null) {
            return MIN_SIZE;
        }
        RadContainer radParent = component.getParent();
        if (radParent instanceof RadContainer && radParent.getLayoutManager().isGrid()) {
            return new Dimension(Math.max(this.myPreferredSize.width, XYLayoutManagerImpl.MIN_SIZE.width), Math.max(this.myPreferredSize.height, XYLayoutManagerImpl.MIN_SIZE.height));
        }
        return MIN_SIZE;
    }
}

