/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ClassAccessVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeatureEnvyInspection
extends BaseInspection {
    public boolean ignoreTestCases = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("feature.envy.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/FeatureEnvyInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiNamedElement element = (PsiNamedElement)infos[0];
        String className = element.getName();
        String string = InspectionGadgetsBundle.message("feature.envy.problem.descriptor", className);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/FeatureEnvyInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("feature.envy.ignore.test.cases.option", new Object[0]), (InspectionProfileEntry)this, "ignoreTestCases");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FeatureEnvyVisitor();
    }

    private class FeatureEnvyVisitor
    extends BaseInspectionVisitor {
        private FeatureEnvyVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/FeatureEnvyInspection$FeatureEnvyVisitor.visitMethod must not be null");
            }
            if (FeatureEnvyInspection.this.ignoreTestCases && TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            ClassAccessVisitor visitor = new ClassAccessVisitor(containingClass);
            method.accept((PsiElementVisitor)visitor);
            Set<PsiClass> overaccessedClasses = visitor.getOveraccessedClasses();
            for (PsiClass aClass : overaccessedClasses) {
                this.registerError((PsiElement)nameIdentifier, aClass);
            }
        }
    }
}

