/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnNullInspection
extends BaseInspection {
    public boolean m_reportObjectMethods = true;
    public boolean m_reportArrayMethods = true;
    public boolean m_reportCollectionMethods = true;

    @NotNull
    public String getID() {
        if ("ReturnOfNull" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ReturnNullInspection.getID must not return null");
        }
        return "ReturnOfNull";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("return.of.null.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ReturnNullInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("return.of.null.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ReturnNullInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)((PsiElement)infos[0]))) {
            return null;
        }
        return new DelegatingFix((LocalQuickFix)new AnnotateMethodFix("org.jetbrains.annotations.Nullable", new String[]{"org.jetbrains.annotations.NotNull"}));
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("return.of.null.arrays.option", new Object[0]), "m_reportArrayMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("return.of.null.collections.option", new Object[0]), "m_reportCollectionMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("return.of.null.objects.option", new Object[0]), "m_reportObjectMethods");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnNullVisitor();
    }

    private class ReturnNullVisitor
    extends BaseInspectionVisitor {
        private ReturnNullVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression value) {
            boolean isArray;
            if (value == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/ReturnNullInspection$ReturnNullVisitor.visitLiteralExpression must not be null");
            }
            super.visitLiteralExpression(value);
            String text = value.getText();
            if (!"null".equals(text)) {
                return;
            }
            PsiElement parent = value.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression || parent instanceof PsiTypeCastExpression) {
                parent = parent.getParent();
            }
            if (parent == null || !(parent instanceof PsiReturnStatement)) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)value, PsiMethod.class);
            if (method == null) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            boolean bl = isArray = returnType.getArrayDimensions() > 0;
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.jetbrains.annotations.Nullable", (boolean)false)) {
                return;
            }
            if (ReturnNullInspection.this.m_reportCollectionMethods && CollectionUtils.isCollectionClassOrInterface(returnType)) {
                this.registerError((PsiElement)value, value);
            } else if (ReturnNullInspection.this.m_reportArrayMethods && isArray) {
                this.registerError((PsiElement)value, value);
            } else if (ReturnNullInspection.this.m_reportObjectMethods && !isArray) {
                this.registerError((PsiElement)value, value);
            }
        }
    }
}

