/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class DefaultNotLastCaseInSwitchInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("default.not.last.case.in.switch.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/DefaultNotLastCaseInSwitchInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("default.not.last.case.in.switch.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/DefaultNotLastCaseInSwitchInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DefaultNotLastCaseInSwitchVisitor();
    }

    private static class DefaultNotLastCaseInSwitchVisitor
    extends BaseInspectionVisitor {
        private DefaultNotLastCaseInSwitchVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/DefaultNotLastCaseInSwitchInspection$DefaultNotLastCaseInSwitchVisitor.visitSwitchStatement must not be null");
            }
            super.visitSwitchStatement(statement);
            PsiCodeBlock body = statement.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            boolean labelSeen = false;
            for (int i = statements.length - 1; i >= 0; --i) {
                PsiStatement child = statements[i];
                if (!(child instanceof PsiSwitchLabelStatement)) continue;
                PsiSwitchLabelStatement label = (PsiSwitchLabelStatement)child;
                if (label.isDefaultCase()) {
                    if (labelSeen) {
                        this.registerStatementError((PsiStatement)label, new Object[0]);
                    }
                    return;
                }
                labelSeen = true;
            }
        }
    }
}

