/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateConditionInspection
extends BaseInspection {
    public boolean ignoreMethodCalls = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("duplicate.condition.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/DuplicateConditionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("duplicate.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/DuplicateConditionInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("duplicate.condition.ignore.method.calls.option", new Object[0]), (InspectionProfileEntry)this, "ignoreMethodCalls");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DuplicateConditionVisitor();
    }

    private class DuplicateConditionVisitor
    extends BaseInspectionVisitor {
        private DuplicateConditionVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            PsiIfStatement parentStatement;
            PsiStatement elseBranch;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/DuplicateConditionInspection$DuplicateConditionVisitor.visitIfStatement must not be null");
            }
            super.visitIfStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement && statement.equals(elseBranch = (parentStatement = (PsiIfStatement)parent).getElseBranch())) {
                return;
            }
            HashSet<PsiExpression> conditions = new HashSet<PsiExpression>();
            this.collectConditionsForIfStatement(statement, conditions);
            int numConditions = conditions.size();
            if (numConditions < 2) {
                return;
            }
            PsiExpression[] conditionArray = conditions.toArray(new PsiExpression[numConditions]);
            boolean[] matched = new boolean[conditionArray.length];
            Arrays.fill(matched, false);
            block0: for (int i = 0; i < conditionArray.length; ++i) {
                if (matched[i]) continue;
                PsiExpression condition = conditionArray[i];
                for (int j = i + 1; j < conditionArray.length; ++j) {
                    PsiExpression testCondition;
                    boolean areEquivalent;
                    if (matched[j] || !(areEquivalent = EquivalenceChecker.expressionsAreEquivalent(condition, testCondition = conditionArray[j]))) continue;
                    matched[i] = true;
                    matched[j] = true;
                    if (DuplicateConditionInspection.this.ignoreMethodCalls && this.containsMethodCallExpression((PsiElement)testCondition)) continue block0;
                    this.registerError((PsiElement)testCondition, new Object[0]);
                    if (matched[i]) continue;
                    this.registerError((PsiElement)condition, new Object[0]);
                }
            }
        }

        private void collectConditionsForIfStatement(PsiIfStatement statement, Set<PsiExpression> conditions) {
            PsiExpression condition = statement.getCondition();
            this.collectConditionsForExpression(condition, conditions);
            PsiStatement branch = statement.getElseBranch();
            if (branch instanceof PsiIfStatement) {
                this.collectConditionsForIfStatement((PsiIfStatement)branch, conditions);
            }
        }

        private void collectConditionsForExpression(PsiExpression condition, Set<PsiExpression> conditions) {
            PsiBinaryExpression binaryExpression;
            PsiJavaToken sign;
            IElementType tokenType;
            if (condition == null) {
                return;
            }
            if (condition instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
                PsiExpression contents = parenthesizedExpression.getExpression();
                this.collectConditionsForExpression(contents, conditions);
                return;
            }
            if (condition instanceof PsiBinaryExpression && JavaTokenType.OROR.equals(tokenType = (sign = (binaryExpression = (PsiBinaryExpression)condition).getOperationSign()).getTokenType())) {
                PsiExpression lhs = binaryExpression.getLOperand();
                this.collectConditionsForExpression(lhs, conditions);
                PsiExpression rhs = binaryExpression.getROperand();
                this.collectConditionsForExpression(rhs, conditions);
                return;
            }
            conditions.add(condition);
        }

        private boolean containsMethodCallExpression(PsiElement element) {
            PsiElement[] children;
            if (element instanceof PsiMethodCallExpression) {
                return true;
            }
            for (PsiElement child : children = element.getChildren()) {
                if (!this.containsMethodCallExpression(child)) continue;
                return true;
            }
            return false;
        }
    }
}

