/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.dataflow.ScopeUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooBroadScopeInspection
extends BaseInspection {
    public boolean m_allowConstructorAsInitializer = false;
    public boolean m_onlyLookAtBlocks = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.broad.scope.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/TooBroadScopeInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("TooBroadScope" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/TooBroadScopeInspection.getID must not return null");
        }
        return "TooBroadScope";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel checkboxOptionsPanel = new MultipleCheckboxOptionsPanel(this);
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("too.broad.scope.only.blocks.option", new Object[0]), "m_onlyLookAtBlocks");
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("too.broad.scope.allow.option", new Object[0]), "m_allowConstructorAsInitializer");
        return checkboxOptionsPanel;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("too.broad.scope.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/TooBroadScopeInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiVariable variable = (PsiVariable)infos[0];
        return new TooBroadScopeInspectionFix(variable.getName());
    }

    private boolean isMoveable(PsiExpression expression) {
        if (expression == null) {
            return true;
        }
        if (PsiUtil.isConstantExpression((PsiExpression)expression) || ExpressionUtils.isNullLiteral(expression)) {
            return true;
        }
        if (expression instanceof PsiNewExpression) {
            PsiExpression[] expressions;
            PsiExpressionList argumentList;
            PsiType type;
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            PsiExpression[] arrayDimensions = newExpression.getArrayDimensions();
            if (arrayDimensions.length > 0) {
                for (PsiExpression arrayDimension : arrayDimensions) {
                    if (this.isMoveable(arrayDimension)) continue;
                    return false;
                }
                return true;
            }
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            boolean result = true;
            if (arrayInitializer != null) {
                PsiExpression[] initializers;
                for (PsiExpression initializerExpression : initializers = arrayInitializer.getInitializers()) {
                    result &= this.isMoveable(initializerExpression);
                }
            } else if (!this.m_allowConstructorAsInitializer && !ClassUtils.isImmutable(type = newExpression.getType())) {
                return false;
            }
            if ((argumentList = newExpression.getArgumentList()) == null) {
                return result;
            }
            for (PsiExpression argumentExpression : expressions = argumentList.getExpressions()) {
                result &= this.isMoveable(argumentExpression);
            }
            return result;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)target;
            if (ExpressionUtils.isConstant(field)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TooBroadScopeVisitor();
    }

    private class TooBroadScopeVisitor
    extends BaseInspectionVisitor {
        private TooBroadScopeVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeVisitor.visitVariable must not be null");
            }
            super.visitVariable(variable);
            if (!(variable instanceof PsiLocalVariable)) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (!TooBroadScopeInspection.this.isMoveable(initializer)) {
                return;
            }
            PsiElement variableScope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class});
            if (variableScope == null) {
                return;
            }
            Query query = ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope());
            Collection referencesCollection = query.findAll();
            int size = referencesCollection.size();
            if (size == 0) {
                return;
            }
            PsiElement[] referenceElements = new PsiElement[referencesCollection.size()];
            int index = 0;
            for (PsiReference reference : referencesCollection) {
                PsiElement referenceElement;
                referenceElements[index] = referenceElement = reference.getElement();
                ++index;
            }
            PsiElement commonParent = ScopeUtils.getCommonParent(referenceElements);
            if (commonParent == null) {
                return;
            }
            if (initializer != null && (commonParent = ScopeUtils.moveOutOfLoops(commonParent, variableScope)) == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)commonParent, (PsiElement)variableScope, (boolean)true)) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)variableScope, (PsiElement)commonParent, (boolean)true)) {
                this.registerVariableError(variable, variable);
                return;
            }
            if (TooBroadScopeInspection.this.m_onlyLookAtBlocks) {
                return;
            }
            if (commonParent instanceof PsiForStatement) {
                return;
            }
            PsiElement referenceElement = referenceElements[0];
            PsiElement blockChild = ScopeUtils.getChildWhichContainsElement(variableScope, referenceElement);
            if (blockChild == null) {
                return;
            }
            PsiElement insertionPoint = ScopeUtils.findTighterDeclarationLocation(blockChild, variable);
            if (insertionPoint == null) {
                if (!(blockChild instanceof PsiExpressionStatement)) {
                    return;
                }
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)blockChild;
                PsiExpression expression = expressionStatement.getExpression();
                if (!(expression instanceof PsiAssignmentExpression)) {
                    return;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                IElementType tokenType = assignmentExpression.getOperationTokenType();
                if (tokenType != JavaTokenType.EQ) {
                    return;
                }
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!lhs.equals(referenceElement)) {
                    return;
                }
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (rhs != null && VariableAccessUtils.variableIsUsed(variable, (PsiElement)rhs)) {
                    return;
                }
            }
            if (insertionPoint != null && JspPsiUtil.isInJspFile((PsiElement)insertionPoint)) {
                PsiElement variableParent;
                PsiElement elementBefore = insertionPoint.getPrevSibling();
                if ((elementBefore = PsiTreeUtil.skipSiblingsBackward((PsiElement)elementBefore, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiDeclarationStatement && elementBefore.equals(variableParent = variable.getParent())) {
                    return;
                }
            }
            this.registerVariableError(variable, variable);
        }
    }

    private class TooBroadScopeInspectionFix
    extends InspectionGadgetsFix {
        private final String variableName;

        TooBroadScopeInspectionFix(String variableName) {
            this.variableName = variableName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("too.broad.scope.narrow.quickfix", this.variableName);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeInspectionFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiDeclarationStatement newDeclaration;
            PsiElement firstReferenceScope;
            PsiElement referenceElement;
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeInspectionFix.doFix must not be null");
            }
            PsiElement variableIdentifier = descriptor.getPsiElement();
            PsiVariable variable = (PsiVariable)variableIdentifier.getParent();
            assert (variable != null);
            Query query = ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope());
            Collection referenceCollection = query.findAll();
            PsiElement[] referenceElements = new PsiElement[referenceCollection.size()];
            int index = 0;
            for (PsiReference reference : referenceCollection) {
                referenceElements[index] = referenceElement = reference.getElement();
                ++index;
            }
            PsiElement commonParent = ScopeUtils.getCommonParent(referenceElements);
            assert (commonParent != null);
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                PsiElement variableScope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class});
                assert (variableScope != null);
                if ((commonParent = ScopeUtils.moveOutOfLoops(commonParent, variableScope)) == null) {
                    return;
                }
            }
            if ((firstReferenceScope = PsiTreeUtil.getParentOfType((PsiElement)(referenceElement = referenceElements[0]), (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class})) == null) {
                return;
            }
            if (firstReferenceScope.equals(commonParent)) {
                newDeclaration = this.moveDeclarationToLocation(variable, referenceElement);
            } else {
                PsiElement commonParentChild = ScopeUtils.getChildWhichContainsElement(commonParent, referenceElement);
                if (commonParentChild == null) {
                    return;
                }
                PsiElement location = commonParentChild.getPrevSibling();
                newDeclaration = this.createNewDeclaration(variable, initializer);
                newDeclaration = (PsiDeclarationStatement)commonParent.addAfter((PsiElement)newDeclaration, location);
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            newDeclaration = (PsiDeclarationStatement)codeStyleManager.reformat((PsiElement)newDeclaration);
            this.removeOldVariable(variable);
            if (this.isOnTheFly()) {
                HighlightUtils.highlightElement((PsiElement)newDeclaration);
            }
        }

        private void removeOldVariable(@NotNull PsiVariable variable) throws IncorrectOperationException {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeInspectionFix.removeOldVariable must not be null");
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)variable.getParent();
            if (declaration == null) {
                return;
            }
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length == 1) {
                declaration.delete();
            } else {
                variable.delete();
            }
        }

        private PsiDeclarationStatement createNewDeclaration(@NotNull PsiVariable variable, @Nullable PsiExpression initializer) throws IncorrectOperationException {
            String statementText;
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeInspectionFix.createNewDeclaration must not be null");
            }
            Project project = variable.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            String name = variable.getName();
            if (name == null) {
                name = "";
            }
            String comment = this.getCommentText(variable);
            PsiType type = variable.getType();
            String typeText = type.getCanonicalText();
            if (initializer == null) {
                statementText = typeText + ' ' + name + ';' + comment;
            } else {
                String initializerText = initializer.getText();
                statementText = typeText + ' ' + name + '=' + initializerText + ';' + comment;
            }
            PsiDeclarationStatement newDeclaration = (PsiDeclarationStatement)factory.createStatementFromText(statementText, (PsiElement)variable);
            PsiLocalVariable newVariable = (PsiLocalVariable)newDeclaration.getDeclaredElements()[0];
            PsiModifierList newModifierList = newVariable.getModifierList();
            PsiModifierList modifierList = variable.getModifierList();
            if (newModifierList != null && modifierList != null) {
                PsiAnnotation[] annotations;
                newModifierList.setModifierProperty("final", variable.hasModifierProperty("final"));
                for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
                    newModifierList.add((PsiElement)annotation);
                }
            }
            return newDeclaration;
        }

        private String getCommentText(PsiVariable variable) {
            PsiDeclarationStatement parentDeclaration = (PsiDeclarationStatement)variable.getParent();
            PsiElement[] declaredElements = parentDeclaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return "";
            }
            PsiElement lastChild = parentDeclaration.getLastChild();
            if (!(lastChild instanceof PsiComment)) {
                return "";
            }
            PsiElement prevSibling = lastChild.getPrevSibling();
            if (prevSibling instanceof PsiWhiteSpace) {
                return prevSibling.getText() + lastChild.getText();
            }
            return lastChild.getText();
        }

        private PsiDeclarationStatement moveDeclarationToLocation(@NotNull PsiVariable variable, @NotNull PsiElement location) throws IncorrectOperationException {
            PsiExpressionStatement expressionStatement;
            PsiExpression expression;
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeInspectionFix.moveDeclarationToLocation must not be null");
            }
            if (location == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeInspectionFix.moveDeclarationToLocation must not be null");
            }
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)location, PsiStatement.class, (boolean)false);
            assert (statement != null);
            PsiElement statementParent = statement.getParent();
            while (statementParent instanceof PsiStatement && !(statementParent instanceof PsiForStatement)) {
                statement = (PsiStatement)statementParent;
                statementParent = statement.getParent();
            }
            assert (statementParent != null);
            PsiExpression initializer = variable.getInitializer();
            if (TooBroadScopeInspection.this.isMoveable(initializer) && statement instanceof PsiExpressionStatement && (expression = (expressionStatement = (PsiExpressionStatement)statement).getExpression()) instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                PsiExpression rhs = assignmentExpression.getRExpression();
                PsiExpression lhs = assignmentExpression.getLExpression();
                IElementType tokenType = assignmentExpression.getOperationTokenType();
                if (location.equals(lhs) && JavaTokenType.EQ == tokenType && !VariableAccessUtils.variableIsUsed(variable, (PsiElement)rhs)) {
                    PsiDeclarationStatement newDeclaration = this.createNewDeclaration(variable, rhs);
                    newDeclaration = (PsiDeclarationStatement)statementParent.addBefore((PsiElement)newDeclaration, (PsiElement)statement);
                    PsiElement parent = assignmentExpression.getParent();
                    assert (parent != null);
                    parent.delete();
                    return newDeclaration;
                }
            }
            PsiDeclarationStatement newDeclaration = this.createNewDeclaration(variable, initializer);
            if (statement instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)statement;
                PsiStatement initialization = forStatement.getInitialization();
                newDeclaration = (PsiDeclarationStatement)forStatement.addBefore((PsiElement)newDeclaration, (PsiElement)initialization);
                if (initialization != null) {
                    initialization.delete();
                }
                return newDeclaration;
            }
            return (PsiDeclarationStatement)statementParent.addBefore((PsiElement)newDeclaration, (PsiElement)statement);
        }
    }
}

