/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class MisorderedAssertEqualsParametersInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("misordered.assert.equals.parameters.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/MisorderedAssertEqualsParametersInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("misordered.assert.equals.parameters.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/MisorderedAssertEqualsParametersInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new FlipParametersFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MisorderedAssertEqualsParametersVisitor();
    }

    private static class MisorderedAssertEqualsParametersVisitor
    extends BaseInspectionVisitor {
        private MisorderedAssertEqualsParametersVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            int actualPosition;
            int expectedPosition;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/MisorderedAssertEqualsParametersInspection$MisorderedAssertEqualsParametersVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!MisorderedAssertEqualsParametersVisitor.isAssertEquals(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiMethod method = (PsiMethod)methodExpression.resolve();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() == 0) {
                return;
            }
            PsiManager psiManager = expression.getManager();
            Project project = psiManager.getProject();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiClassType stringType = PsiType.getJavaLangString((PsiManager)psiManager, (GlobalSearchScope)scope);
            PsiParameter[] parameters = parameterList.getParameters();
            PsiType parameterType1 = parameters[0].getType();
            if (parameterType1.equals(stringType) && parameters.length > 2) {
                expectedPosition = 1;
                actualPosition = 2;
            } else {
                expectedPosition = 0;
                actualPosition = 1;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (actualPosition >= arguments.length) {
                return;
            }
            PsiExpression expectedArgument = arguments[expectedPosition];
            PsiExpression actualArgument = arguments[actualPosition];
            if (expectedArgument == null || actualArgument == null) {
                return;
            }
            if (MisorderedAssertEqualsParametersVisitor.isLiteralOrConstant(expectedArgument)) {
                return;
            }
            if (!MisorderedAssertEqualsParametersVisitor.isLiteralOrConstant(actualArgument)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean isLiteralOrConstant(PsiExpression expression) {
            if (expression instanceof PsiLiteralExpression) {
                return true;
            }
            if (!(expression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)target;
            return field.hasModifierProperty("static") && field.hasModifierProperty("final");
        }

        private static boolean isAssertEquals(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"assertEquals".equals(methodName)) {
                return false;
            }
            PsiMethod method = (PsiMethod)methodExpression.resolve();
            if (method == null) {
                return false;
            }
            PsiClass targetClass = method.getContainingClass();
            if (targetClass == null) {
                return false;
            }
            return ClassUtils.isSubclass(targetClass, "junit.framework.Assert") || ClassUtils.isSubclass(targetClass, "org.junit.Assert");
        }
    }

    private static class FlipParametersFix
    extends InspectionGadgetsFix {
        private FlipParametersFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("misordered.assert.equals.parameters.flip.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/MisorderedAssertEqualsParametersInspection$FlipParametersFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            int actualPosition;
            int expectedPosition;
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = methodNameIdentifier.getParent();
            assert (parent != null);
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent.getParent();
            assert (callExpression != null);
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            PsiMethod method = (PsiMethod)methodExpression.resolve();
            assert (method != null);
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiManager psiManager = callExpression.getManager();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiClassType stringType = PsiType.getJavaLangString((PsiManager)psiManager, (GlobalSearchScope)scope);
            PsiType parameterType1 = parameters[0].getType();
            if (parameterType1.equals(stringType) && parameters.length > 2) {
                expectedPosition = 1;
                actualPosition = 2;
            } else {
                expectedPosition = 0;
                actualPosition = 1;
            }
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression expectedArgument = arguments[expectedPosition];
            PsiExpression actualArgument = arguments[actualPosition];
            String actualArgumentText = actualArgument.getText();
            String expectedArgumentText = expectedArgument.getText();
            FlipParametersFix.replaceExpression(expectedArgument, actualArgumentText);
            FlipParametersFix.replaceExpression(actualArgument, expectedArgumentText);
        }
    }
}

