/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.junit.ContainsAssertionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class TestMethodWithoutAssertionInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("JUnitTestMethodWithNoAssertions" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestMethodWithoutAssertionInspection.getID must not return null");
        }
        return "JUnitTestMethodWithNoAssertions";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.method.without.assertion.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestMethodWithoutAssertionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("test.method.without.assertion.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestMethodWithoutAssertionInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestMethodWithoutAssertionVisitor();
    }

    private static class TestMethodWithoutAssertionVisitor
    extends BaseInspectionVisitor {
        private TestMethodWithoutAssertionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/TestMethodWithoutAssertionInspection$TestMethodWithoutAssertionVisitor.visitMethod must not be null");
            }
            super.visitMethod(method);
            if (!TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            PsiModifierList modifierList = method.getModifierList();
            PsiAnnotation testAnnotation = modifierList.findAnnotation("org.junit.Test");
            if (testAnnotation != null) {
                PsiNameValuePair[] nameValuePairs;
                PsiAnnotationParameterList parameterList = testAnnotation.getParameterList();
                for (PsiNameValuePair nameValuePair : nameValuePairs = parameterList.getAttributes()) {
                    String parameterName = nameValuePair.getName();
                    if (!"expected".equals(parameterName)) continue;
                    return;
                }
            }
            ContainsAssertionVisitor visitor = new ContainsAssertionVisitor();
            method.accept((PsiElementVisitor)visitor);
            if (visitor.containsAssertion()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

