/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.NCSSVisitor;
import org.jetbrains.annotations.NotNull;

public class NonCommentSourceStatementsInspection
extends MethodMetricInspection {
    private static final int DEFAULT_LIMIT = 30;

    @NotNull
    public String getID() {
        if ("OverlyLongMethod" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/NonCommentSourceStatementsInspection.getID must not return null");
        }
        return "OverlyLongMethod";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.comment.source.statements.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/NonCommentSourceStatementsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 30;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("non.comment.source.statements.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer statementCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("non.comment.source.statements.problem.descriptor", statementCount);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/NonCommentSourceStatementsInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonCommentSourceStatementsMethodVisitor();
    }

    private class NonCommentSourceStatementsMethodVisitor
    extends BaseInspectionVisitor {
        private NonCommentSourceStatementsMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/methodmetrics/NonCommentSourceStatementsInspection$NonCommentSourceStatementsMethodVisitor.visitMethod must not be null");
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            NCSSVisitor visitor = new NCSSVisitor();
            method.accept((PsiElementVisitor)visitor);
            int count = visitor.getStatementCount();
            if (count <= NonCommentSourceStatementsInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, count);
        }
    }
}

