/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.ui.CheckBox;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StaticVariableNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 5;
    private static final int DEFAULT_MAX_LENGTH = 32;
    public boolean checkMutableFinals = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.variable.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/StaticVariableNamingConventionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        String fieldName = (String)infos[0];
        if (fieldName.length() < this.getMinLength()) {
            string = InspectionGadgetsBundle.message("static.variable.naming.convention.problem.descriptor.short", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/StaticVariableNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        if (fieldName.length() > this.getMaxLength()) {
            string = InspectionGadgetsBundle.message("static.variable.naming.convention.problem.descriptor.long", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/StaticVariableNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("static.variable.naming.convention.problem.descriptor.regex.mismatch", this.getRegex());
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/StaticVariableNamingConventionInspection.buildErrorString must not return null");
    }

    @Override
    protected String getDefaultRegex() {
        return "s_[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 5;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public Collection<? extends JComponent> createExtraOptions() {
        return Arrays.asList(new CheckBox(InspectionGadgetsBundle.message("static.variable.naming.convention.mutable.option", new Object[0]), (InspectionProfileEntry)this, "checkMutableFinals"));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            String name;
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/StaticVariableNamingConventionInspection$NamingConventionsVisitor.visitField must not be null");
            }
            if (!field.hasModifierProperty("static")) {
                return;
            }
            if (field.hasModifierProperty("final")) {
                if (!StaticVariableNamingConventionInspection.this.checkMutableFinals) {
                    return;
                }
                PsiType type = field.getType();
                if (ClassUtils.isImmutable(type)) {
                    return;
                }
            }
            if ((name = field.getName()) == null) {
                return;
            }
            if (StaticVariableNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerFieldError(field, name);
        }
    }
}

