/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class UpperCaseFieldNameNotConstantInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("upper.case.field.name.not.constant.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/UpperCaseFieldNameNotConstantInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("NonConstantFieldWithUpperCaseName" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/UpperCaseFieldNameNotConstantInspection.getID must not return null");
        }
        return "NonConstantFieldWithUpperCaseName";
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("upper.case.field.name.not.constant.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/UpperCaseFieldNameNotConstantInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UpperCaseFieldNameNotConstantVisitor();
    }

    private static class UpperCaseFieldNameNotConstantVisitor
    extends BaseInspectionVisitor {
        private UpperCaseFieldNameNotConstantVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/UpperCaseFieldNameNotConstantInspection$UpperCaseFieldNameNotConstantVisitor.visitField must not be null");
            }
            super.visitField(field);
            if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                return;
            }
            String fieldName = field.getName();
            if (fieldName == null) {
                return;
            }
            if (!fieldName.equals(fieldName.toUpperCase())) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

