/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean statementMayCompleteNormally(@Nullable PsiStatement statement) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiReturnStatement || statement instanceof PsiThrowStatement) {
            return false;
        }
        if (statement instanceof PsiExpressionListStatement || statement instanceof PsiEmptyStatement || statement instanceof PsiAssertStatement || statement instanceof PsiDeclarationStatement) {
            return true;
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return true;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return true;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return true;
            }
            PsiClass aClass = method.getContainingClass();
            String className = aClass.getQualifiedName();
            return !"java.lang.System".equals(className);
        }
        if (statement instanceof PsiForStatement) {
            return ControlFlowUtils.forStatementMayReturnNormally((PsiForStatement)statement);
        }
        if (statement instanceof PsiForeachStatement) {
            return ControlFlowUtils.foreachStatementMayReturnNormally((PsiForeachStatement)statement);
        }
        if (statement instanceof PsiWhileStatement) {
            return ControlFlowUtils.whileStatementMayReturnNormally((PsiWhileStatement)statement);
        }
        if (statement instanceof PsiDoWhileStatement) {
            return ControlFlowUtils.doWhileStatementMayReturnNormally((PsiDoWhileStatement)statement);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiCodeBlock body = ((PsiSynchronizedStatement)statement).getBody();
            return ControlFlowUtils.codeBlockMayCompleteNormally(body);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement).getCodeBlock();
            return ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
        }
        if (statement instanceof PsiLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((PsiLabeledStatement)statement);
        }
        if (statement instanceof PsiIfStatement) {
            return ControlFlowUtils.ifStatementMayReturnNormally((PsiIfStatement)statement);
        }
        if (statement instanceof PsiTryStatement) {
            return ControlFlowUtils.tryStatementMayReturnNormally((PsiTryStatement)statement);
        }
        if (statement instanceof PsiSwitchStatement) {
            return ControlFlowUtils.switchStatementMayReturnNormally((PsiSwitchStatement)statement);
        }
        return true;
    }

    private static boolean doWhileStatementMayReturnNormally(@NotNull PsiDoWhileStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.doWhileStatementMayReturnNormally must not be null");
        }
        PsiExpression test = loopStatement.getCondition();
        PsiStatement body = loopStatement.getBody();
        return ControlFlowUtils.statementMayCompleteNormally(body) && !BoolUtils.isTrue(test) || ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement);
    }

    private static boolean whileStatementMayReturnNormally(@NotNull PsiWhileStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.whileStatementMayReturnNormally must not be null");
        }
        PsiExpression test = loopStatement.getCondition();
        return !BoolUtils.isTrue(test) || ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement);
    }

    private static boolean forStatementMayReturnNormally(@NotNull PsiForStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.forStatementMayReturnNormally must not be null");
        }
        PsiExpression test = loopStatement.getCondition();
        if (ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement)) {
            return true;
        }
        if (test == null) {
            return false;
        }
        return !BoolUtils.isTrue(test);
    }

    private static boolean foreachStatementMayReturnNormally(@NotNull PsiForeachStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.foreachStatementMayReturnNormally must not be null");
        }
        return true;
    }

    private static boolean switchStatementMayReturnNormally(@NotNull PsiSwitchStatement switchStatement) {
        if (switchStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.switchStatementMayReturnNormally must not be null");
        }
        if (ControlFlowUtils.statementIsBreakTarget((PsiStatement)switchStatement)) {
            return true;
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return true;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return true;
        }
        int numCases = 0;
        boolean hasDefaultCase = false;
        for (PsiStatement statement : statements) {
            PsiBreakStatement breakStatement;
            PsiSwitchLabelStatement switchLabelStatement;
            if (statement instanceof PsiSwitchLabelStatement && (switchLabelStatement = (PsiSwitchLabelStatement)statement).isDefaultCase()) {
                hasDefaultCase = true;
            }
            if (statement instanceof PsiBreakStatement && (breakStatement = (PsiBreakStatement)statement).getLabelIdentifier() == null) {
                return true;
            }
            ++numCases;
        }
        boolean isEnum = ControlFlowUtils.isEnumSwitch(switchStatement);
        if (!hasDefaultCase && !isEnum) {
            return true;
        }
        if (!hasDefaultCase && isEnum) {
            PsiExpression expression = switchStatement.getExpression();
            if (expression == null) {
                return true;
            }
            PsiClassType type = (PsiClassType)expression.getType();
            if (type == null) {
                return true;
            }
            PsiClass aClass = type.resolve();
            if (aClass == null) {
                return true;
            }
            PsiField[] fields = aClass.getFields();
            int numEnums = 0;
            for (PsiField field : fields) {
                PsiType fieldType = field.getType();
                if (!fieldType.equals(type)) continue;
                ++numEnums;
            }
            if (numEnums != numCases) {
                return true;
            }
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements[statements.length - 1]);
    }

    private static boolean isEnumSwitch(PsiSwitchStatement statement) {
        PsiExpression expression = statement.getExpression();
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)type).resolve();
        if (aClass == null) {
            return false;
        }
        return aClass.isEnum();
    }

    private static boolean tryStatementMayReturnNormally(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock[] catchBlocks;
        if (tryStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.tryStatementMayReturnNormally must not be null");
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && !ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock)) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (ControlFlowUtils.codeBlockMayCompleteNormally(tryBlock)) {
            return true;
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (!ControlFlowUtils.codeBlockMayCompleteNormally(catchBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayReturnNormally(@NotNull PsiIfStatement ifStatement) {
        if (ifStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.ifStatementMayReturnNormally must not be null");
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
            return true;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return elseBranch == null || ControlFlowUtils.statementMayCompleteNormally(elseBranch);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull PsiLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.labeledStatementMayCompleteNormally must not be null");
        }
        PsiStatement statement = labeledStatement.getStatement();
        if (statement == null) {
            return false;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statement) || ControlFlowUtils.statementIsBreakTarget(statement);
    }

    public static boolean codeBlockMayCompleteNormally(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return true;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.statementIsBreakTarget must not be null");
        }
        BreakFinder breakFinder = new BreakFinder(statement);
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    public static boolean statementContainsReturn(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.statementContainsReturn must not be null");
        }
        ReturnFinder returnFinder = new ReturnFinder();
        statement.accept((PsiElementVisitor)returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.statementIsContinueTarget must not be null");
        }
        ContinueFinder continueFinder = new ContinueFinder(statement);
        statement.accept((PsiElementVisitor)continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean statementContainsSystemExit(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.statementContainsSystemExit must not be null");
        }
        SystemExitFinder systemExitFinder = new SystemExitFinder();
        statement.accept((PsiElementVisitor)systemExitFinder);
        return systemExitFinder.exitFound();
    }

    public static boolean elementContainsCallToMethod(PsiElement context, String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypes) {
        MethodCallFinder methodCallFinder = new MethodCallFinder(containingClassName, returnType, methodName, parameterTypes);
        context.accept((PsiElementVisitor)methodCallFinder);
        return methodCallFinder.containsCallToMethod();
    }

    public static boolean isInLoop(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.isInLoop must not be null");
        }
        PsiLoopStatement loopStatement = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class);
        if (loopStatement == null) {
            return false;
        }
        PsiStatement body = loopStatement.getBody();
        if (body == null) {
            return false;
        }
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    public static boolean isInFinallyBlock(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.isInFinallyBlock must not be null");
        }
        PsiElement currentElement = element;
        PsiTryStatement tryStatement;
        while ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiTryStatement.class)) != null) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock != null && PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)currentElement, (boolean)true)) {
                PsiMethod elementMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiMethod.class);
                PsiMethod finallyMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)finallyBlock, PsiMethod.class);
                return elementMethod != null && elementMethod.equals(finallyMethod);
            }
            currentElement = tryStatement;
        }
        return false;
    }

    public static boolean isInCatchBlock(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.isInCatchBlock must not be null");
        }
        PsiElement currentElement = element;
        PsiTryStatement tryStatement;
        while ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class})) != null) {
            PsiCodeBlock[] catchBlocks;
            for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)catchBlock, (PsiElement)currentElement, (boolean)true)) continue;
                return true;
            }
            currentElement = tryStatement;
        }
        return false;
    }

    public static boolean isInExitStatement(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.isInExitStatement must not be null");
        }
        return ControlFlowUtils.isInReturnStatementArgument(expression) || ControlFlowUtils.isInThrowStatementArgument(expression);
    }

    private static boolean isInReturnStatementArgument(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.isInReturnStatementArgument must not be null");
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiReturnStatement.class);
        return returnStatement != null;
    }

    private static boolean isInThrowStatementArgument(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.isInThrowStatementArgument must not be null");
        }
        PsiThrowStatement throwStatement = (PsiThrowStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiThrowStatement.class);
        return throwStatement != null;
    }

    @Nullable
    public static PsiStatement stripBraces(@Nullable PsiStatement statement) {
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement block = (PsiBlockStatement)statement;
            PsiCodeBlock codeBlock = block.getCodeBlock();
            PsiStatement[] statements = codeBlock.getStatements();
            if (statements.length == 1) {
                return statements[0];
            }
            return block;
        }
        return statement;
    }

    public static boolean statementCompletesWithStatement(@NotNull PsiStatement containingStatement, @NotNull PsiStatement statement) {
        if (containingStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.statementCompletesWithStatement must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.statementCompletesWithStatement must not be null");
        }
        PsiStatement statementToCheck = statement;
        while (!statementToCheck.equals(containingStatement)) {
            PsiElement container = ControlFlowUtils.getContainingStatementOrBlock((PsiElement)statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof PsiCodeBlock && !ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                return false;
            }
            if (container instanceof PsiLoopStatement) {
                return false;
            }
            statementToCheck = container;
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull PsiCodeBlock body, @NotNull PsiStatement statement) {
        if (body == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.blockCompletesWithStatement must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.blockCompletesWithStatement must not be null");
        }
        PsiStatement statementToCheck = statement;
        while (statementToCheck != null) {
            PsiElement container = ControlFlowUtils.getContainingStatementOrBlock((PsiElement)statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof PsiLoopStatement) {
                return false;
            }
            if (container instanceof PsiCodeBlock) {
                if (!ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = PsiTreeUtil.getParentOfType((PsiElement)container, PsiStatement.class);
                continue;
            }
            statementToCheck = container;
        }
        return false;
    }

    @Nullable
    private static PsiElement getContainingStatementOrBlock(@NotNull PsiElement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.getContainingStatementOrBlock must not be null");
        }
        return PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class});
    }

    private static boolean statementIsLastInBlock(@NotNull PsiCodeBlock block, @NotNull PsiStatement statement) {
        if (block == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.statementIsLastInBlock must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.statementIsLastInBlock must not be null");
        }
        PsiStatement[] statements = block.getStatements();
        for (int i = statements.length - 1; i >= 0; --i) {
            PsiStatement childStatement = statements[i];
            if (statement.equals(childStatement)) {
                return true;
            }
            if (statement instanceof PsiEmptyStatement) continue;
            return false;
        }
        return false;
    }

    public static boolean methodAlwaysThrowsException(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils.methodAlwaysThrowsException must not be null");
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return true;
        }
        ReturnFinder returnFinder = new ReturnFinder();
        body.accept((PsiElementVisitor)returnFinder);
        if (returnFinder.returnFound()) {
            return false;
        }
        return !ControlFlowUtils.codeBlockMayCompleteNormally(body);
    }

    public static class MethodCallFinder
    extends JavaRecursiveElementVisitor {
        private final String containingClassName;
        private final PsiType returnType;
        private final String methodName;
        private final PsiType[] parameterTypeNames;
        private boolean containsCallToMethod = false;

        MethodCallFinder(String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypeNames) {
            this.containingClassName = containingClassName;
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameterTypeNames = parameterTypeNames;
        }

        public boolean containsCallToMethod() {
            return this.containsCallToMethod;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isCallToMethod(expression, this.containingClassName, this.returnType, this.methodName, this.parameterTypeNames)) {
                return;
            }
            this.containsCallToMethod = true;
        }
    }

    private static class ContinueFinder
    extends JavaRecursiveElementVisitor {
        private boolean m_found;
        private int m_nestingDepth;
        private String m_label;

        private ContinueFinder(@NotNull PsiStatement target) {
            if (target == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder.<init> must not be null");
            }
            this.m_found = false;
            this.m_nestingDepth = 0;
            this.m_label = null;
            if (target.getParent() instanceof PsiLabeledStatement) {
                PsiLabeledStatement labeledStatement = (PsiLabeledStatement)target.getParent();
                PsiIdentifier identifier = labeledStatement.getLabelIdentifier();
                this.m_label = identifier.getText();
            }
        }

        public boolean continueFound() {
            return this.m_found;
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder.visitContinueStatement must not be null");
            }
            if (this.m_found) {
                return;
            }
            super.visitContinueStatement(statement);
            PsiIdentifier labelIdentifier = statement.getLabelIdentifier();
            if (this.m_nestingDepth == 1 && labelIdentifier == null) {
                this.m_found = true;
            } else if (this.labelMatches(labelIdentifier)) {
                this.m_found = true;
            }
        }

        private boolean labelMatches(PsiIdentifier labelIdentifier) {
            if (labelIdentifier == null) {
                return false;
            }
            String labelText = labelIdentifier.getText();
            return labelText.equals(this.m_label);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder.visitDoWhileStatement must not be null");
            }
            if (this.m_found) {
                return;
            }
            ++this.m_nestingDepth;
            super.visitDoWhileStatement(statement);
            --this.m_nestingDepth;
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder.visitForStatement must not be null");
            }
            if (this.m_found) {
                return;
            }
            ++this.m_nestingDepth;
            super.visitForStatement(statement);
            --this.m_nestingDepth;
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder.visitForeachStatement must not be null");
            }
            if (this.m_found) {
                return;
            }
            ++this.m_nestingDepth;
            super.visitForeachStatement(statement);
            --this.m_nestingDepth;
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder.visitWhileStatement must not be null");
            }
            if (this.m_found) {
                return;
            }
            ++this.m_nestingDepth;
            super.visitWhileStatement(statement);
            --this.m_nestingDepth;
        }
    }

    private static class BreakFinder
    extends JavaRecursiveElementVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private BreakFinder(@NotNull PsiStatement target) {
            if (target == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils$BreakFinder.<init> must not be null");
            }
            this.m_found = false;
            this.m_target = target;
        }

        public boolean breakFound() {
            return this.m_found;
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement breakStatement) {
            if (breakStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils$BreakFinder.visitBreakStatement must not be null");
            }
            if (this.m_found) {
                return;
            }
            super.visitBreakStatement(breakStatement);
            PsiStatement exitedStatement = breakStatement.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }
    }

    private static class ReturnFinder
    extends JavaRecursiveElementVisitor {
        private boolean m_found = false;

        private ReturnFinder() {
        }

        public boolean returnFound() {
            return this.m_found;
        }

        public void visitClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils$ReturnFinder.visitClass must not be null");
            }
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            if (returnStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils$ReturnFinder.visitReturnStatement must not be null");
            }
            if (this.m_found) {
                return;
            }
            super.visitReturnStatement(returnStatement);
            this.m_found = true;
        }
    }

    private static class SystemExitFinder
    extends JavaRecursiveElementVisitor {
        private boolean m_found = false;

        private SystemExitFinder() {
        }

        public boolean exitFound() {
            return this.m_found;
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils$SystemExitFinder.visitClass must not be null");
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ControlFlowUtils$SystemExitFinder.visitMethodCallExpression must not be null");
            }
            if (this.m_found) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            String className = aClass.getQualifiedName();
            if (!"java.lang.System".equals(className) && !"java.lang.Runtime".equals(className)) {
                return;
            }
            this.m_found = true;
        }
    }
}

