/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import org.jetbrains.annotations.NotNull;

public class SingletonUtil {
    private SingletonUtil() {
    }

    public static boolean isSingleton(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SingletonUtil.isSingleton must not be null");
        }
        if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
            return false;
        }
        if (!SingletonUtil.hasConstructor(aClass)) {
            return false;
        }
        if (SingletonUtil.hasVisibleConstructor(aClass)) {
            return false;
        }
        return SingletonUtil.containsOneStaticSelfInstance(aClass);
    }

    private static boolean containsOneStaticSelfInstance(PsiClass aClass) {
        PsiField[] fields = aClass.getFields();
        int numSelfInstances = 0;
        for (PsiField field : fields) {
            PsiType type;
            String fieldTypeName;
            String className = aClass.getQualifiedName();
            if (!field.hasModifierProperty("static") || !(fieldTypeName = (type = field.getType()).getCanonicalText()).equals(className)) continue;
            ++numSelfInstances;
        }
        return numSelfInstances == 1;
    }

    private static boolean hasConstructor(PsiClass aClass) {
        return aClass.getConstructors().length > 0;
    }

    private static boolean hasVisibleConstructor(PsiClass aClass) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = aClass.getConstructors()) {
            if (method.hasModifierProperty("public")) {
                return true;
            }
            if (method.hasModifierProperty("private") || method.hasModifierProperty("protected")) continue;
            return true;
        }
        return false;
    }
}

