/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class SerialVersionUIDNotStaticFinalInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("SerialVersionUIDWithWrongSignature" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerialVersionUIDNotStaticFinalInspection.getID must not return null");
        }
        return "SerialVersionUIDWithWrongSignature";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serialversionuid.private.static.final.long.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerialVersionUIDNotStaticFinalInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("serialversionuid.private.static.final.long.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/SerialVersionUIDNotStaticFinalInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerialVersionUIDNotStaticFinalVisitor();
    }

    private static class SerialVersionUIDNotStaticFinalVisitor
    extends BaseInspectionVisitor {
        private SerialVersionUIDNotStaticFinalVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiField[] fields;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/SerialVersionUIDNotStaticFinalInspection$SerialVersionUIDNotStaticFinalVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            PsiField badSerialVersionUIDField = null;
            for (PsiField field : fields = aClass.getFields()) {
                if (!SerialVersionUIDNotStaticFinalVisitor.isSerialVersionUID(field)) continue;
                if (!(field.hasModifierProperty("static") && field.hasModifierProperty("private") && field.hasModifierProperty("final"))) {
                    badSerialVersionUIDField = field;
                    break;
                }
                PsiType type = field.getType();
                if (PsiType.LONG.equals(type)) continue;
                badSerialVersionUIDField = field;
                break;
            }
            if (badSerialVersionUIDField == null) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerFieldError(badSerialVersionUIDField, new Object[0]);
        }

        private static boolean isSerialVersionUID(PsiField field) {
            String fieldName = field.getName();
            return "serialVersionUID".equals(fieldName);
        }
    }
}

