/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChainedMethodCallInspection
extends BaseInspection {
    public boolean m_ignoreFieldInitializations = true;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("chained.method.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ChainedMethodCallInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("chained.method.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ChainedMethodCallInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("chained.method.call.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreFieldInitializations");
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ChainedMethodCallVisitor();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChainedMethodCallFix();
    }

    private class ChainedMethodCallVisitor
    extends BaseInspectionVisitor {
        private ChainedMethodCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiElement field;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/ChainedMethodCallInspection$ChainedMethodCallVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression reference = expression.getMethodExpression();
            PsiExpression qualifier = reference.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!this.isCallExpression(qualifier)) {
                return;
            }
            if (ChainedMethodCallInspection.this.m_ignoreFieldInitializations && (field = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class)) != null) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private boolean isCallExpression(PsiExpression expression) {
            return (expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiMethodCallExpression || expression instanceof PsiNewExpression;
        }
    }

    private static class ChainedMethodCallFix
    extends InspectionGadgetsFix {
        private ChainedMethodCallFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("introduce.variable.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ChainedMethodCallInspection$ChainedMethodCallFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
            RefactoringActionHandler introduceHandler = factory.createIntroduceVariableHandler();
            PsiElement methodNameElement = descriptor.getPsiElement();
            PsiReferenceExpression methodCallExpression = (PsiReferenceExpression)methodNameElement.getParent();
            assert (methodCallExpression != null);
            PsiExpression qualifier = methodCallExpression.getQualifierExpression();
            DataManager dataManager = DataManager.getInstance();
            DataContext dataContext = dataManager.getDataContext();
            introduceHandler.invoke(project, new PsiElement[]{qualifier}, dataContext);
        }
    }
}

