/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class LiteralAsArgToStringEqualsInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("literal.as.arg.to.string.equals.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/LiteralAsArgToStringEqualsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String methodName = (String)infos[0];
        String string = InspectionGadgetsBundle.message("literal.as.arg.to.string.equals.problem.descriptor", methodName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/LiteralAsArgToStringEqualsInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LiteralAsArgToEqualsVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SwapEqualsFix();
    }

    private static class LiteralAsArgToEqualsVisitor
    extends BaseInspectionVisitor {
        private LiteralAsArgToEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/LiteralAsArgToStringEqualsInspection$LiteralAsArgToEqualsVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName) && !"equalsIgnoreCase".equals(methodName)) {
                return;
            }
            PsiExpressionList argList = expression.getArgumentList();
            PsiExpression[] args = argList.getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression argument = args[0];
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return;
            }
            if (!(argument instanceof PsiLiteralExpression)) {
                return;
            }
            if (!TypeUtils.isJavaLangString(argumentType)) {
                return;
            }
            PsiExpression target = methodExpression.getQualifierExpression();
            if (target instanceof PsiLiteralExpression) {
                return;
            }
            this.registerError((PsiElement)argument, methodName);
        }
    }

    private static class SwapEqualsFix
    extends InspectionGadgetsFix {
        private SwapEqualsFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("literal.as.arg.to.string.equals.flip.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/LiteralAsArgToStringEqualsInspection$SwapEqualsFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression argument = (PsiExpression)descriptor.getPsiElement();
            PsiElement argumentList = argument.getParent();
            PsiMethodCallExpression expression = (PsiMethodCallExpression)argumentList.getParent();
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression target = methodExpression.getQualifierExpression();
            String methodName = methodExpression.getReferenceName();
            PsiExpression strippedTarget = ParenthesesUtils.stripParentheses(target);
            if (strippedTarget == null) {
                return;
            }
            PsiExpression strippedArg = ParenthesesUtils.stripParentheses(argument);
            if (strippedArg == null) {
                return;
            }
            String callString = ParenthesesUtils.getPrecedence(strippedArg) > 1 ? '(' + strippedArg.getText() + ")." + methodName + '(' + strippedTarget.getText() + ')' : strippedArg.getText() + '.' + methodName + '(' + strippedTarget.getText() + ')';
            SwapEqualsFix.replaceExpression((PsiExpression)expression, callString);
        }
    }
}

